/*****************************************************************************

        GRAOUMF TRACKER 2
        Author: Laurent de Soras, 1996-2016

--- Legal stuff ---

This program is free software. It comes without any warranty, to
the extent permitted by applicable law. You can redistribute it
and/or modify it under the terms of the Do What The Fuck You Want
To Public License, Version 2, as published by Sam Hocevar. See
http://sam.zoy.org/wtfpl/COPYING for more details.

*****************************************************************************/



#if defined (SPLS_CURRENT_HEADER)
	#error Inclusion recursive du header SPLS.
#endif
#define	SPLS_CURRENT_HEADER

#if ! defined (SPLS_HEADER_INCLUDED)
#define	SPLS_HEADER_INCLUDED



/*\\\ INCLUDES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	"Popup.h"
#include	"Strng.h"

#include <string>
#include <vector>

#include	<cstdio>



/*\\\ CONSTANTES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

/* Formats internes des samples */
enum
{
	SPLS_FORMAT_RAW = 0,
	SPLS_FORMAT_AVR,
	SPLS_FORMAT_WAV,
	SPLS_FORMAT_AU
};

/* Type de compression d'un sample */
enum
{
	SPLS_PACK_TYPE_UNSUP = -1,	/* Format non supporte */
	SPLS_PACK_TYPE_PCM = 0,		/* Sample normal, en PCM */
	SPLS_PACK_TYPE_DISK			/* Sample sur disque (sert pour le champ header.codagev des chunks samples dans les songs) */
};

/* Tailles min/max des buffers, en samples */
#define	SPLS_RBUF_MINLEN		16		/* Taille minimum du buffer de repetition */
#define	SPLS_RBUF_MAXLEN		4096	/* Taille maximum du buffer de repetition */
#define	SPLS_D2DBUF_MINLEN	4096	/* Taille minimum d'un buffer de D2D */



/*\\\ TYPES & STRUCTURES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

typedef struct
{
	int		nbits;
	int		tracks;
	long		freq;
	long		length;
	long		repeat;
	long		replen;
	int64_t	data_offset;
	signed int	finetune;
	int		midi_note;
	int		volume;
	signed int	balance;
	int		loop_type;
	signed int	pack_type;
	bool		signed_flag;
	bool		acm_flag;			// Indique si l'ACM est utilise. Ne peut servir que lors du chargement en une seule traite.
	int		acm_type;			// Audio compression manager. Depend du systeme.
	int		byte_order;
	int		special;

	/* Utilise uniquement lors de la sauvegarde des donnees */
	long		position;	/* Position du bloc a sauver */
	long		block_len;	/* Longueur du bloc a sauver */

	/* Utilise uniquement par la routine de sauvegarde d'un morceau de sample brut */
	int64_t	file_position;	/* Indique ou prendre le bloc courant dans le fichier */
} SPLS_PRIMARY_INFO;

/* Structure contenant tous les pointeurs de fonctions utiles au chargement
   et a la sauvegarde d'un format de sample. */
typedef struct
{
	/* Nom, extension */
	const char	*name_0;
	const char	*ext_0;

	/* Sauvegarde */
	signed int	(*save_ptr) (FILE *file_ptr, int sample);
	signed int	(*save_header_ptr) (FILE *file_ptr, SPLS_PRIMARY_INFO *sample_info_ptr);
	signed int	(*save_data_ptr) (FILE *file_ptr, SPLS_PRIMARY_INFO *sample_info_ptr, void *mem_data_ptr, FILE *file_data_ptr);
	signed int	(*save_tail_ptr) (FILE *file_ptr, const SPLS_PRIMARY_INFO *sample_info_ptr);

	/* Chargement */
	signed int	(*get_primary_info_ptr) (FILE *file_ptr, SPLS_PRIMARY_INFO *sample_info_ptr);
	signed int	(*load_ptr) (FILE *file_ptr, int sample, SPLS_PRIMARY_INFO *sample_info_ptr);

	bool		import_flag;
	bool		export_flag;
} SPLS_FORMAT_ROUTINES;



/*\\\ PROTOTYPES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

signed int	SPLS_init (void);
void	SPLS_restore (void);

signed int	SPLS_select_sample_filename (std::vector <std::string> &total_name_arr, const char *title_0, bool save_flag, bool multiple_flag = false);

signed int	SPLS_save_sample (void);
signed int	SPLS_save_sample_direct (int sample, const char *filename_0);
signed int	SPLS_save_sample_header (FILE *file_ptr, SPLS_PRIMARY_INFO *sample_info_ptr);
signed int	SPLS_save_sample_data (FILE *file_ptr, SPLS_PRIMARY_INFO *sample_info_ptr, void *mem_data_ptr, FILE *file_data_ptr);
signed int	SPLS_save_sample_tail (FILE *file_ptr, const SPLS_PRIMARY_INFO *sample_info_ptr);

signed int	SPLS_save_raw_sample_block (FILE *file_ptr, const SPLS_PRIMARY_INFO *sample_info_ptr, void *mem_data_ptr, FILE *file_data_ptr);

signed int	SPLS_get_file_format (FILE *file_ptr);
signed int	SPLS_load_sample (bool multiple_flag);
signed int	SPLS_load_sample_direct (int sample, const char *filename_0);

void	SPLS_init_primary_info (SPLS_PRIMARY_INFO *sample_info_ptr, int sample);
signed int	SPLS_get_primary_info (FILE *file_ptr, int format, SPLS_PRIMARY_INFO	*sample_info_ptr);



/*\\\ VARIABLES EXTERNES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

extern int	SPLS_export_format;
extern bool	SPLS_signed_flag;

extern SPLS_FORMAT_ROUTINES	SPLS_format_routines [];
extern int	SPLS_nbr_formats;
extern Popup	*SPLS_import_format_popup_menu_ptr;
extern Popup	*SPLS_export_format_popup_menu_ptr;



/*\\\ FIN DU FICHIER \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#endif

#undef SPLS_CURRENT_HEADER
