/*****************************************************************************

        GRAOUMF TRACKER 2
        Author: Laurent de Soras, 1996-2016

--- Legal stuff ---

This program is free software. It comes without any warranty, to
the extent permitted by applicable law. You can redistribute it
and/or modify it under the terms of the Do What The Fuck You Want
To Public License, Version 2, as published by Sam Hocevar. See
http://sam.zoy.org/wtfpl/COPYING for more details.

*****************************************************************************/



#if defined (MIX_CURRENT_HEADER)
	#error Inclusion recursive du header MIX.
#endif
#define	MIX_CURRENT_HEADER

#if ! defined (MIX_HEADER_INCLUDED)
#define	MIX_HEADER_INCLUDED



/*\\\ INCLUDES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	"archi.h"
#include	"gt_limit.h"



/*\\\ CONSTANTES ET MACROS PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#define	MIX_MAX_FRAME_LENGTH			1024
#define	MIX_INIT_BUFFER_ZONE_SIZE	(GTK_NBRTRACKS_MAXI * GTK_NBROUT_MAXI * MIX_MAX_FRAME_LENGTH)
#define	MIX_CD_REPLAY_FREQ			44100

/* Qualite de mixage */
enum
{
	MIX_SOUND_QUALITY_NORMAL = 0,
	MIX_SOUND_QUALITY_BEST
};

/* Largeur du filtre de reconstruction, en samples. Doit etre pair. */
#define	MIX_INIT_RECONS_FLITER_WIDTH		64



/*\\\ TYPES & STRUCTURES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ PROTOTYPES DES FONCTIONS PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

signed int	MIX_init ();
void	MIX_restore ();

int	MIX_get_sound_quality ();
signed int	MIX_set_sound_quality (int quality);

void	MIX_create_mix_buffers ();
void	MIX_create_mix_array ();
void	MIX_do_mix ();
void	MIX_do_not_mix ();

void	MIX_set_sample_group (int group);
int	MIX_get_sample_group ();



/*\\\ VARIABLES EXTERNES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

extern LWORD	MIX_replay_freq;
extern LWORD	MIX_latency_time_ms;
extern LWORD	MIX_buffer_zone_size;

extern LWORD	MIX_frame_length;
extern float *	MIX_driver_out_buffer_ptr [GTK_NBROUT_MAXI];
extern float *	MIX_driver_in_buffer_ptr [GTK_NBRIN_MAXI];

extern int	MIX_recons_filter_width;



/*\\\ FIN DU FICHIER \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#endif

#undef MIX_CURRENT_HEADER
