/*****************************************************************************

        Sequence.h
        GRAOUMF TRACKER 2
        Author: Laurent de Soras, 1996-2016

--- Legal stuff ---

This program is free software. It comes without any warranty, to
the extent permitted by applicable law. You can redistribute it
and/or modify it under the terms of the Do What The Fuck You Want
To Public License, Version 2, as published by Sam Hocevar. See
http://sam.zoy.org/wtfpl/COPYING for more details.

*Tab=3***********************************************************************/



#pragma once
#if ! defined (gtp_Sequence_HEADER_INCLUDED)
#define gtp_Sequence_HEADER_INCLUDED

#if defined (_MSC_VER)
	#pragma warning (4 : 4250)
#endif



/*\\\ INCLUDE FILES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include "gtp/Cst.h"

#include <array>



namespace gtp
{



class Sequence
{

/*\\\ PUBLIC \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:

	enum PlayMode
	{
		PlayMode_STOP = 0,
		PlayMode_SONG,
		PlayMode_PATTERN,

		PlayMode_NBR_ELT
	};

	virtual        ~Sequence () = default;



/*\\\ PROTECTED \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

protected:



/*\\\ PRIVATE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:

	typedef std::array <int, Cst::_max_seq_len> PatList;

	PatList        _pat_list;
	int            _length       = 1;
	int            _reppos       = 0;

	double         _tempo        = 125;    // BPM
	int            _speed        = 6;
	PlayMode       _play_mode    = PlayMode_STOP;
	bool           _lin_per_flag = false;



/*\\\ FORBIDDEN MEMBER FUNCTIONS \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:

	               Sequence ()                               = delete;
	               Sequence (const Sequence &other)          = delete;
	Sequence &     operator = (const Sequence &other)        = delete;
	bool           operator == (const Sequence &other) const = delete;
	bool           operator != (const Sequence &other) const = delete;

}; // class Sequence



}  // namespace gtp



//#include "gtp/Sequence.hpp"



#endif   // gtp_Sequence_HEADER_INCLUDED



/*\\\ EOF \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
