/*****************************************************************************

        Score.h
        GRAOUMF TRACKER 2
        Author: Laurent de Soras, 1996-2016

--- Legal stuff ---

This program is free software. It comes without any warranty, to
the extent permitted by applicable law. You can redistribute it
and/or modify it under the terms of the Do What The Fuck You Want
To Public License, Version 2, as published by Sam Hocevar. See
http://sam.zoy.org/wtfpl/COPYING for more details.

*Tab=3***********************************************************************/



#pragma once
#if ! defined (gtp_Score_HEADER_INCLUDED)
#define gtp_Score_HEADER_INCLUDED

#if defined (_MSC_VER)
	#pragma warning (4 : 4250)
#endif



/*\\\ INCLUDE FILES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



namespace gtp
{



class Score
{

/*\\\ PUBLIC \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:

	virtual        ~Score () = default;



/*\\\ PROTECTED \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

protected:



/*\\\ PRIVATE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:

	class TimePos
	{
	public:
		int            _songpos = 0;
		int            _line    = 0;
	};

	// Playback state
	TimePos        _time_cur;              // Current playback position
	TimePos        _time_next;             // Next playback position if a jump is set
	bool           _time_next_flag;        // A jump is set
	int            _pat_cur;               // Currently played pattern
	int            _pat_delay;             // Indicates how many times we should repeat the current line (excluding the first occurence). Generally set to 0.



/*\\\ FORBIDDEN MEMBER FUNCTIONS \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:

	               Score ()                               = delete;
	               Score (const Score &other)             = delete;
	Score &        operator = (const Score &other)        = delete;
	bool           operator == (const Score &other) const = delete;
	bool           operator != (const Score &other) const = delete;

}; // class Score



}  // namespace gtp



//#include "gtp/Score.hpp"



#endif   // gtp_Score_HEADER_INCLUDED



/*\\\ EOF \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
