/*****************************************************************************

        Root.h
        GRAOUMF TRACKER 2
        Author: Laurent de Soras, 1996-2016

--- Legal stuff ---

This program is free software. It comes without any warranty, to
the extent permitted by applicable law. You can redistribute it
and/or modify it under the terms of the Do What The Fuck You Want
To Public License, Version 2, as published by Sam Hocevar. See
http://sam.zoy.org/wtfpl/COPYING for more details.

*Tab=3***********************************************************************/



#pragma once
#if ! defined (gtp_Root_HEADER_INCLUDED)
#define gtp_Root_HEADER_INCLUDED

#if defined (_MSC_VER)
	#pragma warning (4 : 4250)
#endif



/*\\\ INCLUDE FILES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include "gtp/Cst.h"
#include "gtp/MArray.h"
#include "gtp/PatternAin.h"
#include "gtp/PatternFx.h"
#include "gtp/PatternMidi.h"
#include "gtp/PatternSpl.h"
#include "gtp/Sequence.h"



namespace gtp
{



class Root
{

/*\\\ PUBLIC \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:

	               Root ()  = default;
	virtual        ~Root () = default;



/*\\\ PROTECTED \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

protected:



/*\\\ PRIVATE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:

	MArray <Sequence   , 1>
	               _sequence;

	MArray <PatternSpl , Cst::_max_nbr_pat>
	               _pat_spl;
	MArray <PatternAin , Cst::_max_nbr_pat>
	               _pat_ain;
	MArray <PatternFx  , Cst::_max_nbr_pat>
	               _pat_fx;
	MArray <PatternMidi, Cst::_max_nbr_pat>
	               _pat_midi;



/*\\\ FORBIDDEN MEMBER FUNCTIONS \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:

	               Root (const Root &other)              = delete;
	Root &         operator = (const Root &other)        = delete;
	bool           operator == (const Root &other) const = delete;
	bool           operator != (const Root &other) const = delete;

}; // class Root



}  // namespace gtp



//#include "gtp/Root.hpp"



#endif   // gtp_Root_HEADER_INCLUDED



/*\\\ EOF \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
