/*****************************************************************************

        MArray.hpp
        GRAOUMF TRACKER 2
        Author: Laurent de Soras, 1996-2016

--- Legal stuff ---

This program is free software. It comes without any warranty, to
the extent permitted by applicable law. You can redistribute it
and/or modify it under the terms of the Do What The Fuck You Want
To Public License, Version 2, as published by Sam Hocevar. See
http://sam.zoy.org/wtfpl/COPYING for more details.

*Tab=3***********************************************************************/



#if ! defined (gtp_MArray_CODEHEADER_INCLUDED)
#define gtp_MArray_CODEHEADER_INCLUDED



/*\\\ INCLUDE FILES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



namespace gtp
{



/*\\\ PUBLIC \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



template <typename T, int SZ>
MArray <T, SZ>::MArray (PoolData &pool_data, PoolRef &pool_ref)
:	_pool_data (pool_data)
,	_pool_ref (pool_ref)
,	_data_arr ()
{
	for (auto &ptr : _data_arr)
	{
		ptr = 0;
	}
}



template <typename T, int SZ>
MArray <T, SZ>::~MArray ()
{
	for (auto &ptr : _data_arr)
	{
		if (ptr != nullptr)
		{
			(*ptr)._val.destroy ();
			_pool_ref.return_cell (*ptr);
			ptr = 0;
		}
	}
}



template <typename T, int SZ>
typename MArray <T, SZ>::PoolData &	MArray <T, SZ>::use_pool ()
{
	return _pool_data;
}



template <typename T, int SZ>
RefPtr <T>	MArray <T, SZ>::use (int index) const
{
	assert (index >= 0);
	assert (index < _size);

	check_populated (index);

	return _data_arr [index]->_val;
}



template <typename T, int SZ>
void	MArray <T, SZ>::replace (int index, RefPtr <T> ref)
{
	assert (index >= 0);
	assert (index < _size);

	CellRef *      cell_ptr = _pool_ref.take_cell (true);
	assert (cell_ptr != 0);
	cell_ptr->_val = ref;

	CellRef *      old_cell_ptr = _data_arr [index].swap (cell_ptr);

	old_cell_ptr->_val.destroy ();
	_pool_ref.return_cell (*old_cell_ptr);
}



/*\\\ PROTECTED \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ PRIVATE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



template <typename T, int SZ>
void	MArray <T, SZ>::check_populated (int index)
{
	assert (index >= 0);
	assert (index < _size);

	if (_data_arr [index] == 0)
	{
		CellRef *      cell_ptr = _pool_ref.take_cell (true);
		assert (cell_ptr != 0);
		_data_arr [index] = cell_ptr;
	}
}



}  // namespace gtp



#endif   // gtp_MArray_CODEHEADER_INCLUDED



/*\\\ EOF \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
