/*****************************************************************************

        MArray.h
        GRAOUMF TRACKER 2
        Author: Laurent de Soras, 1996-2016

--- Legal stuff ---

This program is free software. It comes without any warranty, to
the extent permitted by applicable law. You can redistribute it
and/or modify it under the terms of the Do What The Fuck You Want
To Public License, Version 2, as published by Sam Hocevar. See
http://sam.zoy.org/wtfpl/COPYING for more details.

*Tab=3***********************************************************************/



#pragma once
#if ! defined (gtp_MArray_HEADER_INCLUDED)
#define gtp_MArray_HEADER_INCLUDED

#if defined (_MSC_VER)
	#pragma warning (4 : 4250)
#endif



/*\\\ INCLUDE FILES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include "conc/AtomicPtr.h"
#include "conc/CellPool.h"
#include "conc/LockFreeCell.h"
#include "gtp/RefPtr.h"

#include <array>



namespace gtp
{



template <typename T, int SZ>
class MArray
{

/*\\\ PUBLIC \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:

	static const int  _size = SZ;

	typedef T                        DataType;
	typedef RefPtr <T>               Ref;
	typedef conc::LockFreeCell <Ref> CellRef;
	typedef conc::CellPool <Ref>     PoolRef;
	typedef conc::CellPool <T>       PoolData;

	explicit       MArray (PoolData &pool_data, PoolRef &pool_ref);
	virtual        ~MArray ();

	PoolData &     use_pool ();
	RefPtr <T>     use (int index) const;
	void           replace (int index, RefPtr <T> ref);



/*\\\ PROTECTED \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

protected:



/*\\\ PRIVATE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:

	void           check_populated (int index);

	PoolData &     _pool_data;
	PoolRef &      _pool_ref;
	std::array <conc::AtomicPtr <CellRef>, SZ>
	               _data_arr;



/*\\\ FORBIDDEN MEMBER FUNCTIONS \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:

	               MArray ()                                       = delete;
	               MArray (const MArray <T, SZ> &other)            = delete;
	MArray <T, SZ> &
	               operator = (const MArray <T, SZ> &other)        = delete;
	bool           operator == (const MArray <T, SZ> &other) const = delete;
	bool           operator != (const MArray <T, SZ> &other) const = delete;

}; // class MArray



}  // namespace gtp



#include "gtp/MArray.hpp"



#endif   // gtp_MArray_HEADER_INCLUDED



/*\\\ EOF \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
