/*****************************************************************************

        CellSpl.hpp
        GRAOUMF TRACKER 2
        Author: Laurent de Soras, 1996-2016

--- Legal stuff ---

This program is free software. It comes without any warranty, to
the extent permitted by applicable law. You can redistribute it
and/or modify it under the terms of the Do What The Fuck You Want
To Public License, Version 2, as published by Sam Hocevar. See
http://sam.zoy.org/wtfpl/COPYING for more details.

*Tab=3***********************************************************************/



#if ! defined (gtp_CellSpl_CODEHEADER_INCLUDED)
#define gtp_CellSpl_CODEHEADER_INCLUDED



/*\\\ INCLUDE FILES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



namespace gtp
{



/*\\\ PUBLIC \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



void	CellSpl::clear ()
{
	_note    = 0;
	_instr   = 0;
	_fxnum   = 0;
	_fxparam = 0;
	_volume  = 0;
}



uint16_t	CellSpl::get_cmd () const
{
	return (_fxnum << 8) + _fxparam;
}



void	CellSpl::set_cmd (uint16_t cmd)
{
	_fxnum   = uint8_t ((cmd >> 8) & 0xFF);
	_fxparam = uint8_t ( cmd       & 0xFF);
}



uint8_t	CellSpl::get_vol () const
{
	return (_volume);
}



void	CellSpl::set_vol (uint8_t vol)
{
	_volume = vol;
}



/*\\\ PROTECTED \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ PRIVATE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



}  // namespace gtp



#endif   // gtp_CellSpl_CODEHEADER_INCLUDED



/*\\\ EOF \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
