/*****************************************************************************

        CellFx.h
        GRAOUMF TRACKER 2
        Author: Laurent de Soras, 1996-2016

--- Legal stuff ---

This program is free software. It comes without any warranty, to
the extent permitted by applicable law. You can redistribute it
and/or modify it under the terms of the Do What The Fuck You Want
To Public License, Version 2, as published by Sam Hocevar. See
http://sam.zoy.org/wtfpl/COPYING for more details.

*Tab=3***********************************************************************/



#pragma once
#if ! defined (gtp_CellFx_HEADER_INCLUDED)
#define gtp_CellFx_HEADER_INCLUDED

#if defined (_MSC_VER)
	#pragma warning (4 : 4250)
#endif



/*\\\ INCLUDE FILES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include "gtp/TrackType.h"

#include <cstdint>



namespace gtp
{



class CellFx
{

/*\\\ PUBLIC \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:

	enum Ofs
	{
		Ofs_COMNUM1 = 0,
		Ofs_COMNUM2,
		Ofs_COMPARAM_MSB,
		Ofs_COMPARAM_LSB,
		Ofs_FXNUM,
		Ofs_FXPARAM,
		Ofs_VOL,

		Ofs_NBR_ELT
	};

	inline void    clear ();
	inline uint16_t
	               get_cmd () const;
	inline void    set_cmd (uint16_t cmd);
	inline uint8_t get_vol () const;
	inline void    set_vol (uint8_t vol);

	uint8_t        _comnum1;
	uint8_t        _comnum2;
	uint8_t        _comparam_msb;
	uint8_t        _comparam_lsb;
	uint8_t        _fxnum;
	uint8_t        _fxparam;
	uint8_t        _volume;

	static const TrackType
	               _type = TrackType_FX;



/*\\\ PROTECTED \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

protected:



/*\\\ PRIVATE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:



/*\\\ FORBIDDEN MEMBER FUNCTIONS \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:

}; // class CellFx



}  // namespace gtp



#include "gtp/CellFx.hpp"



#endif   // gtp_CellFx_HEADER_INCLUDED



/*\\\ EOF \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
