/*****************************************************************************

        ObserverInterface.h
        Author: Laurent de Soras, 2016

--- Legal stuff ---

This program is free software. It comes without any warranty, to
the extent permitted by applicable law. You can redistribute it
and/or modify it under the terms of the Do What The Fuck You Want
To Public License, Version 2, as published by Sam Hocevar. See
http://sam.zoy.org/wtfpl/COPYING for more details.

*Tab=3***********************************************************************/



#pragma once
#if ! defined (fstb_util_ObserverInterface_HEADER_INCLUDED)
#define fstb_util_ObserverInterface_HEADER_INCLUDED

#if defined (_MSC_VER)
	#pragma warning (4 : 4250)
#endif



/*\\\ INCLUDE FILES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



namespace fstb
{
namespace util
{



class ObservableInterface;

class ObserverInterface
{

/*\\\ PUBLIC \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:

	               ObserverInterface ()                          = default;
	               ObserverInterface (const ObserverInterface &other) = default;
	               ObserverInterface (ObserverInterface &&other) = default;
	virtual        ~ObserverInterface ()                         = default;

	virtual ObserverInterface &
	               operator = (const ObserverInterface &other)   = default;
	virtual ObserverInterface &
	               operator = (ObserverInterface &&other)        = default;

	inline void		update (ObservableInterface &subject);



/*\\\ PROTECTED \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

protected:

	virtual void	do_update (ObservableInterface &subject) = 0;



}; // class ObserverInterface



}  // namespace util
}  // namespace fstb



#include "fstb/util/ObserverInterface.hpp"



#endif   // fstb_util_ObserverInterface_HEADER_INCLUDED



/*\\\ EOF \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
