/*****************************************************************************

        NonConst.h
        Author: Laurent de Soras, 2018

--- Legal stuff ---

This program is free software. It comes without any warranty, to
the extent permitted by applicable law. You can redistribute it
and/or modify it under the terms of the Do What The Fuck You Want
To Public License, Version 2, as published by Sam Hocevar. See
http://sam.zoy.org/wtfpl/COPYING for more details.

*Tab=3***********************************************************************/



#pragma once
#if ! defined (fstb_lang_NonConst_HEADER_INCLUDED)
#define fstb_lang_NonConst_HEADER_INCLUDED

#if defined (_MSC_VER)
	#pragma warning (4 : 4250)
#endif



/*\\\ INCLUDE FILES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



namespace fstb
{
namespace lang
{



template <typename T>
struct NonConst
{
	typedef T type;
};
template <typename T>
struct NonConst <T const>
{
	typedef T type;
}; // By value
template <typename T>
struct NonConst <T const &>
{
	typedef T& type;
}; // By reference
template <typename T>
struct NonConst <T const *>
{
	typedef T * type;
}; // By pointer
template <typename T>
struct NonConst <T const &&>
{
	typedef T && type;
}; // By rvalue-reference



}  // namespace lang
}  // namespace fstb



//#include "fstb/lang/NonConst.hpp"



#endif   // fstb_lang_NonConst_HEADER_INCLUDED



/*\\\ EOF \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
