/*****************************************************************************

        GRAOUMF TRACKER 2
        Author: Laurent de Soras, 1996-2016

--- Legal stuff ---

This program is free software. It comes without any warranty, to
the extent permitted by applicable law. You can redistribute it
and/or modify it under the terms of the Do What The Fuck You Want
To Public License, Version 2, as published by Sam Hocevar. See
http://sam.zoy.org/wtfpl/COPYING for more details.

*****************************************************************************/



#if defined (FNAM_CURRENT_HEADER)
	#error Inclusion recursive du header FNAM.
#endif
#define	FNAM_CURRENT_HEADER

#if ! defined (FNAM_HEADER_INCLUDED)
#define	FNAM_HEADER_INCLUDED



/*\\\ INCLUDES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	"Strng.h"



/*\\\ CONSTANTES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#define	FNAM_FILENAME_MAXLEN		255		/* Taille maximum d'un nom de fichier */
#define	FNAM_PATHNAME_MAXLEN		32767		/* Taille maximum d'un nom de chemin */



/*\\\ TYPES & STRUCTURES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ PROTOTYPES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

String	FNAM_get_drive (String path);
String	FNAM_get_path (String path);
String	FNAM_get_full_path (String path);
String	FNAM_get_full_filename (String path);
String	FNAM_parse_path_ext (String path);
bool	FNAM_test_filename (const char *filename_0, const char *mask_0);
String	FNAM_get_abs_path_from_rel (String main_path, String rel_path);
String	FNAM_get_rel_path_from_abs (String main_path, String abs_path);
void	FNAM_simplify_path (String &path);



/*\\\ VARIABLES EXTERNES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ FIN DU FICHIER \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#endif

#undef FNAM_CURRENT_HEADER
