/*****************************************************************************

        GRAOUMF TRACKER 2
        Author: Laurent de Soras, 1996-2016

--- Legal stuff ---

This program is free software. It comes without any warranty, to
the extent permitted by applicable law. You can redistribute it
and/or modify it under the terms of the Do What The Fuck You Want
To Public License, Version 2, as published by Sam Hocevar. See
http://sam.zoy.org/wtfpl/COPYING for more details.

*****************************************************************************/



/*\\\ FICHIERS INCLUDE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	<stdio.h>
#include	<string.h>

#include	"archi.h"
#include	"base_ct.h"
#include	"Container.h"
#include	"log.h"
#include	"patt.h"
#include	"Pattern.h"
#include	"UndoCell.h"
#include	"UndoCellPatMove.h"



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ CONSTANTES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ TYPES & STRUCTURES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ DEFINITION DES VARIABLES DE CLASSE PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ DEFINITION DES VARIABLES DE CLASSE PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ METHODES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*==========================================================================*/
/*      Nom: (constructeur)                                                 */
/*      Description: Initialise                                             */
/*      Parametres en entree:                                               */
/*      Parametres en sortie:                                               */
/*      Parametres en entree/sortie:                                        */
/*==========================================================================*/

UndoCellPatMove::UndoCellPatMove (int track_type, int pattern, int line, int track, int nbr_lines, int nbr_tracks, int dest_line, int dest_track)
{
	_track_type = track_type;
	_pattern = pattern;
	_line = line;
	_track = track;
	_nbr_lines = nbr_lines;
	_nbr_tracks = nbr_tracks;
	_dest_line = dest_line;
	_dest_track = dest_track;
}



/* Ne devrait pas etre utilise tel quel */
UndoCellPatMove::UndoCellPatMove (void)
{
	_track_type = 0;
	_pattern = 0;
	_line = 0;
	_track = 0;
	_nbr_lines = 0;
	_nbr_tracks = 0;
	_dest_line = 0;
	_dest_track = 0;
}



UndoCellPatMove::UndoCellPatMove (const UndoCellPatMove &other)
{
	_track_type = other._track_type;
	_pattern = other._pattern;
	_line = other._line;
	_track = other._track;
	_nbr_lines = other._nbr_lines;
	_nbr_tracks = other._nbr_tracks;
	_dest_line = other._dest_line;
	_dest_track = other._dest_track;
}



/*==========================================================================*/
/*      Nom: (destructeur)                                                  */
/*      Description: Detruit                                                */
/*==========================================================================*/

UndoCellPatMove::~UndoCellPatMove (void)
{

	/*** A faire ***/

}



/*==========================================================================*/
/*      Nom: check_ok                                                       */
/*      Description: Verifie l'intergrite de l'objet.                       */
/*      Retour: 0 si l'objet parait correct.                                */
/*==========================================================================*/

signed int	UndoCellPatMove::check_ok (void) const
{
	if (this == NULL)
	{
		LOG_printf ("UndoCellPatMove::check_ok: Error: \"this\" pointer is NULL.\n");
		return (-1);
	}

	/*** A faire ***/

	return (0);
}



/*==========================================================================*/
/*      Nom: self_display                                                   */
/*      Description: Affiche "textuellement" le contenu courant de l'objet. */
/*==========================================================================*/

void	UndoCellPatMove::self_display (void) const
{

	/*** A faire ***/

}



Container	*UndoCellPatMove::create (void) const
{
	return (new UndoCellPatMove ());
}



Container	*UndoCellPatMove::clone (void) const
{
	return (new UndoCellPatMove (*this));
}



void	UndoCellPatMove::apply_undo (void)
{
	int		temp;
	int		line_cnt;
	long		block_line_size;

	block_line_size = (long)Pattern::NOTE_SIZE [_track_type] * _nbr_tracks;
	
	/* Comme on deplace ligne par ligne avec memmove, on ne teste pas si on
	   deplace vers la gauche ou la droite pour le sens de la copie. */

	/* On deplace vers l'avant: copie a reculons */
	if (_dest_line < _line)
	{
		for (line_cnt = _nbr_lines - 1; line_cnt >= 0; line_cnt --)
		{
			memmove (PAT_get_note_adr_pat (_track_type, _pattern,
			                               _line + line_cnt, _track),
			         PAT_get_note_adr_pat (_track_type, _pattern,
			                               _dest_line + line_cnt, _dest_track),
			         block_line_size);
		}
	}

	/* On deplace vers l'arriere: copie en avancant */
	else
	{
		for (line_cnt = 0; line_cnt < _nbr_lines; line_cnt ++)
		{
			memmove (PAT_get_note_adr_pat (_track_type, _pattern,
			                               _line + line_cnt, _track),
			         PAT_get_note_adr_pat (_track_type, _pattern,
			                               _dest_line + line_cnt, _dest_track),
			         block_line_size);
		}
	}
	
	temp = _dest_line;
	_dest_line = _line;
	_line = temp;

	temp = _dest_track;
	_dest_track = _track;
	_track = temp;
}



void	UndoCellPatMove::apply_redo (void)
{
	apply_undo ();
}



/*\\\ METHODES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/****************************************************************************/
/*                                                                          */
/*                                                                          */
/*                                                                          */
/****************************************************************************/



/*==========================================================================*/
/*      Nom:                                                                */
/*      Description:                                                        */
/*      Parametres en entree:                                               */
/*      Parametres en sortie:                                               */
/*      Parametres en entree/sortie:                                        */
/*      Retour:                                                             */
/*==========================================================================*/
