/*****************************************************************************

        GRAOUMF TRACKER 2
        Author: Laurent de Soras, 1996-2016

--- Legal stuff ---

This program is free software. It comes without any warranty, to
the extent permitted by applicable law. You can redistribute it
and/or modify it under the terms of the Do What The Fuck You Want
To Public License, Version 2, as published by Sam Hocevar. See
http://sam.zoy.org/wtfpl/COPYING for more details.

*****************************************************************************/



/*\\\ FICHIERS INCLUDE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>

#include	"archi.h"
#include	"base_ct.h"
#include	"log.h"
#include	"memory.h"
#include	"patt.h"
#include	"Pattern.h"
#include	"UndoCellPatClear.h"



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ CONSTANTES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ TYPES & STRUCTURES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ DEFINITION DES VARIABLES DE CLASSE PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ DEFINITION DES VARIABLES DE CLASSE PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ METHODES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*==========================================================================*/
/*      Nom: (constructeur)                                                 */
/*      Description: Initialise                                             */
/*      Parametres en entree:                                               */
/*      Parametres en sortie:                                               */
/*      Parametres en entree/sortie:                                        */
/*==========================================================================*/

UndoCellPatClear::UndoCellPatClear (int track_type, int pattern, int line, int track, int height)
{
	long		note_size;
	int		note_cnt;

	_track_type = track_type;
	_pattern = pattern;
	_line = line;
	_track = track;
	_height = height;
	_undo_flag = true;

	note_size = Pattern::NOTE_SIZE [_track_type];
	_data_ptr = MALLOC (_height * note_size);
	if (_data_ptr != NULL)
	{
		for (note_cnt = 0; note_cnt < _height; note_cnt ++)
		{
			memcpy ((UBYTE *)_data_ptr + note_cnt * note_size,
			        PAT_get_note_adr_pat (_track_type, _pattern,
			                              _line + note_cnt, _track),
					  note_size);
		}
	}
}



UndoCellPatClear::UndoCellPatClear (void)
{
	_track_type = 0;
	_pattern = 0;
	_line = 0;
	_track = 0;
	_height = 0;
	_undo_flag = true;
	_data_ptr = NULL;
}



UndoCellPatClear::UndoCellPatClear (const UndoCellPatClear &other)
{
	long		note_size;

	_track_type = other._track_type;
	_pattern = other._pattern;
	_line = other._line;
	_track = other._track;
	_height = other._height;
	_undo_flag = other._undo_flag;

	if (_height > 0 && _undo_flag)
	{
		note_size = Pattern::NOTE_SIZE [_track_type];
		_data_ptr = MALLOC (_height * note_size);
		memcpy (_data_ptr, other._data_ptr, _height * note_size);
	}
	else
	{
		_data_ptr = NULL;
	}
}



/*==========================================================================*/
/*      Nom: (destructeur)                                                  */
/*      Description: Detruit                                                */
/*==========================================================================*/

UndoCellPatClear::~UndoCellPatClear (void)
{
	if (_data_ptr != NULL)
	{
		FREE (_data_ptr);
		_data_ptr = NULL;
	}
}



/*==========================================================================*/
/*      Nom: check_ok                                                       */
/*      Description: Verifie l'intergrite de l'objet.                       */
/*      Retour: 0 si l'objet parait correct.                                */
/*==========================================================================*/

signed int	UndoCellPatClear::check_ok (void) const
{
	if (this == NULL)
	{
		LOG_printf ("UndoCellPatClear::check_ok: Error: \"this\" pointer is NULL.\n");
		return (-1);
	}

	if (_undo_flag)
	{
		if (_data_ptr == NULL)
		{
			LOG_printf ("UndoCellPatClear::check_ok: Error: _data_ptr pointer is NULL.\n");
			return (-1);
		}

		MCHECK (_data_ptr);
	}

	else if (_data_ptr != NULL)
	{
		LOG_printf ("UndoCellPatClear::check_ok: Error: _data_ptr should be NULL when it isn't.\n");
		return (-1);
	}

	return (0);
}



/*==========================================================================*/
/*      Nom: self_display                                                   */
/*      Description: Affiche "textuellement" le contenu courant de l'objet. */
/*==========================================================================*/

void	UndoCellPatClear::self_display (void) const
{

	/*** A faire ***/

}



Container	*UndoCellPatClear::create (void) const
{
	return (new UndoCellPatClear ());
}



Container	*UndoCellPatClear::clone (void) const
{
	return (new UndoCellPatClear (*this));
}



void	UndoCellPatClear::apply_undo (void)
{
	int		note_cnt;
	long		note_size;
	void		*note_ptr;

	if (! _undo_flag)
	{
		LOG_printf ("UndoCellPatClear::apply_undo: Error: 'Undo' method called when the object is in the 'Redo' state.\n");
		return;
	}

	note_size = Pattern::NOTE_SIZE [_track_type];

	for (note_cnt = 0; note_cnt < _height; note_cnt ++)
	{
		note_ptr = PAT_get_note_adr_pat (_track_type, _pattern, _line + note_cnt, _track),
		memcpy (note_ptr, (UBYTE *)_data_ptr + note_cnt * note_size, note_size);
	}

	FREE (_data_ptr);
	_data_ptr = NULL;
	_undo_flag = false;
}



void	UndoCellPatClear::apply_redo (void)
{
	int		note_cnt;
	long		note_size;
	void		*note_ptr;

	if (_undo_flag)
	{
		LOG_printf ("UndoCellPatClear::apply_redo: Error: 'Redo' method called when the object is in the 'Undo' state.\n");
		return;
	}

	note_size = Pattern::NOTE_SIZE [_track_type];

	_data_ptr = MALLOC (_height * note_size);
	if (_data_ptr == NULL)
	{
		LOG_printf ("UndoCellPatClear::apply_redo: Error: couldn't reserve memory for Undo data.\n");
		return;
	}

	for (note_cnt = 0; note_cnt < _height; note_cnt ++)
	{
		note_ptr = PAT_get_note_adr_pat (_track_type, _pattern, _line + note_cnt, _track),
		memcpy ((UBYTE *)_data_ptr + note_cnt * note_size, note_ptr, note_size);
		memset (note_ptr, 0, note_size);
	}

	_undo_flag = true;
}



/*\\\ METHODES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/****************************************************************************/
/*                                                                          */
/*                                                                          */
/*                                                                          */
/****************************************************************************/



/*==========================================================================*/
/*      Nom:                                                                */
/*      Description:                                                        */
/*      Parametres en entree:                                               */
/*      Parametres en sortie:                                               */
/*      Parametres en entree/sortie:                                        */
/*      Retour:                                                             */
/*==========================================================================*/
