/*****************************************************************************

        GRAOUMF TRACKER 2
        Author: Laurent de Soras, 1996-2016

--- Legal stuff ---

This program is free software. It comes without any warranty, to
the extent permitted by applicable law. You can redistribute it
and/or modify it under the terms of the Do What The Fuck You Want
To Public License, Version 2, as published by Sam Hocevar. See
http://sam.zoy.org/wtfpl/COPYING for more details.

*****************************************************************************/



/*\\\ FICHIERS INCLUDE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	<stdio.h>

#include	"base_ct.h"
#include	"intrface.h"
#include	"gtracker.h"
#include	"resource.h"
#include	"rsc01.h"
#include	"samp.h"
#include	"Sample.h"
#include	"SplEdNumericDisplay.h"




/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ CONSTANTES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ TYPES & STRUCTURES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ DEFINITION DES VARIABLES DE CLASSE PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ DEFINITION DES VARIABLES DE CLASSE PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ METHODES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*==========================================================================*/
/*      Nom: redraw                                                         */
/*      Description: Affiche la composante d'interface.                     */
/*==========================================================================*/

void	SplEdNumericDisplay::redraw (void)
{
	RSC_display_object (RSC_OBJ_SE_NUMDISP);

	refresh ();
}



/*==========================================================================*/
/*      Nom: refresh                                                        */
/*      Description: Rafraichit l'affichage des donnees.                    */
/*==========================================================================*/

void	SplEdNumericDisplay::refresh (void)
{
	char		text_0 [8+1];
	Sample_VIEW view;
	Sample_SELECTION selection;
	long		window_spl_length;
	long		freq;
	int		nbr_tracks;
	int		nbr_bytes;

	freq = SAMP_get_sample_freq (GTK_sample_nbr);
	nbr_tracks = SAMP_get_sample_stereo (GTK_sample_nbr);
	nbr_bytes = SAMP_get_sample_resolution (GTK_sample_nbr) >> 3;

	SAMP_get_sample_view (GTK_sample_nbr, view);
	SAMP_get_sample_selection (GTK_sample_nbr, selection);
	window_spl_length = SplEdWindow::get_real_nbr_disp_spl ();
	
	/* Longueur de la selection */
	INTR_splpos_2_string (text_0, selection.length,
								 freq, nbr_tracks, nbr_bytes);
	RSC_set_string (RSC_OBJ_SE_NUMDISP_SEL_LEN_VAL, text_0);
	RSC_display_object (RSC_OBJ_SE_NUMDISP_SEL_LEN_VAL);

	/* Debut de la selection */
	INTR_splpos_2_string (text_0, selection.start,
								 freq, nbr_tracks, nbr_bytes);
	RSC_set_string (RSC_OBJ_SE_NUMDISP_SEL_START_VAL, text_0);
	RSC_display_object (RSC_OBJ_SE_NUMDISP_SEL_START_VAL);

	/* Fin de la selection */
	INTR_splpos_2_string (text_0, selection.start + selection.length,
								 freq, nbr_tracks, nbr_bytes);
	RSC_set_string (RSC_OBJ_SE_NUMDISP_SEL_END_VAL, text_0);
	RSC_display_object (RSC_OBJ_SE_NUMDISP_SEL_END_VAL);

	/* Longueur de la fenetre */
	INTR_splpos_2_string (text_0, window_spl_length,
								 freq, nbr_tracks, nbr_bytes);
	RSC_set_string (RSC_OBJ_SE_NUMDISP_WIN_LEN_VAL, text_0);
	RSC_display_object (RSC_OBJ_SE_NUMDISP_WIN_LEN_VAL);

	/* Debut de la fenetre */
	INTR_splpos_2_string (text_0, view.h_pos,
								 freq, nbr_tracks, nbr_bytes);
	RSC_set_string (RSC_OBJ_SE_NUMDISP_WIN_START_VAL, text_0);
	RSC_display_object (RSC_OBJ_SE_NUMDISP_WIN_START_VAL);

	/* Fin de la fenetre */
	INTR_splpos_2_string (text_0, view.h_pos + window_spl_length,
								 freq, nbr_tracks, nbr_bytes);
	RSC_set_string (RSC_OBJ_SE_NUMDISP_WIN_END_VAL, text_0);
	RSC_display_object (RSC_OBJ_SE_NUMDISP_WIN_END_VAL);

	/* Longueur de la boucle */
	INTR_splpos_2_string (text_0, SAMP_get_sample_replen (GTK_sample_nbr),
								 freq, nbr_tracks, nbr_bytes);
	RSC_set_string (RSC_OBJ_SE_NUMDISP_LOOP_LEN_VAL, text_0);
	RSC_display_object (RSC_OBJ_SE_NUMDISP_LOOP_LEN_VAL);

	/* Debut de la boucle */
	INTR_splpos_2_string (text_0, SAMP_get_sample_repeat (GTK_sample_nbr),
								 freq, nbr_tracks, nbr_bytes);
	RSC_set_string (RSC_OBJ_SE_NUMDISP_LOOP_START_VAL, text_0);
	RSC_display_object (RSC_OBJ_SE_NUMDISP_LOOP_START_VAL);

	/* Fin de la boucle */
	INTR_splpos_2_string (text_0, SAMP_get_sample_repeat (GTK_sample_nbr) + SAMP_get_sample_replen (GTK_sample_nbr),
								 freq, nbr_tracks, nbr_bytes);
	RSC_set_string (RSC_OBJ_SE_NUMDISP_LOOP_END_VAL, text_0);
	RSC_display_object (RSC_OBJ_SE_NUMDISP_LOOP_END_VAL);

	refresh_dynamic (true);
}



/*==========================================================================*/
/*      Nom: manage                                                         */
/*      Description: Gere la composante d'interface                         */
/*      Parametres en entree:                                               */
/*        - sel_object: objet detecte par le gestionnaire d'interface       */
/*        - sel_elder: aine de sel_object                                   */
/*==========================================================================*/

void	SplEdNumericDisplay::manage (int sel_object, int /*sel_elder*/)
{
	switch (sel_object)
	{

	/* Longueur de la selection */
	case	RSC_OBJ_SE_NUMDISP_SEL_LEN_VAL:
		INTR_dialog_box ("", "Not implemented", "Cancel", 0, 0);
		/*** A faire ***/
		break;

	/* Debut de la selection */
	case	RSC_OBJ_SE_NUMDISP_SEL_START_VAL:
		INTR_dialog_box ("", "Not implemented", "Cancel", 0, 0);
		/*** A faire ***/
		break;

	/* Fin de la selection */
	case	RSC_OBJ_SE_NUMDISP_SEL_END_VAL:
		INTR_dialog_box ("", "Not implemented", "Cancel", 0, 0);
		/*** A faire ***/
		break;

	/* Longueur de la fenetre */
	case	RSC_OBJ_SE_NUMDISP_WIN_LEN_VAL:
		INTR_dialog_box ("", "Not implemented", "Cancel", 0, 0);
		/*** A faire ***/
		break;

	/* Debut de la fenetre */
	case	RSC_OBJ_SE_NUMDISP_WIN_START_VAL:
		INTR_dialog_box ("", "Not implemented", "Cancel", 0, 0);
		/*** A faire ***/
		break;

	/* Fin de la fenetre */
	case	RSC_OBJ_SE_NUMDISP_WIN_END_VAL:
		INTR_dialog_box ("", "Not implemented", "Cancel", 0, 0);
		/*** A faire ***/
		break;

	/* Longueur de la boucle */
	case	RSC_OBJ_SE_NUMDISP_LOOP_LEN_VAL:
		INTR_dialog_box ("", "Not implemented", "Cancel", 0, 0);
		/*** A faire ***/
		break;

	/* Debut de la boucle */
	case	RSC_OBJ_SE_NUMDISP_LOOP_START_VAL:
		INTR_dialog_box ("", "Not implemented", "Cancel", 0, 0);
		/*** A faire ***/
		break;

	/* Fin de la boucle */
	case	RSC_OBJ_SE_NUMDISP_LOOP_END_VAL:
		INTR_dialog_box ("", "Not implemented", "Cancel", 0, 0);
		/*** A faire ***/
		break;

	}
}



int	SplEdNumericDisplay::get_width (void)
{
	return (RSC_get_width (RSC_OBJ_SE_NUMDISP));
}



int	SplEdNumericDisplay::get_height (void)
{
	return (RSC_get_height (RSC_OBJ_SE_NUMDISP));
}



void	SplEdNumericDisplay::get_coordinates (int &pix_x, int &pix_y)
{
	pix_x = RSC_absolute_object_pixxpos [RSC_OBJ_SE_NUMDISP];
	pix_y = RSC_absolute_object_pixypos [RSC_OBJ_SE_NUMDISP];
}



void	SplEdNumericDisplay::move_to (int pix_x, int pix_y)
{
	RSC_set_absolute_object_position (RSC_OBJ_SE_NUMDISP, pix_x, pix_y);
}



/*\\\ METHODES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/****************************************************************************/
/*                                                                          */
/*                                                                          */
/*                                                                          */
/****************************************************************************/



/*==========================================================================*/
/*      Nom:                                                                */
/*      Description:                                                        */
/*      Parametres en entree:                                               */
/*      Parametres en sortie:                                               */
/*      Parametres en entree/sortie:                                        */
/*      Retour:                                                             */
/*==========================================================================*/
