/*****************************************************************************

        GRAOUMF TRACKER 2
        Author: Laurent de Soras, 1996-2016

--- Legal stuff ---

This program is free software. It comes without any warranty, to
the extent permitted by applicable law. You can redistribute it
and/or modify it under the terms of the Do What The Fuck You Want
To Public License, Version 2, as published by Sam Hocevar. See
http://sam.zoy.org/wtfpl/COPYING for more details.

*****************************************************************************/



/*\\\ FICHIERS INCLUDE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	<stdio.h>

#include	"base_ct.h"
#include	"gtracker.h"
#include	"intrface.h"
#include	"resource.h"
#include	"rsc01.h"
#include	"samp.h"
#include	"SplEdIcons.h"



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ CONSTANTES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ TYPES & STRUCTURES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ DEFINITION DES VARIABLES DE CLASSE PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ DEFINITION DES VARIABLES DE CLASSE PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ METHODES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*==========================================================================*/
/*      Nom: redraw                                                         */
/*      Description: Affiche la composante d'interface.                     */
/*==========================================================================*/

void	SplEdIcons::redraw (void)
{
	RSC_display_object (RSC_OBJ_SE_ICN);

	refresh ();
}



/*==========================================================================*/
/*      Nom: refresh                                                        */
/*      Description: Rafraichit l'affichage des donnees.                    */
/*==========================================================================*/

void	SplEdIcons::refresh (void)
{

	/*** A faire ***/

	refresh_dynamic (true);
}



/*==========================================================================*/
/*      Nom: manage                                                         */
/*      Description: Gere la composante d'interface                         */
/*      Parametres en entree:                                               */
/*        - sel_object: objet detecte par le gestionnaire d'interface       */
/*        - sel_elder: aine de sel_object                                   */
/*==========================================================================*/

void	SplEdIcons::manage (int sel_object, int /*sel_elder*/)
{
	Sample_VIEW	view;

	switch (sel_object)
	{

	/* Loop Mode */
	case	RSC_OBJ_SE_ICN_LOOP:
		SAMP_get_sample_view (GTK_sample_nbr, view);
		if (SplEdMainLoop::edit_mode != SplEdMainLoop_MODE_NORMAL)
		{
			SplEdMainLoop::edit_mode = SplEdMainLoop_MODE_NORMAL;
		}
		else
		{
			SplEdMainLoop::edit_mode = SplEdMainLoop_MODE_LOOP;
		}
		SAMP_set_sample_view (GTK_sample_nbr, view);
		INTR_sample_editor_interface_ptr->refresh ();
		break;

	/* Play all */
	case	RSC_OBJ_SE_ICN_PLAYALL:
		INTR_dialog_box ("", "Not implemented", "Cancel", 0, 0);
		/*** A faire ***/
		break;

	/* Play selection */
	case	RSC_OBJ_SE_ICN_PLAYSEL:
		INTR_dialog_box ("", "Not implemented", "Cancel", 0, 0);
		/*** A faire ***/
		break;

	/* Pause */
	case	RSC_OBJ_SE_ICN_PAUSE:
		INTR_dialog_box ("", "Not implemented", "Cancel", 0, 0);
		/*** A faire ***/
		break;

	/* Stop */
	case	RSC_OBJ_SE_ICN_STOP:
		INTR_dialog_box ("", "Not implemented", "Cancel", 0, 0);
		/*** A faire ***/
		break;

	/* Rewind */
	case	RSC_OBJ_SE_ICN_START:
		INTR_dialog_box ("", "Not implemented", "Cancel", 0, 0);
		/*** A faire ***/
		break;

	/* Fast backward */
	case	RSC_OBJ_SE_ICN_REW:
		INTR_dialog_box ("", "Not implemented", "Cancel", 0, 0);
		/*** A faire ***/
		break;

	/* Fast forward */
	case	RSC_OBJ_SE_ICN_FF:
		INTR_dialog_box ("", "Not implemented", "Cancel", 0, 0);
		/*** A faire ***/
		break;

	/* Wind */
	case	RSC_OBJ_SE_ICN_END:
		INTR_dialog_box ("", "Not implemented", "Cancel", 0, 0);
		/*** A faire ***/
		break;

	/* Record */
	case	RSC_OBJ_SE_ICN_REC:
		INTR_dialog_box ("", "Not implemented", "Cancel", 0, 0);
		/*** A faire ***/
		break;

	}
}



int	SplEdIcons::get_width (void)
{
	return (RSC_get_width (RSC_OBJ_SE_ICN));
}



int	SplEdIcons::get_height (void)
{
	return (RSC_get_height (RSC_OBJ_SE_ICN));
}



void	SplEdIcons::get_coordinates (int &pix_x, int &pix_y)
{
	pix_x = RSC_absolute_object_pixxpos [RSC_OBJ_SE_ICN];
	pix_y = RSC_absolute_object_pixypos [RSC_OBJ_SE_ICN];
}



void	SplEdIcons::move_to (int pix_x, int pix_y)
{
	RSC_set_absolute_object_position (RSC_OBJ_SE_ICN, pix_x, pix_y);
}



/*\\\ METHODES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/****************************************************************************/
/*                                                                          */
/*                                                                          */
/*                                                                          */
/****************************************************************************/



/*==========================================================================*/
/*      Nom:                                                                */
/*      Description:                                                        */
/*      Parametres en entree:                                               */
/*      Parametres en sortie:                                               */
/*      Parametres en entree/sortie:                                        */
/*      Retour:                                                             */
/*==========================================================================*/
