/*****************************************************************************

        GRAOUMF TRACKER 2
        Author: Laurent de Soras, 1996-2016

--- Legal stuff ---

This program is free software. It comes without any warranty, to
the extent permitted by applicable law. You can redistribute it
and/or modify it under the terms of the Do What The Fuck You Want
To Public License, Version 2, as published by Sam Hocevar. See
http://sam.zoy.org/wtfpl/COPYING for more details.

*****************************************************************************/



/*\\\ FICHIERS INCLUDE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	<stdio.h>
#include	<math.h>

#include	"base.h"
#include	"base_ct.h"
#include	"fx_p.h"
#include	"EditString.h"
#include	"edstring.h"
#include	"FxPreset.h"
#include	"gtracker.h"
#include	"intrface.h"
#include	"log.h"
#include	"PatEdMenuFxDelay.h"
#include	"player.h"
#include	"resource.h"
#include	"rsc01.h"



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ CONSTANTES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ TYPES & STRUCTURES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ DEFINITION DES VARIABLES DE CLASSE PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ DEFINITION DES VARIABLES DE CLASSE PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ METHODES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*==========================================================================*/
/*      Nom: check_ok                                                       */
/*      Description: Verifie l'intergrite de l'objet.                       */
/*      Retour: 0 si l'objet parait correct.                                */
/*==========================================================================*/

signed int	PatEdMenuFxDelay::check_ok (void) const
{
	if (this == NULL)
	{
		LOG_printf ("PatEdMenuFxDelay::check_ok: Error: \"this\" pointer is NULL.\n");
		return (-1);
	}

	return (0);
}



/*==========================================================================*/
/*      Nom: self_display                                                   */
/*      Description: Affiche "textuellement" le contenu courant de l'objet. */
/*==========================================================================*/

void	PatEdMenuFxDelay::self_display (void) const
{

	/*** A faire ***/

}



/*==========================================================================*/
/*      Nom: redraw                                                         */
/*      Description: Affiche la composante d'interface.                     */
/*==========================================================================*/

void	PatEdMenuFxDelay::redraw (void)
{
	RSC_display_object (RSC_OBJ_MP_SUBM_FX_FXPAN);

	refresh ();
}



/*==========================================================================*/
/*      Nom: refresh                                                        */
/*      Description: Rafraichit l'affichage des donnees.                    */
/*==========================================================================*/

void	PatEdMenuFxDelay::refresh (void)
{
	/* Unite du delay time */
	RSC_set_string (RSC_OBJ_MP_SUBM_FX_FXPAN_DELAY_TIME_DLY_UNIT,
	                INTR_time_unit_name_0_ptr [INTR_time_unit]);
	RSC_display_object (RSC_OBJ_MP_SUBM_FX_FXPAN_DELAY_TIME_DLY_UNIT);

	/* Teste si la piste sur laquelle on est est valide */
	if (   GTK_fx_real_time_mode_flag
	    && _pannel_ptr->get_track_nbr () >= GTK_nbr_tracks [Pattern_TYPE_FX])
	{
		RSC_set_string (RSC_OBJ_MP_SUBM_FX_FXPAN_DELAY_TIME_DLY_VAL, "");
		RSC_display_object (RSC_OBJ_MP_SUBM_FX_FXPAN_DELAY_TIME_DLY_VAL);
		RSC_set_string (RSC_OBJ_MP_SUBM_FX_FXPAN_DELAY_FDBK_VAL, "");
		RSC_display_object (RSC_OBJ_MP_SUBM_FX_FXPAN_DELAY_FDBK_VAL);
		RSC_display_object (RSC_OBJ_MP_SUBM_FX_FXPAN_DELAY_FDBK_FADER);
	}

	refresh_dynamic (true);
}



/*==========================================================================*/
/*      Nom: refresh_dynamic                                                */
/*      Description: Rafraichit l'affichage des donnees dynamiques.         */
/*        - force_flag: true indique qu'on doit forcer le rafraichissement. */
/*==========================================================================*/

void	PatEdMenuFxDelay::refresh_dynamic (bool force_flag)
{
	char		nbr6_0 [6+1];
	int		position;
	double	delay_time;
	double	feedback;
	const FxPreset_DELAY	*param_ptr;

	static double	old_delay_time = -1.0;
	static double	old_feedback = -1.0;

	if (GTK_fx_real_time_mode_flag)
	{
		const Player &	player = Player::use_instance ();
		if (player.get_fx_preset (_pannel_ptr->get_track_nbr (), 0))
		{
			/* On s'en va si l'effet est indisponible */
			return;
		}
	}

	param_ptr = &FXP_get_parameters (0).delay;

	/* Delay time */
	delay_time = param_ptr->delay;
	if (   force_flag
	    || delay_time != old_delay_time)
	{
		old_delay_time = delay_time;
		INTR_time_2_string (nbr6_0, INTR_time_unit, delay_time, 6);
		RSC_set_string (RSC_OBJ_MP_SUBM_FX_FXPAN_DELAY_TIME_DLY_VAL, nbr6_0);
		RSC_display_object (RSC_OBJ_MP_SUBM_FX_FXPAN_DELAY_TIME_DLY_VAL);
	}

	/* Feedback */
	feedback = param_ptr->feedback;
	if (   force_flag
	    || feedback != old_feedback)
	{
		old_feedback = feedback;

		/* Valeur */
		BASE_double_to_fix (nbr6_0, feedback * 100.0, 3, 2);
		RSC_set_string (RSC_OBJ_MP_SUBM_FX_FXPAN_DELAY_FDBK_VAL, nbr6_0);
		RSC_display_object (RSC_OBJ_MP_SUBM_FX_FXPAN_DELAY_FDBK_VAL);

		/* Fader */
		position = 100 - (int) floor (feedback * 100.0 + 0.5);
		RSC_display_object (RSC_OBJ_MP_SUBM_FX_FXPAN_DELAY_FDBK_FADER);
		RSC_display_image (RSC_get_gfx_ptr (RSC_GFX_KNOB_2_V_B), 0, 0,
		                   -1, -1,
		                   RSC_OBJ_MP_SUBM_FX_FXPAN_DELAY_FDBK_FADER, 0, position,
		                   255);
	}
}



/*==========================================================================*/
/*      Nom: manage                                                         */
/*      Description: Gere la composante d'interface                         */
/*      Parametres en entree:                                               */
/*        - sel_object: objet detecte par le gestionnaire d'interface       */
/*        - sel_elder: aine de sel_object                                   */
/*==========================================================================*/

void	PatEdMenuFxDelay::manage (int sel_object, int /*sel_elder*/)
{
	double	delay_time;
	int		position;
	FxPreset_EFFECT_CONF	conf;
	char		nbr15_0 [15+1];
	double	feedback;
	/* Mis a 1 pour indiquer que le preset doit etre change,
	   2 pour forcer egalement le redraw dynamique. */
	int		changed_state;
	
	conf = FXP_get_parameters (0);
	changed_state = 0;

	switch (sel_object)
	{

	/* Delay time, unite */
	case	RSC_OBJ_MP_SUBM_FX_FXPAN_DELAY_TIME_DLY_UNIT:
		INTR_select_time_unit (INTR_time_unit);
		refresh ();
		break;

	/* Delay time, valeur */
	case	RSC_OBJ_MP_SUBM_FX_FXPAN_DELAY_TIME_DLY:
		delay_time = conf.delay.delay;
		INTR_set_time_intr (INTR_CHGTYPE_KBD, 0,
		                    RSC_OBJ_MP_SUBM_FX_FXPAN_DELAY_TIME_DLY_VAL,
		                    INTR_time_unit, delay_time);
		conf.delay.delay = delay_time;
		changed_state = 2;
		break;

	/* Delay Time + */
	case	RSC_OBJ_MP_SUBM_FX_FXPAN_DELAY_TIME_U:
		delay_time = conf.delay.delay;
		INTR_set_time_intr (INTR_CHGTYPE_REL, INTR_inc_speed [0] [RSC_mouse_key],
		                    RSC_OBJ_MP_SUBM_FX_FXPAN_DELAY_TIME_DLY_VAL,
		                    INTR_time_unit, delay_time);
		conf.delay.delay = delay_time;
		changed_state = 1;
		break;

	/* Delay Time - */
	case	RSC_OBJ_MP_SUBM_FX_FXPAN_DELAY_TIME_D:
		delay_time = conf.delay.delay;
		INTR_set_time_intr (INTR_CHGTYPE_REL, -INTR_inc_speed [0] [RSC_mouse_key],
		                    RSC_OBJ_MP_SUBM_FX_FXPAN_DELAY_TIME_DLY_VAL,
		                    INTR_time_unit, delay_time);
		conf.delay.delay = delay_time;
		changed_state = 1;
		break;

	/* Fader feedback */
	case	RSC_OBJ_MP_SUBM_FX_FXPAN_DELAY_FDBK_FADER:
		position = INTR_mouse.y - RSC_absolute_object_pixypos [RSC_OBJ_MP_SUBM_FX_FXPAN_DELAY_FDBK_FADER];
		position -= RSC_get_gfx_ptr (RSC_GFX_KNOB_2_V_B)->get_height () / 2;
		position = 100 - position;
		conf.delay.feedback = ((double)position / 100.0);
		changed_state = 1;
		break;

	/* Valeur feedback */
	case	RSC_OBJ_MP_SUBM_FX_FXPAN_DELAY_FDBK_VAL:
		BASE_double_to_float (nbr15_0, conf.delay.feedback * 100.0, 15);
		BASE_trim_string (nbr15_0);
		EDIT_edit_string (nbr15_0, RSC_OBJ_MP_SUBM_FX_FXPAN_DELAY_FDBK_VAL,
		                  15, EditString_TYPE_FLO);
		if (sscanf (nbr15_0, "%lf", &feedback) == 1)
		{
			conf.delay.feedback = feedback / 100.0;
			changed_state = 1;
		}
		break;

	}

	/* Met a jour l'effet */
	if (changed_state != 0)
	{
		FXP_set_parameters (0, conf);
		if (GTK_fx_real_time_mode_flag)
		{
			Player &			player = Player::use_instance ();
			player.set_fx_preset (_pannel_ptr->get_track_nbr (), 0);
			GTK_modified_flag = true;
		}
		refresh_dynamic (changed_state == 2);
	}
}



/*==========================================================================*/
/*      Nom: activate                                                       */
/*      Description: Active ou desactive le menu. Celui-ci n'est pas        */
/*                   reaffiche.                                             */
/*      Parametres en entree:                                               */
/*        - activated_flag: indique si le menu doit etre active ou          */
/*                          desactive.                                      */
/*==========================================================================*/

void	PatEdMenuFxDelay::activate (bool activated_flag)
{
	RSC_pos_flag (RSC_OBJ_MP_SUBM_FX_FXPAN_DELAY, RSC_ATTR_NOTDISP, ! activated_flag);
}



/*==========================================================================*/
/*      Nom: set_owner                                                      */
/*      Description: Associe l'objet courant a un objet PatEdMenuFx.        */
/*      Parametres en entree:                                               */
/*        - pannel_ptr: pointeur sur l'objet PatEdMenuFx qui possede cet    */
/*                      objet.                                              */
/*==========================================================================*/

void	PatEdMenuFxDelay::set_owner (PatEdMenuFx *pannel_ptr)
{
	_pannel_ptr = pannel_ptr;
}



/*\\\ METHODES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/****************************************************************************/
/*                                                                          */
/*                                                                          */
/*                                                                          */
/****************************************************************************/



/*==========================================================================*/
/*      Nom:                                                                */
/*      Description:                                                        */
/*      Parametres en entree:                                               */
/*      Parametres en sortie:                                               */
/*      Parametres en entree/sortie:                                        */
/*      Retour:                                                             */
/*==========================================================================*/
