/*****************************************************************************

        GRAOUMF TRACKER 2
        Author: Laurent de Soras, 1996-2016

--- Legal stuff ---

This program is free software. It comes without any warranty, to
the extent permitted by applicable law. You can redistribute it
and/or modify it under the terms of the Do What The Fuck You Want
To Public License, Version 2, as published by Sam Hocevar. See
http://sam.zoy.org/wtfpl/COPYING for more details.

*****************************************************************************/




/*\\\ FICHIERS INCLUDE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	<stdio.h>

#include	"base_ct.h"
#include	"log.h"
#include	"PatEdMenuEnvelopes.h"
#include	"PatEdMenuEnvWin.h"
#include	"resource.h"
#include	"rsc01.h"



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ CONSTANTES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

const int	PatEdMenuEnvelopes::ENV_BUTTONS [Envelope_NBR_TYPES] =
{
	RSC_OBJ_MP_SUBM_ENV_ET_VOL,
	RSC_OBJ_MP_SUBM_ENV_ET_TONE,
	RSC_OBJ_MP_SUBM_ENV_ET_PAN,
	RSC_OBJ_MP_SUBM_ENV_ET_CUTOFF,
	RSC_OBJ_MP_SUBM_ENV_ET_RESO
};

enum
{
	PatEdMenuEnvelopes_SUBMENU_LOOPS = 0,
	PatEdMenuEnvelopes_SUBMENU_MISC,

	PatEdMenuEnvelopes_NBR_SUBMENUS
};



/*\\\ TYPES & STRUCTURES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ DEFINITION DES VARIABLES DE CLASSE PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\*/

int	PatEdMenuEnvelopes::cur_env_type = Envelope_TYPE_VOL;	// Type de l'enveloppe courante



/*\\\ DEFINITION DES VARIABLES DE CLASSE PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ METHODES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*==========================================================================*/
/*      Nom: (constructeur)                                                 */
/*      Description: Initialise                                             */
/*==========================================================================*/

PatEdMenuEnvelopes::PatEdMenuEnvelopes (void)
: _win (RSC_OBJ_MP_SUBM_ENV_CUR,
        RSC_CHAR_W * 18,
        RSC_OBJ_MP_SUBM_ENV_CUR_WIN, RSC_OBJ_MP_SUBM_ENV_CUR_CEN,
        RSC_OBJ_MP_SUBM_ENV_CUR_HSL, RSC_OBJ_MP_SUBM_ENV_CUR_VSL,
        RSC_OBJ_MP_SUBM_ENV_CUR_HSL_SBAR, RSC_OBJ_MP_SUBM_ENV_CUR_HSL_SBAR_SLIDER,
        RSC_OBJ_MP_SUBM_ENV_CUR_VSL_SBAR, RSC_OBJ_MP_SUBM_ENV_CUR_VSL_SBAR_SLIDER,
        RSC_OBJ_MP_SUBM_ENV_CUR_HSL_LEFT, RSC_OBJ_MP_SUBM_ENV_CUR_HSL_RIGHT,
        RSC_OBJ_MP_SUBM_ENV_CUR_VSL_UP, RSC_OBJ_MP_SUBM_ENV_CUR_VSL_DOWN,
        RSC_OBJ_MP_SUBM_ENV_CUR_HSL_ZIN, RSC_OBJ_MP_SUBM_ENV_CUR_HSL_ZOUT,
        RSC_OBJ_MP_SUBM_ENV_CUR_VSL_ZIN, RSC_OBJ_MP_SUBM_ENV_CUR_VSL_ZOUT,
        1, 1, 0, 0, 1, 1)
{
	set_submenu (PatEdMenuEnvelopes_SUBMENU_LOOPS);
	_win._father_object_ptr = this;
	_loops._father_object_ptr = this;
	_misc._father_object_ptr = this;
}



/*==========================================================================*/
/*      Nom: check_ok                                                       */
/*      Description: Verifie l'intergrite de l'objet.                       */
/*      Retour: 0 si l'objet parait correct.                                */
/*==========================================================================*/

signed int	PatEdMenuEnvelopes::check_ok (void) const
{
	if (this == NULL)
	{
		LOG_printf ("PatEdMenuEnvelopes::check_ok: Error: \"this\" pointer is NULL.\n");
		return (-1);
	}

	return (0);
}



/*==========================================================================*/
/*      Nom: self_display                                                   */
/*      Description: Affiche "textuellement" le contenu courant de l'objet. */
/*==========================================================================*/

void	PatEdMenuEnvelopes::self_display (void) const
{

	/*** A faire ***/

}



/*==========================================================================*/
/*      Nom: redraw                                                         */
/*      Description: Affiche la composante d'interface.                     */
/*==========================================================================*/

void	PatEdMenuEnvelopes::redraw (void)
{
	int		width;
	int		height;

	/* Met la fenetre aux bonnes dimensions */
	width =   RSC_get_width (RSC_OBJ_MP_SUBM)
	        - RSC_get_width (RSC_OBJ_MP_SUBM_ENV_LP);
	height =   RSC_get_height (RSC_OBJ_MP_SUBM)
	         - RSC_get_height (RSC_OBJ_MP_SUBM_ENV_ET_VOL);
	_win.set_width (width);
	_win.set_height (height);

	RSC_display_object (RSC_OBJ_MP_SUBM);

	_win.restore_view ();

	refresh ();
}



/*==========================================================================*/
/*      Nom: refresh                                                        */
/*      Description: Rafraichit l'affichage des donnees.                    */
/*==========================================================================*/

void	PatEdMenuEnvelopes::refresh (void)
{
	RSC_select_radio_button_display (ENV_BUTTONS [cur_env_type], ENV_BUTTONS [0]);

	_win.refresh ();

	switch (_submenu)
	{
	case	PatEdMenuEnvelopes_SUBMENU_LOOPS:
		_loops.refresh ();
		break;
	case	PatEdMenuEnvelopes_SUBMENU_MISC:
		_misc.refresh ();
		break;
	}

	refresh_dynamic (true);
}



/*==========================================================================*/
/*      Nom: refresh_dynamic                                                */
/*      Description: Rafraichit l'affichage des donnees dynamiques.         */
/*        - force_flag: true indique qu'on doit forcer le rafraichissement. */
/*==========================================================================*/

void	PatEdMenuEnvelopes::refresh_dynamic (bool force_flag)
{
	_win.refresh_dynamic (force_flag);

	switch (_submenu)
	{
	case	PatEdMenuEnvelopes_SUBMENU_LOOPS:
		_loops.refresh_dynamic (force_flag);
		break;
	case	PatEdMenuEnvelopes_SUBMENU_MISC:
		_misc.refresh_dynamic (force_flag);
		break;
	}
}



/*==========================================================================*/
/*      Nom: manage                                                         */
/*      Description: Gere la composante d'interface                         */
/*      Parametres en entree:                                               */
/*        - sel_object: objet detecte par le gestionnaire d'interface       */
/*        - sel_elder: aine de sel_object                                   */
/*==========================================================================*/

void	PatEdMenuEnvelopes::manage (int sel_object, int sel_elder)
{
	int		env_type;

	_win.manage (sel_object, sel_elder);

	/* Types d'envelope */
	for (env_type = 0; env_type < Envelope_NBR_TYPES; env_type ++)
	{
		if (sel_object == ENV_BUTTONS [env_type])
		{
			cur_env_type = env_type;
			_win.restore_view ();
			refresh ();
			break;
		}
	}

	switch (sel_object)
	{
	case	RSC_OBJ_MP_SUBM_ENV_PICN_LP:
		set_submenu (PatEdMenuEnvelopes_SUBMENU_LOOPS);
		redraw ();
		break;
	case	RSC_OBJ_MP_SUBM_ENV_PICN_MISC:
		set_submenu (PatEdMenuEnvelopes_SUBMENU_MISC);
		redraw ();
		break;

	default:
		switch (_submenu)
		{
		case	PatEdMenuEnvelopes_SUBMENU_LOOPS:
			_loops.manage (sel_object, sel_elder);
			break;
		case	PatEdMenuEnvelopes_SUBMENU_MISC:
			_misc.manage (sel_object, sel_elder);
			break;
		}
	}
}



/*==========================================================================*/
/*      Nom: activate                                                       */
/*      Description: Active ou desactive le menu. Celui-ci n'est pas        */
/*                   reaffiche.                                             */
/*      Parametres en entree:                                               */
/*        - activated_flag: indique si le menu doit etre active ou          */
/*                          desactive.                                      */
/*==========================================================================*/

void	PatEdMenuEnvelopes::activate (bool activated_flag)
{
	RSC_pos_flag (RSC_OBJ_MP_SUBM_ENV, RSC_ATTR_NOTDISP, ! activated_flag);
	RSC_pos_flag (RSC_OBJ_MP_SMICN_ENV, RSC_ATTR_SELECTED, activated_flag);
}



int	PatEdMenuEnvelopes::get_submenu (void) const
{
	return (_submenu);
}



void	PatEdMenuEnvelopes::set_submenu (int submenu)
{
	int		menu_cnt;
	bool		activate_flag;

	_submenu = submenu;

	/* Activation des menus */
	for (menu_cnt = 0; menu_cnt < PatEdMenuEnvelopes_NBR_SUBMENUS; menu_cnt ++)
	{
		activate_flag = (menu_cnt == _submenu);

		switch (menu_cnt)
		{
		case	PatEdMenuEnvelopes_SUBMENU_LOOPS:
			_loops.activate (activate_flag);
			break;
		case	PatEdMenuEnvelopes_SUBMENU_MISC:
			_misc.activate (activate_flag);
			break;
		}
	}
}



/*\\\ METHODES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/****************************************************************************/
/*                                                                          */
/*                                                                          */
/*                                                                          */
/****************************************************************************/



/*==========================================================================*/
/*      Nom:                                                                */
/*      Description:                                                        */
/*      Parametres en entree:                                               */
/*      Parametres en sortie:                                               */
/*      Parametres en entree/sortie:                                        */
/*      Retour:                                                             */
/*==========================================================================*/
