/*****************************************************************************

        GRAOUMF TRACKER 2
        Author: Laurent de Soras, 1996-2016

--- Legal stuff ---

This program is free software. It comes without any warranty, to
the extent permitted by applicable law. You can redistribute it
and/or modify it under the terms of the Do What The Fuck You Want
To Public License, Version 2, as published by Sam Hocevar. See
http://sam.zoy.org/wtfpl/COPYING for more details.

*****************************************************************************/



#if defined (FileSelector_CURRENT_HEADER)
	#error Inclusion recursive du header FileSelector.
#endif
#define	FileSelector_CURRENT_HEADER

#if ! defined (FileSelector_HEADER_INCLUDED)
#define	FileSelector_HEADER_INCLUDED



/*\\\ INCLUDES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	"Directory.h"
#include	"fnames.h"
#include	"Image.h"
#include	"sliders.h"

#include <memory>
#include <string>



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ TYPES & STRUCTURES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ DEFINITION DE LA CLASSE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

class FileSelector
{



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:
static const int	BUTTON_NONE;
static const int	BUTTON_OK;
static const int	BUTTON_CANCEL;



/*\\\ PROTOTYPES DES METHODES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:
FileSelector (const char *path_in_0, const char *file_in_0, const char *label_0, const char *filter_string_0, bool multiple_flag = false);
~FileSelector ();
signed int	check_ok () const;
void		self_display () const;

signed int	manage ();
void		redraw ();
void		refresh ();
std::string	get_filename () const;
std::vector <std::string> get_multiple_files () const;
std::string	get_pathname () const;
std::string	get_mask () const;
signed int	get_filter_nbr (const char *mask_0) const;
signed int	get_last_valid_filter_nbr () const;
void	set_filter_nbr (int filter_nbr);



/*\\\ ATTRIBUTS PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:



/*\\\ VARIABLES DE CLASSE PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:
static FileSelector	*displayed_file_selector_ptr;



/*\\\ CONSTANTES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:
static const int	NBR_DISP_FILENAMES;
static const int	FILENAME_DISPLEN;
static const char	*SORT_TYPES_0 [5];


/*\\\ PROTOTYPES DES METHODES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:
std::string complete_path (const char *path_in_0) const;
const char	*get_filter_name_0 (int filter_nbr) const;
bool			get_filter_mask_0 (char *dest_mask_0, int filter_nbr) const;
signed int	refresh_misc ();
signed int	refresh_window ();
signed int	refresh_info_bar ();
signed int	read_directory (const char *path_in_0, const char *mask_0);
void			free_directory ();
bool			select_files ();
void			select_one_file (int index);
int			get_selected_file_index () const;
void			autoselection ();
void			select_all ();
void			deselect_all ();
signed int	enter_directory (const char *dir_name_0);
signed int	close_directory ();
signed int	select_drive ();
signed int	select_filter ();
void			adapt_fileext_to_filter ();
std::string add_fileext () const;



/*\\\ ATTRIBUTS PRIVES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:
int		_nbr_disp_filenames;
std::string _label;           // Titre du formulaire
std::string _current_path;    // Chemin courant entier
std::string _current_mask;    // Nom du masque courant
char		_current_filename_0 [FNAM_FILENAME_MAXLEN+1];	/* Nom du fichier courant */
int		_sort_type;				/* Type de tri pour l'affichage du repertoire */
int		_winpos_in_dir;		/* Position de la fenetre d'affichage dans le repertoire courant */
std::unique_ptr <Directory> _dir_uptr;			/* pointeur sur le repertoire courant */
std::string _filter_string;   // Pointeur sur la chaine des masques
int		_win_car_width;
int		_win_pix_height;
int		_form_pix_width;		/* Taille du selecteur (sans les ombres) */
int		_form_pix_height;
int		_form_pix_x_pos;		/* Position du selecteur */
int		_form_pix_y_pos;
std::unique_ptr <Image> _background_uptr;
bool		_display_flag;
SLID_INFO	_slider;
int		_filter_nbr;			/* Dernier filtre valide qui a ete selectionne */
bool     _multiple_flag = false;



/*\\\ VARIABLES DE CLASSE PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:



/*\\\ PROTOTYPES DES METHODES INTERDITES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:
FileSelector ();
FileSelector (const FileSelector &other);
void		operator = (const FileSelector &other);

};	// Fin de la definition de la classe



/*\\\ FIN DU FICHIER \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#endif

#undef FileSelector_CURRENT_HEADER
