/*****************************************************************************

        GRAOUMF TRACKER 2
        Author: Laurent de Soras, 1996-2016

--- Legal stuff ---

This program is free software. It comes without any warranty, to
the extent permitted by applicable law. You can redistribute it
and/or modify it under the terms of the Do What The Fuck You Want
To Public License, Version 2, as published by Sam Hocevar. See
http://sam.zoy.org/wtfpl/COPYING for more details.

*****************************************************************************/



#if defined (DialBox_CURRENT_HEADER)
	#error Inclusion recursive du header DialBox.
#endif
#define	DialBox_CURRENT_HEADER

#if ! defined (DialBox_HEADER_INCLUDED)
#define	DialBox_HEADER_INCLUDED



/*\\\ INCLUDES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	"archi.h"
#include	"sliders.h"

#include	<string>
#include	<vector>



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

/* Limites des boites de dialogue */
#define	DialBox_NBR_LIN_MAX	16			/* Nombre maximum de lignes */
#define	DialBox_NBR_BUT_MAX	8			/* Nombre maximum de boutons */



/*\\\ TYPES & STRUCTURES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ DEFINITION DE LA CLASSE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

class DialBox
{



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:



/*\\\ PROTOTYPES DES METHODES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:
DialBox (const char *title_0, const char *text_0, const char *buttons_0);
~DialBox (void);
signed int	check_ok (void) const;
void		self_display (void) const;

signed int	manage (signed int default_button = 0, signed int cancel_button = 0);
void		redraw (bool content_only_flag = false);



/*\\\ ATTRIBUTS PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:



/*\\\ VARIABLES DE CLASSE PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:
static DialBox	*displayed_dialog_box_ptr;



/*\\\ CONSTANTES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:



/*\\\ PROTOTYPES DES METHODES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:

void		change_disp_line (int disp_line);



/*\\\ ATTRIBUTS PRIVES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:

typedef	std::vector <std::string>	StringArray;

std::string	_title;
StringArray	_line_arr;
StringArray	_button_arr;
int		_nbr_disp_lines;
int		_nbr_buttons;
int		_biggest_line_len;
int		_biggest_button_len;
bool		_displayed_flag;
bool		_slider_flag;
int		_line_offset;
int		_pix_width;
int		_pix_height;
int		_pix_x_pos;
int		_pix_y_pos;
SLID_INFO	_slider;


/*\\\ VARIABLES DE CLASSE PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:
static const int	line_object [DialBox_NBR_LIN_MAX];
static const int	button_object [DialBox_NBR_BUT_MAX];



/*\\\ PROTOTYPES DES METHODES INTERDITES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:
DialBox (void);
DialBox (const DialBox &other);
void	operator = (const DialBox &other);

};	// Fin de la definition de la classe



/*\\\ FIN DU FICHIER \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#endif

#undef DialBox_CURRENT_HEADER
