/*****************************************************************************

        GRAOUMF TRACKER 2
        Author: Laurent de Soras, 1996-2016

--- Legal stuff ---

This program is free software. It comes without any warranty, to
the extent permitted by applicable law. You can redistribute it
and/or modify it under the terms of the Do What The Fuck You Want
To Public License, Version 2, as published by Sam Hocevar. See
http://sam.zoy.org/wtfpl/COPYING for more details.

*****************************************************************************/



#if defined (PLAY_CT_CURRENT_HEADER)
	#error Inclusion recursive du header PLAY_CT.
#endif
#define	PLAY_CT_CURRENT_HEADER

#if ! defined (PLAY_CT_HEADER_INCLUDED)
#define	PLAY_CT_HEADER_INCLUDED



/*\\\ INCLUDES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include "StereoGain.h"



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ TYPES & STRUCTURES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/* Element du tableau de la configuration des sources d'un effet */
struct PLAY_SOURCE_TRACK_CONF_BLOCK
{
	BYTE				track_type;			/* Type de la voie: SPL, FX ou AIN */
	bool				wet_flag;			/* Pour les pistes d'effets, 0 = dry, 1 = wet */
	WORD				track_nbr;			/* Numero de la voie */
	UWORD				inpvol;				/* Volume d'entree 0...1000...FFFF */
	UWORD				inppan;				/* Balance d'entree 0...8000...FFFF */
	StereoGain		cr;					// Partie destinee au click removal

#if 0	// Enable this to check where copies are used and if we have to copy the cr state or not.
private:
	PLAY_SOURCE_TRACK_CONF_BLOCK &	operator = (const PLAY_SOURCE_TRACK_CONF_BLOCK &other);
#endif
};



/*\\\ FIN DU FICHIER \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#endif

#undef PLAY_CT_CURRENT_HEADER
