/*****************************************************************************

        GRAOUMF TRACKER 2
        Author: Laurent de Soras, 1996-2016

--- Legal stuff ---

This program is free software. It comes without any warranty, to
the extent permitted by applicable law. You can redistribute it
and/or modify it under the terms of the Do What The Fuck You Want
To Public License, Version 2, as published by Sam Hocevar. See
http://sam.zoy.org/wtfpl/COPYING for more details.

*****************************************************************************/



#if defined (MEM_CURRENT_HEADER)
	#error Inclusion recursive du header MEM.
#endif
#define	MEM_CURRENT_HEADER

#if ! defined (MEM_HEADER_INCLUDED)
#define	MEM_HEADER_INCLUDED



/*\\\ INCLUDES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	"archi.h"



/*\\\ CONSTANTES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

/*--------------------------------------------------------------------------*/
/*      Controle des allocations dynamiques de memoire                      */
/*--------------------------------------------------------------------------*/

#define MALLOC(x)		MEM_malloc(x)
#define STRDUP(x)		MEM_strdup(x)
#define REALLOC(x,y)	MEM_realloc(x,y)
#define FREE(x)		MEM_free(x)

#if ! defined (NDEBUG)
#define MCHECK(x)		MEM_mcheck(x)
#else
#define MCHECK(x)
#endif


/*\\\ TYPES & STRUCTURES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ PROTOTYPES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

void	*MEM_max_malloc (signed long max_block_len, long min_block_len, long *block_len_ptr);

/*--------------------------------------------------------------------------*/
/*      Operations sur la memoire                                           */
/*--------------------------------------------------------------------------*/

void	MEM_invert_memory_byte (void *ptr_zone, LWORD length);
void	MEM_invert_memory_word (void *ptr_zone, LWORD length);
void	MEM_invert_memory_lword (void *ptr_zone, LWORD length);
void	MEM_rotate_memory (void *ptr_zone, LWORD length, SLWORD depl);

/*--------------------------------------------------------------------------*/
/*      Controle des allocations dynamiques de memoire                      */
/*--------------------------------------------------------------------------*/

void *MEM_malloc (size_t size);
char *MEM_strdup (const char *cpsz_src);
void *MEM_realloc(void *p_manip, size_t size);
void	MEM_free(void *p_manip);

#if ! defined (NDEBUG)
void *MEM_mcheck (void *p_manip);
void	MEM_memstat(void);
void	MEM_dump64 (void *dump_ptr);
#endif



/*\\\ VARIABLES EXTERNES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ FIN DU FICHIER \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#endif

#undef MEM_CURRENT_HEADER
