/*****************************************************************************

        GRAOUMF TRACKER 2
        Author: Laurent de Soras, 1996-2016

--- Legal stuff ---

This program is free software. It comes without any warranty, to
the extent permitted by applicable law. You can redistribute it
and/or modify it under the terms of the Do What The Fuck You Want
To Public License, Version 2, as published by Sam Hocevar. See
http://sam.zoy.org/wtfpl/COPYING for more details.

*****************************************************************************/



/*\\\ FICHIERS INCLUDE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	<stdio.h>

#include	"archi.h"
#include	"base_ct.h"
#include	"Container.h"
#include	"log.h"
#include	"PatEvent.h"
#include	"patt.h"
#include	"UndoCell.h"
#include	"UndoCellPatNote.h"



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ CONSTANTES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ TYPES & STRUCTURES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ DEFINITION DES VARIABLES DE CLASSE PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ DEFINITION DES VARIABLES DE CLASSE PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ METHODES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*==========================================================================*/
/*      Nom: (constructeur)                                                 */
/*      Description: Initialise                                             */
/*      Parametres en entree:                                               */
/*      Parametres en sortie:                                               */
/*      Parametres en entree/sortie:                                        */
/*==========================================================================*/

UndoCellPatNote::UndoCellPatNote (int track_type, int pattern, int line, int track)
{
	_track_type = track_type;
	_pattern = pattern;
	_line = line;
	_track = track;
	_data.set_data (_track_type,
	                (UBYTE *) PAT_get_note_adr_pat (_track_type, _pattern,
	                                                _line, _track));
}



/* Ne devrait pas etre utilise tel quel */
UndoCellPatNote::UndoCellPatNote (void)
: _data ()
{
	_track_type = 0;
	_pattern = 0;
	_line = 0;
	_track = 0;
}



UndoCellPatNote::UndoCellPatNote (const UndoCellPatNote &other)
: _data (other._data)
{
	_track_type = other._track_type;
	_pattern = other._pattern;
	_line = other._line;
	_track = other._track;
}



/*==========================================================================*/
/*      Nom: (destructeur)                                                  */
/*      Description: Detruit                                                */
/*==========================================================================*/

UndoCellPatNote::~UndoCellPatNote (void)
{

	/*** A faire ***/

}



/*==========================================================================*/
/*      Nom: check_ok                                                       */
/*      Description: Verifie l'intergrite de l'objet.                       */
/*      Retour: 0 si l'objet parait correct.                                */
/*==========================================================================*/

signed int	UndoCellPatNote::check_ok (void) const
{
	if (this == NULL)
	{
		LOG_printf ("UndoCellPatNote::check_ok: Error: \"this\" pointer is NULL.\n");
		return (-1);
	}

	/*** A faire ***/

	return (0);
}



/*==========================================================================*/
/*      Nom: self_display                                                   */
/*      Description: Affiche "textuellement" le contenu courant de l'objet. */
/*==========================================================================*/

void	UndoCellPatNote::self_display (void) const
{

	/*** A faire ***/

}



Container	*UndoCellPatNote::create (void) const
{
	return (new UndoCellPatNote ());
}



Container	*UndoCellPatNote::clone (void) const
{
	return (new UndoCellPatNote (*this));
}



void	UndoCellPatNote::apply_undo (void)
{
	PatEvent	redo_data;

	redo_data.set_data (_track_type,
	                    (UBYTE *) PAT_get_note_adr_pat (_track_type, _pattern,
	                                                _line, _track));
	_data.get_data (_track_type,
	                (UBYTE *) PAT_get_note_adr_pat (_track_type, _pattern,
	                                                _line, _track));
	_data = redo_data;
}



void	UndoCellPatNote::apply_redo (void)
{
	apply_undo ();
}



/*\\\ METHODES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/****************************************************************************/
/*                                                                          */
/*                                                                          */
/*                                                                          */
/****************************************************************************/



/*==========================================================================*/
/*      Nom:                                                                */
/*      Description:                                                        */
/*      Parametres en entree:                                               */
/*      Parametres en sortie:                                               */
/*      Parametres en entree/sortie:                                        */
/*      Retour:                                                             */
/*==========================================================================*/
