/*****************************************************************************

        GRAOUMF TRACKER 2
        Author: Laurent de Soras, 1996-2016

--- Legal stuff ---

This program is free software. It comes without any warranty, to
the extent permitted by applicable law. You can redistribute it
and/or modify it under the terms of the Do What The Fuck You Want
To Public License, Version 2, as published by Sam Hocevar. See
http://sam.zoy.org/wtfpl/COPYING for more details.

*****************************************************************************/



/*\\\ FICHIERS INCLUDE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	<stdio.h>

#include	"base_ct.h"
#include	"Container.h"
#include	"log.h"
#include	"patt.h"
#include	"UndoCell.h"
#include	"UndoCellPatChgHeight.h"



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ CONSTANTES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ TYPES & STRUCTURES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ DEFINITION DES VARIABLES DE CLASSE PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ DEFINITION DES VARIABLES DE CLASSE PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ METHODES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*==========================================================================*/
/*      Nom: (constructeur)                                                 */
/*      Description: Initialise                                             */
/*      Parametres en entree:                                               */
/*      Parametres en sortie:                                               */
/*      Parametres en entree/sortie:                                        */
/*==========================================================================*/

UndoCellPatChgHeight::UndoCellPatChgHeight (int pattern, int nbr_lines)
{
	_pattern = pattern;
	_nbr_lines = nbr_lines;
}



/* Ne devrait pas etre utilise tel quel */
UndoCellPatChgHeight::UndoCellPatChgHeight (void)
{
	_pattern = 0;
	_nbr_lines = 0;
}



UndoCellPatChgHeight::UndoCellPatChgHeight (const UndoCellPatChgHeight &other)
{
	_pattern = other._pattern;
	_nbr_lines = other._nbr_lines;
}



/*==========================================================================*/
/*      Nom: (destructeur)                                                  */
/*      Description: Detruit                                                */
/*==========================================================================*/

UndoCellPatChgHeight::~UndoCellPatChgHeight (void)
{

	/*** A faire ***/

}



/*==========================================================================*/
/*      Nom: check_ok                                                       */
/*      Description: Verifie l'intergrite de l'objet.                       */
/*      Retour: 0 si l'objet parait correct.                                */
/*==========================================================================*/

signed int	UndoCellPatChgHeight::check_ok (void) const
{
	if (this == NULL)
	{
		LOG_printf ("UndoCellPatChgHeight::check_ok: Error: \"this\" pointer is NULL.\n");
		return (-1);
	}

	/*** A faire ***/

	return (0);
}



/*==========================================================================*/
/*      Nom: self_display                                                   */
/*      Description: Affiche "textuellement" le contenu courant de l'objet. */
/*==========================================================================*/

void	UndoCellPatChgHeight::self_display (void) const
{

	/*** A faire ***/

}



Container	*UndoCellPatChgHeight::create (void) const
{
	return (new UndoCellPatChgHeight ());
}



Container	*UndoCellPatChgHeight::clone (void) const
{
	return (new UndoCellPatChgHeight (*this));
}



void	UndoCellPatChgHeight::apply_undo (void)
{
	int		old_nbr_lines;

	old_nbr_lines = PAT_get_pattern_height (_pattern);
	if (PAT_set_pattern_height (_pattern, _nbr_lines))
	{
		LOG_printf ("UndoCellPatChgHeight::apply_undo: Error: Couldn't change the number of lines of pattern # %d.\n",
		            _pattern);
		return;
	}
	_nbr_lines = old_nbr_lines;
}



void	UndoCellPatChgHeight::apply_redo (void)
{
	apply_undo ();
}



/*\\\ METHODES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/****************************************************************************/
/*                                                                          */
/*                                                                          */
/*                                                                          */
/****************************************************************************/



/*==========================================================================*/
/*      Nom:                                                                */
/*      Description:                                                        */
/*      Parametres en entree:                                               */
/*      Parametres en sortie:                                               */
/*      Parametres en entree/sortie:                                        */
/*      Retour:                                                             */
/*==========================================================================*/
