/*****************************************************************************

        GRAOUMF TRACKER 2
        Author: Laurent de Soras, 1996-2016

--- Legal stuff ---

This program is free software. It comes without any warranty, to
the extent permitted by applicable law. You can redistribute it
and/or modify it under the terms of the Do What The Fuck You Want
To Public License, Version 2, as published by Sam Hocevar. See
http://sam.zoy.org/wtfpl/COPYING for more details.

*****************************************************************************/



/*\\\ FICHIERS INCLUDE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	<stdio.h>

#include	"base.h"
#include	"base_ct.h"
#include	"gtracker.h"
#include	"intrface.h"
#include	"SplEdVumetres.h"
#include	"resource.h"
#include	"rsc01.h"



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ CONSTANTES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ TYPES & STRUCTURES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ DEFINITION DES VARIABLES DE CLASSE PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ DEFINITION DES VARIABLES DE CLASSE PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ METHODES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*==========================================================================*/
/*      Nom: redraw                                                         */
/*      Description: Affiche la composante d'interface.                     */
/*==========================================================================*/

void	SplEdVumetres::redraw (void)
{
	RSC_display_object (RSC_OBJ_SE_VU);

	refresh ();
}



/*==========================================================================*/
/*      Nom: refresh                                                        */
/*      Description: Rafraichit l'affichage des donnees.                    */
/*==========================================================================*/

void	SplEdVumetres::refresh (void)
{

	/*** A faire ***/

	refresh_dynamic (true);
}



/*==========================================================================*/
/*      Nom: manage                                                         */
/*      Description: Gere la composante d'interface                         */
/*      Parametres en entree:                                               */
/*        - sel_object: objet detecte par le gestionnaire d'interface       */
/*        - sel_elder: aine de sel_object                                   */
/*==========================================================================*/

void	SplEdVumetres::manage (int sel_object, int sel_elder)
{
	switch (sel_object)
	{

	/* Vu-metre gauche */
	case	RSC_OBJ_SE_VU_LEFT_DISP:
		INTR_dialog_box ("", "Not implemented", "Cancel", 0, 0);
		/*** A faire ***/
		break;

	/* Valeur vu-metre gauche */
	case	RSC_OBJ_SE_VU_LEFT_VAL:
		INTR_dialog_box ("", "Not implemented", "Cancel", 0, 0);
		/*** A faire ***/
		break;

	/* Vu-metre droit */
	case	RSC_OBJ_SE_VU_RIGHT_DISP:
		INTR_dialog_box ("", "Not implemented", "Cancel", 0, 0);
		/*** A faire ***/
		break;

	/* Valeur vu-metre droit */
	case	RSC_OBJ_SE_VU_RIGHT_VAL:
		INTR_dialog_box ("", "Not implemented", "Cancel", 0, 0);
		/*** A faire ***/
		break;

	}
}



int	SplEdVumetres::get_width (void)
{
	return (RSC_get_width (RSC_OBJ_SE_VU));
}



int	SplEdVumetres::get_height (void)
{
	return (RSC_get_height (RSC_OBJ_SE_VU));
}



void	SplEdVumetres::set_height (int height)
{
	int		x;
	int		y;
	int		height_for_vu;

	height = MAX (height, 150);	// On fixe quand meme une valeur minimum

	RSC_set_height (RSC_OBJ_SE_VU, height);

	RSC_get_relative_object_position (RSC_OBJ_SE_VU_LEFT, x, y);
	height_for_vu =   height - 4
	                - RSC_get_height (RSC_OBJ_SE_VU_LEFT_VAL) - 4 - y;

	/* Change la taille des vu-metres */
	RSC_set_height (RSC_OBJ_SE_VU_LEFT_DISP, height_for_vu);
	RSC_set_height (RSC_OBJ_SE_VU_RIGHT_DISP, height_for_vu);

	/* Colle l'affichage numerique vers en bas des vu-metres */
	RSC_get_relative_object_position (RSC_OBJ_SE_VU_LEFT_DISP, x, y);
	y += height_for_vu + 4;
	RSC_set_relative_object_position (RSC_OBJ_SE_VU_LEFT_VAL, x, y);

	RSC_get_relative_object_position (RSC_OBJ_SE_VU_RIGHT_DISP, x, y);
	y += height_for_vu + 4;
	RSC_set_relative_object_position (RSC_OBJ_SE_VU_RIGHT_VAL, x, y);
}



void	SplEdVumetres::get_coordinates (int &pix_x, int &pix_y)
{
	pix_x = RSC_absolute_object_pixxpos [RSC_OBJ_SE_VU];
	pix_y = RSC_absolute_object_pixypos [RSC_OBJ_SE_VU];
}



void	SplEdVumetres::move_to (int pix_x, int pix_y)
{
	RSC_set_absolute_object_position (RSC_OBJ_SE_VU, pix_x, pix_y);
}



/*\\\ METHODES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/****************************************************************************/
/*                                                                          */
/*                                                                          */
/*                                                                          */
/****************************************************************************/



/*==========================================================================*/
/*      Nom:                                                                */
/*      Description:                                                        */
/*      Parametres en entree:                                               */
/*      Parametres en sortie:                                               */
/*      Parametres en entree/sortie:                                        */
/*      Retour:                                                             */
/*==========================================================================*/
