/*****************************************************************************

        GRAOUMF TRACKER 2
        Author: Laurent de Soras, 1996-2016

--- Legal stuff ---

This program is free software. It comes without any warranty, to
the extent permitted by applicable law. You can redistribute it
and/or modify it under the terms of the Do What The Fuck You Want
To Public License, Version 2, as published by Sam Hocevar. See
http://sam.zoy.org/wtfpl/COPYING for more details.

*****************************************************************************/



#if defined (SplEdMainLoop_CURRENT_HEADER)
	#error Inclusion recursive du header SplEdMainLoop.
#endif
#define	SplEdMainLoop_CURRENT_HEADER

#if ! defined (SplEdMainLoop_HEADER_INCLUDED)
#define	SplEdMainLoop_HEADER_INCLUDED



/*\\\ INCLUDES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	"archi.h"
#include	"Container.h"
#include	"InterfaceComponent.h"
#include	"List.h"
#include	"SplEdCurrentSample.h"
#include	"SplEdIcons.h"
#include	"SplEdMenus.h"
#include	"SplEdMenuBar.h"
#include	"SplEdNumericDisplay.h"
#include	"SplEdVumetres.h"
#include	"SplEdWindow.h"



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

/* Modes d'edition (dou de representation) du sample */
enum
{
	SplEdMainLoop_MODE_NORMAL = 0,
	SplEdMainLoop_MODE_LOOP,
	SplEdMainLoop_MODE_FFT
};



/*\\\ TYPES & STRUCTURES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

/*** Tres sale ***/

class SplEdMainLoop_PACK_NODE
: public Container
{
public:
	int		type;		/* Type de l'element: sous-liste ou partie de l'ecran */
	union
	{
		List		*list_ptr;
		InterfaceComponent	*comp_ptr;
	}			data;

	int		check_ok (void) const { return (0); }
	void		self_display (void) const {}
	Container	*create (void) const { return (new SplEdMainLoop_PACK_NODE ()); }
	Container	*clone (void) const { return (new SplEdMainLoop_PACK_NODE (*this)); }
};



/*\\\ DEFINITION DE LA CLASSE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

class SplEdMainLoop
: public InterfaceComponent
{



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:



/*\\\ PROTOTYPES DES METHODES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:
SplEdMainLoop (void);

void		redraw (void);
void		refresh (void);
void		refresh_dynamic (bool force_flag);
void		manage (int sel_object, int sel_elder);

int		get_width (void);
int		get_height (void);
void		set_width (int width);
void		set_height (int height);
void		pack (void);



/*\\\ ATTRIBUTS PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:



/*\\\ VARIABLES DE CLASSE PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:
static int	edit_mode;


/*\\\ CONSTANTES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:



/*\\\ PROTOTYPES DES METHODES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:
void		get_node_dimensions (List *list_ptr, int &width, int &height, int level);
void		pack_recursive (List *list_ptr, int x, int y, int level);



/*\\\ ATTRIBUTS PRIVES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:
SplEdWindow				_window;
SplEdNumericDisplay	_numdisp;
SplEdCurrentSample	_curspl;
SplEdMenuBar			_menubar;
SplEdIcons				_icons;
SplEdVumetres			_vumetres;
SplEdMenus				_menus;

List	_list_array [4];



/*\\\ VARIABLES DE CLASSE PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:



/*\\\ PROTOTYPES DES METHODES INTERDITES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:
void		operator = (const SplEdMainLoop &other);
int		operator == (const SplEdMainLoop &other) const;

};	// Fin de la definition de la classe



/*\\\ FIN DU FICHIER \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#endif

#undef SplEdMainLoop_CURRENT_HEADER
