/*****************************************************************************

        GRAOUMF TRACKER 2
        Author: Laurent de Soras, 1996-2016

--- Legal stuff ---

This program is free software. It comes without any warranty, to
the extent permitted by applicable law. You can redistribute it
and/or modify it under the terms of the Do What The Fuck You Want
To Public License, Version 2, as published by Sam Hocevar. See
http://sam.zoy.org/wtfpl/COPYING for more details.

*****************************************************************************/



/*\\\ FICHIERS INCLUDE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	"base.h"
#include	"base_ct.h"
#include	"log.h"
#include	"SoundDriver.h"

#include	<cstdio>



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ CONSTANTES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ TYPES & STRUCTURES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ DEFINITION DES VARIABLES DE CLASSE PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ DEFINITION DES VARIABLES DE CLASSE PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ METHODES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*==========================================================================*/
/*      Nom: (constructeur)                                                 */
/*      Description: Initialise                                             */
/*      Parametres en entree:                                               */
/*      Parametres en sortie:                                               */
/*      Parametres en entree/sortie:                                        */
/*==========================================================================*/

SoundDriver::SoundDriver (void)
:	_init (NULL)
,	_restore (NULL)
,	_set_config (NULL)
,	_get_config (NULL)
,	_start_replay (NULL)
,	_stop_replay (NULL)
,	_set_new_frame (NULL)
,	_set_data (NULL)
,	_get_data (NULL)
,	_is_playing (NULL)
,	_disconnect (NULL)
,	_connect (NULL)
,	_is_connected (NULL)
,	_get_message (NULL)
,	_get_latency (NULL)
,	_set_latency (NULL)
,	_message_buffer_0 ()
,	_driver_mutex ()
{
	// Nothing
}



/*==========================================================================*/
/*      Nom: (destructeur)                                                  */
/*      Description: Detruit                                                */
/*==========================================================================*/

SoundDriver::~SoundDriver (void)
{
	// Nothing
}



/*==========================================================================*/
/*      Nom: check_ok                                                       */
/*      Description: Verifie l'intergrite de l'objet.                       */
/*      Retour: 0 si l'objet parait correct.                                */
/*==========================================================================*/

signed int	SoundDriver::check_ok (void) const
{
	if (this == NULL)
	{
		LOG_printf ("SoundDriver::check_ok: Error: \"this\" pointer is NULL.\n");
		return (-1);
	}

	/*** A faire ***/

	return (0);
}



/*==========================================================================*/
/*      Nom: self_display                                                   */
/*      Description: Affiche "textuellement" le contenu courant de l'objet. */
/*==========================================================================*/

void	SoundDriver::self_display (void) const
{

	/*** A faire ***/

}



signed int	SoundDriver::init (void *param_ptr)
{
	std::lock_guard <std::mutex>	lock (_driver_mutex);

	int            ret_val = _init (param_ptr);
	print_message ();

	return (ret_val);
}



signed int	SoundDriver::restore (void)
{
	std::lock_guard <std::mutex>	lock (_driver_mutex);

	int            ret_val = _restore ();
	print_message ();

	return (ret_val);
}



signed int	SoundDriver::set_config (SoundDriver_CONFIG *config_ptr)
{
	std::lock_guard <std::mutex>	lock (_driver_mutex);

	int            ret_val = _set_config (config_ptr);
	print_message ();

	return (ret_val);
}



signed int	SoundDriver::get_config (SoundDriver_CONFIG *config_ptr)
{
	std::lock_guard <std::mutex>	lock (_driver_mutex);

	int            ret_val = _get_config (config_ptr);
	print_message ();

	return (ret_val);
}



signed int	SoundDriver::start_replay (void)
{
	std::lock_guard <std::mutex>	lock (_driver_mutex);

	int            ret_val = _start_replay ();
	print_message ();

	return (ret_val);
}



signed int	SoundDriver::stop_replay (void)
{
	std::lock_guard <std::mutex>	lock (_driver_mutex);

	int            ret_val = _stop_replay ();
	print_message ();

	return (ret_val);
}



signed int	SoundDriver::set_new_frame (long frame_length)
{
	std::lock_guard <std::mutex>	lock (_driver_mutex);

	int            ret_val = _set_new_frame (frame_length);
	print_message ();

	return (ret_val);
}



signed int	SoundDriver::set_data (float *out_buffer_ptr [], float *out_clip_ptr)
{
	std::lock_guard <std::mutex>	lock (_driver_mutex);

	int            ret_val = _set_data (out_buffer_ptr, out_clip_ptr);
	print_message ();

	return (ret_val);
}



signed int	SoundDriver::get_data (float *in_buffer_ptr [])
{
	std::lock_guard <std::mutex>	lock (_driver_mutex);

	int            ret_val = _get_data (in_buffer_ptr);
	print_message ();

	return (ret_val);
}



signed int	SoundDriver::is_playing (void)
{
	std::lock_guard <std::mutex>	lock (_driver_mutex);

	int            ret_val = _is_playing ();
	print_message ();

	return (ret_val);
}



signed int	SoundDriver::disconnect (void)
{
	std::lock_guard <std::mutex>	lock (_driver_mutex);

	int            ret_val = _disconnect ();
	print_message ();

	return (ret_val);
}



signed int	SoundDriver::connect (void)
{
	std::lock_guard <std::mutex>	lock (_driver_mutex);

	int            ret_val = _connect ();
	print_message ();

	return (ret_val);
}



signed int	SoundDriver::is_connected (void)
{
	std::lock_guard <std::mutex>	lock (_driver_mutex);

	int            ret_val = _is_connected ();
	print_message ();

	return (ret_val);
}



signed int	SoundDriver::get_message (char *text_0, long max_len)
{
	std::lock_guard <std::mutex>	lock (_driver_mutex);

	return _get_message (text_0, max_len);
}



signed int	SoundDriver::get_latency (void)
{
	std::lock_guard <std::mutex>	lock (_driver_mutex);

	int            ret_val = _get_latency ();
	ret_val = MIN (ret_val, MAX_LATENCY);
	ret_val = MAX (ret_val, 0);

	return (ret_val);
}



signed int	SoundDriver::set_latency (int t)
{
	t = MIN (t, MAX_LATENCY);
	t = MAX (t, 0);

	std::lock_guard <std::mutex>	lock (_driver_mutex);

	return _set_latency (t);
}



/*\\\ METHODES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



// _driver_mutex should be locked.
void	SoundDriver::print_message (void)
{
	while (_get_message (&_message_buffer_0 [0], _message_buffer_0.size () - 1) > 0)
	{
		LOG_printf ("%s", _message_buffer_0);
	}
}



/****************************************************************************/
/*                                                                          */
/*                                                                          */
/*                                                                          */
/****************************************************************************/



/*==========================================================================*/
/*      Nom:                                                                */
/*      Description:                                                        */
/*      Parametres en entree:                                               */
/*      Parametres en sortie:                                               */
/*      Parametres en entree/sortie:                                        */
/*      Retour:                                                             */
/*==========================================================================*/
