/*****************************************************************************

        GRAOUMF TRACKER 2
        Author: Laurent de Soras, 1996-2016

--- Legal stuff ---

This program is free software. It comes without any warranty, to
the extent permitted by applicable law. You can redistribute it
and/or modify it under the terms of the Do What The Fuck You Want
To Public License, Version 2, as published by Sam Hocevar. See
http://sam.zoy.org/wtfpl/COPYING for more details.

*****************************************************************************/



/*\\\ FICHIERS INCLUDE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	<stdio.h>

#include	"base_ct.h"
#include	"log.h"
#include	"PatEdMenuTools.h"
#include	"resource.h"
#include	"rsc01.h"



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ CONSTANTES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

enum
{
	PatEdMenuTools_SUBMENU_MAIN = 0,
	PatEdMenuTools_SUBMENU_SEQ,
	PatEdMenuTools_SUBMENU_CLEAR,
	PatEdMenuTools_SUBMENU_FX,
	PatEdMenuTools_SUBMENU_TRACKS,

	PatEdMenuTools_NBR_SUBMENUS
};



/*\\\ TYPES & STRUCTURES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ DEFINITION DES VARIABLES DE CLASSE PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ DEFINITION DES VARIABLES DE CLASSE PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ METHODES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*==========================================================================*/
/*      Nom: (constructeur)                                                 */
/*      Description: Initialise                                             */
/*==========================================================================*/

PatEdMenuTools::PatEdMenuTools (void)
{
	set_submenu (PatEdMenuTools_SUBMENU_MAIN);
}



/*==========================================================================*/
/*      Nom: check_ok                                                       */
/*      Description: Verifie l'intergrite de l'objet.                       */
/*      Retour: 0 si l'objet parait correct.                                */
/*==========================================================================*/

signed int	PatEdMenuTools::check_ok (void) const
{
	if (this == NULL)
	{
		LOG_printf ("PatEdMenuTools::check_ok: Error: \"this\" pointer is NULL.\n");
		return (-1);
	}

	return (0);
}



/*==========================================================================*/
/*      Nom: self_display                                                   */
/*      Description: Affiche "textuellement" le contenu courant de l'objet. */
/*==========================================================================*/

void	PatEdMenuTools::self_display (void) const
{

	/*** A faire ***/

}



/*==========================================================================*/
/*      Nom: redraw                                                         */
/*      Description: Affiche la composante d'interface.                     */
/*==========================================================================*/

void	PatEdMenuTools::redraw (void)
{
	switch (_submenu)
	{
	case	PatEdMenuTools_SUBMENU_MAIN:
		_main.redraw ();
		break;
	case	PatEdMenuTools_SUBMENU_SEQ:
		_sequence.redraw ();
		break;
	case	PatEdMenuTools_SUBMENU_CLEAR:
		_clear.redraw ();
		break;
	case	PatEdMenuTools_SUBMENU_FX:
		_effects.redraw ();
		break;
	case	PatEdMenuTools_SUBMENU_TRACKS:
		_tracks.redraw ();
		break;
	}
}



/*==========================================================================*/
/*      Nom: refresh                                                        */
/*      Description: Rafraichit l'affichage des donnees.                    */
/*==========================================================================*/

void	PatEdMenuTools::refresh (void)
{
	switch (_submenu)
	{
	case	PatEdMenuTools_SUBMENU_MAIN:
		_main.refresh ();
		break;
	case	PatEdMenuTools_SUBMENU_SEQ:
		_sequence.refresh ();
		break;
	case	PatEdMenuTools_SUBMENU_CLEAR:
		_clear.refresh ();
		break;
	case	PatEdMenuTools_SUBMENU_FX:
		_effects.refresh ();
		break;
	case	PatEdMenuTools_SUBMENU_TRACKS:
		_tracks.refresh ();
		break;
	}
}



/*==========================================================================*/
/*      Nom: refresh_dynamic                                                */
/*      Description: Rafraichit l'affichage des donnees dynamiques.         */
/*        - force_flag: true indique qu'on doit forcer le rafraichissement. */
/*==========================================================================*/

void	PatEdMenuTools::refresh_dynamic (bool force_flag)
{
	switch (_submenu)
	{
	case	PatEdMenuTools_SUBMENU_MAIN:
		_main.refresh_dynamic (force_flag);
		break;
	case	PatEdMenuTools_SUBMENU_SEQ:
		_sequence.refresh_dynamic (force_flag);
		break;
	case	PatEdMenuTools_SUBMENU_CLEAR:
		_clear.refresh_dynamic (force_flag);
		break;
	case	PatEdMenuTools_SUBMENU_FX:
		_effects.refresh_dynamic (force_flag);
		break;
	case	PatEdMenuTools_SUBMENU_TRACKS:
		_tracks.refresh_dynamic (force_flag);
		break;
	}
}



/*==========================================================================*/
/*      Nom: manage                                                         */
/*      Description: Gere la composante d'interface                         */
/*      Parametres en entree:                                               */
/*        - sel_object: objet detecte par le gestionnaire d'interface       */
/*        - sel_elder: aine de sel_object                                   */
/*==========================================================================*/

void	PatEdMenuTools::manage (int sel_object, int sel_elder)
{
	switch (sel_object)
	{
	case	RSC_OBJ_MP_SUBM_TOOLS_PICN_MAIN:
		set_submenu (PatEdMenuTools_SUBMENU_MAIN);
		redraw ();
		break;

	case	RSC_OBJ_MP_SUBM_TOOLS_PICN_SEQ:
		set_submenu (PatEdMenuTools_SUBMENU_SEQ);
		redraw ();
		break;

	case	RSC_OBJ_MP_SUBM_TOOLS_PICN_CLEAR:
		set_submenu (PatEdMenuTools_SUBMENU_CLEAR);
		redraw ();
		break;

	case	RSC_OBJ_MP_SUBM_TOOLS_PICN_FX:
		set_submenu (PatEdMenuTools_SUBMENU_FX);
		redraw ();
		break;

	case	RSC_OBJ_MP_SUBM_TOOLS_PICN_TRK:
		set_submenu (PatEdMenuTools_SUBMENU_TRACKS);
		redraw ();
		break;

	default:
		switch (_submenu)
		{
		case	PatEdMenuTools_SUBMENU_MAIN:
			_main.manage (sel_object, sel_elder);
			break;
		case	PatEdMenuTools_SUBMENU_SEQ:
			_sequence.manage (sel_object, sel_elder);
			break;
		case	PatEdMenuTools_SUBMENU_CLEAR:
			_clear.manage (sel_object, sel_elder);
			break;
		case	PatEdMenuTools_SUBMENU_FX:
			_effects.manage (sel_object, sel_elder);
			break;
		case	PatEdMenuTools_SUBMENU_TRACKS:
			_tracks.manage (sel_object, sel_elder);
			break;
		}
	}
}



/*==========================================================================*/
/*      Nom: activate                                                       */
/*      Description: Active ou desactive le menu. Celui-ci n'est pas        */
/*                   reaffiche.                                             */
/*      Parametres en entree:                                               */
/*        - activated_flag: indique si le menu doit etre active ou          */
/*                          desactive.                                      */
/*==========================================================================*/

void	PatEdMenuTools::activate (bool activated_flag)
{
	RSC_pos_flag (RSC_OBJ_MP_SUBM_TOOLS, RSC_ATTR_NOTDISP, ! activated_flag);
	RSC_pos_flag (RSC_OBJ_MP_SMICN_TOOLS, RSC_ATTR_SELECTED, activated_flag);
}



int	PatEdMenuTools::get_submenu (void) const
{
	return (_submenu);
}



void	PatEdMenuTools::set_submenu (int submenu)
{
	int		menu_cnt;
	bool		activate_flag;

	_submenu = submenu;

	/* Activation des menus */
	for (menu_cnt = 0; menu_cnt < PatEdMenuTools_NBR_SUBMENUS; menu_cnt ++)
	{
		activate_flag = (menu_cnt == _submenu);

		switch (menu_cnt)
		{
		case	PatEdMenuTools_SUBMENU_MAIN:
			_main.activate (activate_flag);
			break;
		case	PatEdMenuTools_SUBMENU_SEQ:
			_sequence.activate (activate_flag);
			break;
		case	PatEdMenuTools_SUBMENU_CLEAR:
			_clear.activate (activate_flag);
			break;
		case	PatEdMenuTools_SUBMENU_FX:
			_effects.activate (activate_flag);
			break;
		case	PatEdMenuTools_SUBMENU_TRACKS:
			_tracks.activate (activate_flag);
			break;
		}
	}
}



/*\\\ METHODES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/****************************************************************************/
/*                                                                          */
/*                                                                          */
/*                                                                          */
/****************************************************************************/



/*==========================================================================*/
/*      Nom:                                                                */
/*      Description:                                                        */
/*      Parametres en entree:                                               */
/*      Parametres en sortie:                                               */
/*      Parametres en entree/sortie:                                        */
/*      Retour:                                                             */
/*==========================================================================*/
