/*****************************************************************************

        GRAOUMF TRACKER 2
        Author: Laurent de Soras, 1996-2016

--- Legal stuff ---

This program is free software. It comes without any warranty, to
the extent permitted by applicable law. You can redistribute it
and/or modify it under the terms of the Do What The Fuck You Want
To Public License, Version 2, as published by Sam Hocevar. See
http://sam.zoy.org/wtfpl/COPYING for more details.

*****************************************************************************/



/*\\\ FICHIERS INCLUDE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	<stdio.h>

#include	"base_ct.h"
#include	"intrface.h"
#include	"log.h"
#include	"mixer.h"
#include	"PatEdMenuFilesS2d.h"
#include	"resource.h"
#include	"rsc01.h"
#include	"samp.h"
#include	"s2d.h"



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ CONSTANTES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ TYPES & STRUCTURES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ DEFINITION DES VARIABLES DE CLASSE PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ DEFINITION DES VARIABLES DE CLASSE PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ METHODES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*==========================================================================*/
/*      Nom: check_ok                                                       */
/*      Description: Verifie l'intergrite de l'objet.                       */
/*      Retour: 0 si l'objet parait correct.                                */
/*==========================================================================*/

signed int	PatEdMenuFilesS2d::check_ok (void) const
{
	if (this == NULL)
	{
		LOG_printf ("PatEdMenuFilesS2d::check_ok: Error: \"this\" pointer is NULL.\n");
		return (-1);
	}

	/*** A faire ***/

	return (0);
}



/*==========================================================================*/
/*      Nom: self_display                                                   */
/*      Description: Affiche "textuellement" le contenu courant de l'objet. */
/*==========================================================================*/

void	PatEdMenuFilesS2d::self_display (void) const
{

	/*** A faire ***/

}



/*==========================================================================*/
/*      Nom: redraw                                                         */
/*      Description: Affiche la composante d'interface.                     */
/*==========================================================================*/

void	PatEdMenuFilesS2d::redraw (void)
{
	RSC_display_object (RSC_OBJ_MP_SUBM);

	refresh ();
}



/*==========================================================================*/
/*      Nom: refresh                                                        */
/*      Description: Rafraichit l'affichage des donnees.                    */
/*==========================================================================*/

void	PatEdMenuFilesS2d::refresh (void)
{
	char		text_0 [127+1];
	int		nbr_bytes;
	int		nbr_tracks;
	long		freq;
	signed long	max_duration;

	nbr_bytes = S2D_get_byte_resolution ();
	nbr_tracks = S2D_get_stereo ();
	freq = S2D_get_frequency ();
	max_duration = S2D_get_max_duration_sample ();

	/* Start */
	sprintf (text_0, INTR_base_song_3, S2D_get_songpos (0));
	RSC_set_string (RSC_OBJ_MP_SUBM_DISK_S2D_RANGE_START_POS_VAL, text_0);
	RSC_display_object (RSC_OBJ_MP_SUBM_DISK_S2D_RANGE_START_POS_VAL);

	sprintf (text_0, INTR_base_lines_3, S2D_get_linepos (0));
	RSC_set_string (RSC_OBJ_MP_SUBM_DISK_S2D_RANGE_START_LINE_VAL, text_0);
	RSC_display_object (RSC_OBJ_MP_SUBM_DISK_S2D_RANGE_START_LINE_VAL);

	/* End */
	sprintf (text_0, INTR_base_song_3, S2D_get_songpos (1));
	RSC_set_string (RSC_OBJ_MP_SUBM_DISK_S2D_RANGE_END_POS_VAL, text_0);
	RSC_display_object (RSC_OBJ_MP_SUBM_DISK_S2D_RANGE_END_POS_VAL);

	sprintf (text_0, INTR_base_lines_3, S2D_get_linepos (1));
	RSC_set_string (RSC_OBJ_MP_SUBM_DISK_S2D_RANGE_END_LINE_VAL, text_0);
	RSC_display_object (RSC_OBJ_MP_SUBM_DISK_S2D_RANGE_END_LINE_VAL);

	/* Frequence d'echantillonnage */
	sprintf (text_0, "%5d", freq);
	RSC_set_string (RSC_OBJ_MP_SUBM_DISK_S2D_TIME_FREQ_VAL, text_0);
	RSC_display_object (RSC_OBJ_MP_SUBM_DISK_S2D_TIME_FREQ_VAL);

	/* Duree maximum */
	if (max_duration >= 0)
	{
		INTR_splpos_2_string (text_0, max_duration,
									 freq, nbr_tracks, nbr_bytes);
	}
	else
	{
		strcpy (text_0, "None");
	}
	RSC_set_string (RSC_OBJ_MP_SUBM_DISK_S2D_TIME_MDUR_VAL, text_0);
	RSC_display_object (RSC_OBJ_MP_SUBM_DISK_S2D_TIME_MDUR_VAL);

	/* Channels */
	if (nbr_tracks == 2)
	{
		RSC_select_radio_button_display (RSC_OBJ_MP_SUBM_DISK_S2D_CHN_STEREO,
		                                 RSC_OBJ_MP_SUBM_DISK_S2D_CHN_MONO);
	}
	else
	{
		RSC_select_radio_button_display (RSC_OBJ_MP_SUBM_DISK_S2D_CHN_MONO,
		                                 RSC_OBJ_MP_SUBM_DISK_S2D_CHN_MONO);
	}

	/* Resolution */
	if (nbr_bytes == 3)
	{
		RSC_select_radio_button_display (RSC_OBJ_MP_SUBM_DISK_S2D_RESOL_24BITS,
		                                 RSC_OBJ_MP_SUBM_DISK_S2D_RESOL_8BITS);
	}
	else if (nbr_bytes == 2)
	{
		RSC_select_radio_button_display (RSC_OBJ_MP_SUBM_DISK_S2D_RESOL_16BITS,
		                                 RSC_OBJ_MP_SUBM_DISK_S2D_RESOL_8BITS);
	}
	else
	{
		RSC_select_radio_button_display (RSC_OBJ_MP_SUBM_DISK_S2D_RESOL_8BITS,
		                                 RSC_OBJ_MP_SUBM_DISK_S2D_RESOL_8BITS);
	}

	/* Qualite */
	if (S2D_get_quality () == MIX_SOUND_QUALITY_BEST)
	{
		RSC_select_radio_button_display (RSC_OBJ_MP_SUBM_DISK_S2D_QUAL_HIGH,
		                                 RSC_OBJ_MP_SUBM_DISK_S2D_QUAL_NORM);
	}
	else
	{
		RSC_select_radio_button_display (RSC_OBJ_MP_SUBM_DISK_S2D_QUAL_NORM,
		                                 RSC_OBJ_MP_SUBM_DISK_S2D_QUAL_NORM);
	}

	/* Largeur de la fenetre du filtre de reconstruction */
	sprintf (text_0, "%3d", S2D_get_window_width ());
	RSC_set_string (RSC_OBJ_MP_SUBM_DISK_S2D_QUAL_FACT_POS_VAL, text_0);
	RSC_display_object (RSC_OBJ_MP_SUBM_DISK_S2D_QUAL_FACT_POS_VAL);

	// Sample group
	const int		group = MIX_get_sample_group ();
	sprintf (text_0, INTR_base_song_3, group);
	RSC_set_string (RSC_OBJ_MP_SUBM_DISK_S2D_GRP_VAL, text_0);
	RSC_display_object (RSC_OBJ_MP_SUBM_DISK_S2D_GRP_VAL);

	if (group == 0)
	{
		sprintf (text_0, "(No group)");
	}
	else
	{
		sprintf (text_0, "%s", SAMP_get_group_name (group).c_str ());
	}
	RSC_set_string (RSC_OBJ_MP_SUBM_DISK_S2D_GRP_NAME, text_0);
	RSC_display_object (RSC_OBJ_MP_SUBM_DISK_S2D_GRP_NAME);

	refresh_dynamic (true);
}



/*==========================================================================*/
/*      Nom: refresh_dynamic                                                */
/*      Description: Rafraichit l'affichage des donnees dynamiques.         */
/*        - force_flag: true indique qu'on doit forcer le rafraichissement. */
/*==========================================================================*/

void	PatEdMenuFilesS2d::refresh_dynamic (bool force_flag)
{
	/* Rien en fait */
}



/*==========================================================================*/
/*      Nom: manage                                                         */
/*      Description: Gere la composante d'interface                         */
/*      Parametres en entree:                                               */
/*        - sel_object: objet detecte par le gestionnaire d'interface       */
/*        - sel_elder: aine de sel_object                                   */
/*==========================================================================*/

void	PatEdMenuFilesS2d::manage (int sel_object, int sel_elder)
{
	switch (sel_object)
	{
	/* Start position */
	case	RSC_OBJ_MP_SUBM_DISK_S2D_RANGE_START_POS_VAL:
		S2D_set_songpos_intr (INTR_CHGTYPE_KBD, 0, 0);
		break;

	case	RSC_OBJ_MP_SUBM_DISK_S2D_RANGE_START_POS_U:
		S2D_set_songpos_intr (INTR_CHGTYPE_REL, INTR_inc_speed [0] [RSC_mouse_key], 0);
		break;

	case	RSC_OBJ_MP_SUBM_DISK_S2D_RANGE_START_POS_D:
		S2D_set_songpos_intr (INTR_CHGTYPE_REL, -INTR_inc_speed [0] [RSC_mouse_key], 0);
		break;

	/* Start line */
	case	RSC_OBJ_MP_SUBM_DISK_S2D_RANGE_START_LINE_VAL:
		S2D_set_linepos_intr (INTR_CHGTYPE_KBD, 0, 0);
		break;

	case	RSC_OBJ_MP_SUBM_DISK_S2D_RANGE_START_LINE_U:
		S2D_set_linepos_intr (INTR_CHGTYPE_REL, INTR_inc_speed [0] [RSC_mouse_key], 0);
		break;

	case	RSC_OBJ_MP_SUBM_DISK_S2D_RANGE_START_LINE_D:
		S2D_set_linepos_intr (INTR_CHGTYPE_REL, -INTR_inc_speed [0] [RSC_mouse_key], 0);
		break;

	/* End position */
	case	RSC_OBJ_MP_SUBM_DISK_S2D_RANGE_END_POS_VAL:
		S2D_set_songpos_intr (INTR_CHGTYPE_KBD, 0, 1);
		break;

	case	RSC_OBJ_MP_SUBM_DISK_S2D_RANGE_END_POS_U:
		S2D_set_songpos_intr (INTR_CHGTYPE_REL, INTR_inc_speed [0] [RSC_mouse_key], 1);
		break;

	case	RSC_OBJ_MP_SUBM_DISK_S2D_RANGE_END_POS_D:
		S2D_set_songpos_intr (INTR_CHGTYPE_REL, -INTR_inc_speed [0] [RSC_mouse_key], 1);
		break;

	/* End line */
	case	RSC_OBJ_MP_SUBM_DISK_S2D_RANGE_END_LINE_VAL:
		S2D_set_linepos_intr (INTR_CHGTYPE_KBD, 0, 1);
		break;

	case	RSC_OBJ_MP_SUBM_DISK_S2D_RANGE_END_LINE_U:
		S2D_set_linepos_intr (INTR_CHGTYPE_REL, INTR_inc_speed [0] [RSC_mouse_key], 1);
		break;

	case	RSC_OBJ_MP_SUBM_DISK_S2D_RANGE_END_LINE_D:
		S2D_set_linepos_intr (INTR_CHGTYPE_REL, -INTR_inc_speed [0] [RSC_mouse_key], 1);
		break;

	/* Frequence */
	case	RSC_OBJ_MP_SUBM_DISK_S2D_TIME_FREQ_VAL:
		S2D_set_frequency_intr (INTR_CHGTYPE_KBD, 0);
		break;

	case	RSC_OBJ_MP_SUBM_DISK_S2D_TIME_FREQ_U:
		S2D_set_frequency_intr (INTR_CHGTYPE_REL, INTR_inc_speed [1] [RSC_mouse_key]);
		break;

	case	RSC_OBJ_MP_SUBM_DISK_S2D_TIME_FREQ_D:
		S2D_set_frequency_intr (INTR_CHGTYPE_REL, -INTR_inc_speed [1] [RSC_mouse_key]);
		break;

	/* Duree maximum */
	case	RSC_OBJ_MP_SUBM_DISK_S2D_TIME_MDUR_VAL:
		if ((RSC_mouse_key & 2) == 2)
		{
			S2D_set_max_duration_intr (INTR_CHGTYPE_ABS, -S2D_get_max_duration_sample ());
		}
		else
		{
			S2D_set_max_duration_intr (INTR_CHGTYPE_KBD, 0);
		}
		break;

	case	RSC_OBJ_MP_SUBM_DISK_S2D_TIME_MDUR_U:
		S2D_set_max_duration_intr (INTR_CHGTYPE_REL, INTR_inc_speed [2] [RSC_mouse_key]);
		break;

	case	RSC_OBJ_MP_SUBM_DISK_S2D_TIME_MDUR_D:
		S2D_set_max_duration_intr (INTR_CHGTYPE_REL, -INTR_inc_speed [2] [RSC_mouse_key]);
		break;

	/* Mono */
	case	RSC_OBJ_MP_SUBM_DISK_S2D_CHN_MONO:
		S2D_set_stereo (1);
		refresh ();
		break;

	/* Stereo */
	case	RSC_OBJ_MP_SUBM_DISK_S2D_CHN_STEREO:
		S2D_set_stereo (2);
		refresh ();
		break;

	/* 8 bits */
	case	RSC_OBJ_MP_SUBM_DISK_S2D_RESOL_8BITS:
		S2D_set_byte_resolution (1);
		refresh ();
		break;

	/* 16 bits */
	case	RSC_OBJ_MP_SUBM_DISK_S2D_RESOL_16BITS:
		S2D_set_byte_resolution (2);
		refresh ();
		break;

	/* 24 bits */
	case	RSC_OBJ_MP_SUBM_DISK_S2D_RESOL_24BITS:
		S2D_set_byte_resolution (3);
		refresh ();
		break;

	/* Enregistrement de la partie du module voulue */
	case	RSC_OBJ_MP_SUBM_DISK_S2D_REC_REC:
		S2D_record_module (false);
		break;

	/* Enregistrement de la totalite du module */
	case	RSC_OBJ_MP_SUBM_DISK_S2D_REC_RECALL:
		S2D_record_module (true);
		break;

	/* Qualite normale */
	case	RSC_OBJ_MP_SUBM_DISK_S2D_QUAL_NORM:
		S2D_set_quality (MIX_SOUND_QUALITY_NORMAL);
		refresh ();
		break;

	/* Qualite haute */
	case	RSC_OBJ_MP_SUBM_DISK_S2D_QUAL_HIGH:
		S2D_set_quality (MIX_SOUND_QUALITY_BEST);
		refresh ();
		break;

	/* Facteur de qualite: largeur de la fenetre */
	case	RSC_OBJ_MP_SUBM_DISK_S2D_QUAL_FACT_POS:
		S2D_set_window_width_intr (INTR_CHGTYPE_KBD, 0);
		break;

	case	RSC_OBJ_MP_SUBM_DISK_S2D_QUAL_FACT_U:
		S2D_set_window_width_intr (INTR_CHGTYPE_REL, INTR_inc_speed [0] [RSC_mouse_key]);
		break;

	case	RSC_OBJ_MP_SUBM_DISK_S2D_QUAL_FACT_D:
		S2D_set_window_width_intr (INTR_CHGTYPE_REL, -INTR_inc_speed [0] [RSC_mouse_key]);
		break;

	// Group
	case	RSC_OBJ_MP_SUBM_DISK_S2D_GRP_VAL:
		S2D_set_sample_group_intr (INTR_CHGTYPE_KBD, 0);
		break;

	case	RSC_OBJ_MP_SUBM_DISK_S2D_GRP_UP:
		S2D_set_sample_group_intr (INTR_CHGTYPE_REL, INTR_inc_speed [0] [RSC_mouse_key]);
		break;

	case	RSC_OBJ_MP_SUBM_DISK_S2D_GRP_DOWN:
		S2D_set_sample_group_intr (INTR_CHGTYPE_REL, -INTR_inc_speed [0] [RSC_mouse_key]);
		break;
	}
}



/*==========================================================================*/
/*      Nom: activate                                                       */
/*      Description: Active ou desactive le menu. Celui-ci n'est pas        */
/*                   reaffiche.                                             */
/*      Parametres en entree:                                               */
/*        - activated_flag: indique si le menu doit etre active ou          */
/*                          desactive.                                      */
/*==========================================================================*/

void	PatEdMenuFilesS2d::activate (bool activated_flag)
{
	RSC_pos_flag (RSC_OBJ_MP_SUBM_DISK_S2D, RSC_ATTR_NOTDISP, ! activated_flag);
	RSC_pos_flag (RSC_OBJ_MP_SUBM_DISK_PICN_S2D, RSC_ATTR_SELECTED, activated_flag);
}



/*\\\ METHODES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/****************************************************************************/
/*                                                                          */
/*                                                                          */
/*                                                                          */
/****************************************************************************/



/*==========================================================================*/
/*      Nom:                                                                */
/*      Description:                                                        */
/*      Parametres en entree:                                               */
/*      Parametres en sortie:                                               */
/*      Parametres en entree/sortie:                                        */
/*      Retour:                                                             */
/*==========================================================================*/
