/*****************************************************************************

        GRAOUMF TRACKER 2
        Author: Laurent de Soras, 1996-2016

--- Legal stuff ---

This program is free software. It comes without any warranty, to
the extent permitted by applicable law. You can redistribute it
and/or modify it under the terms of the Do What The Fuck You Want
To Public License, Version 2, as published by Sam Hocevar. See
http://sam.zoy.org/wtfpl/COPYING for more details.

*****************************************************************************/



/*\\\ FICHIERS INCLUDE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	<stdio.h>
#include	<math.h>
#include	<time.h>

#include	"env.h"
#include	"base.h"
#include	"Envelope.h"
#include	"Graphic.h"
#include	"gtracker.h"
#include	"ICWindow.h"
#include	"inst.h"
#include	"intrface.h"
#include	"PatEdMenuEnvelopes.h"
#include	"PatEdMenuEnvWin.h"
#include	"resource.h"



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ CONSTANTES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

const PatEdMenuEnvWin_VIEW_CONF	PatEdMenuEnvWin::INIT_VIEW [Envelope_NBR_TYPES] =
{
	{ 0, 0x1000 },
	{ -1200, 2400 },
	{ -0x80, 0x100 },
	{ -1200, 2400 },
	{ -1200, 3200 }
};



/*\\\ TYPES & STRUCTURES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ DEFINITION DES VARIABLES DE CLASSE PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\*/

int	PatEdMenuEnvWin::line_color = Graphic::COL_BLUE_STD;
int	PatEdMenuEnvWin::point_color = Graphic::COL_WHITE;
int	PatEdMenuEnvWin::loop_color [Envelope_NBR_LOOPS] =
{
	Graphic::COL_RED_GRAD + 5,
	Graphic::COL_GREEN_GRAD + 5
};
PatEdMenuEnvWin_ENV_VIEW	PatEdMenuEnvWin::env_view [1+INST_NBRINSTR_MAXI] [Envelope_NBR_TYPES];



/*\\\ DEFINITION DES VARIABLES DE CLASSE PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ METHODES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



PatEdMenuEnvWin::PatEdMenuEnvWin (int master_object, int h_offset, int window, int center,
          signed int h_gadgets, signed int v_gadgets,
          signed int h_sbar, signed int h_slider,
          signed int v_sbar, signed int v_slider,
          signed int arrow_left, signed int arrow_right,
          signed int arrow_up, signed int arrow_down,
          signed int h_zoom_in, signed int h_zoom_out,
          signed int v_zoom_in, signed int v_zoom_out,
          long h_length, long v_length, long h_pos, long v_pos,
          double h_zoom, double v_zoom)
: ICWindow (master_object, h_offset, window, center, h_gadgets, v_gadgets,
            h_sbar, h_slider, v_sbar, v_slider,
            arrow_left, arrow_right, arrow_up, arrow_down,
            h_zoom_in, h_zoom_out, v_zoom_in, v_zoom_out,
            h_length, v_length, h_pos, v_pos, h_zoom, v_zoom)
{
	int		env;
	int		env_type;
	const PatEdMenuEnvWin_ENV_VIEW	init_view =
	{
		-1, 0, 1, 1	// -1 en h_pos signale que la vue n'est pas encore initialisee.
	};

	_old_locked_point = -1;
	_last_click_time = 0;
	RSC_set_string (RSC_OBJ_MP_SUBM_ENV_CUR_INFO_X_VAL, "");
	RSC_set_string (RSC_OBJ_MP_SUBM_ENV_CUR_INFO_Y_VAL, "");

	for (env = 1; env <= INST_NBRINSTR_MAXI; env ++)
	{
		for (env_type = 0; env_type < Envelope_NBR_TYPES; env_type ++)
		{
			PatEdMenuEnvWin::env_view [env] [env_type] = init_view;
		}
	}
}



/*==========================================================================*/
/*      Nom: redraw                                                         */
/*      Description: Affiche la composante d'interface.                     */
/*==========================================================================*/

void	PatEdMenuEnvWin::redraw (void)
{
	ICWindow::redraw ();

	refresh ();
}



/*==========================================================================*/
/*      Nom: refresh                                                        */
/*      Description: Rafraichit l'affichage des donnees.                    */
/*==========================================================================*/

void	PatEdMenuEnvWin::refresh (void)
{
	int		nbr_points;
	int		point_cnt;
	int		pos_x;
	int		pos_y;
	int		old_pos_x;
	int		old_pos_y;
	int		loop_type;
	LWORD		mask;
	int		color;
	int		flags;
	Envelope_POINT	point;
	Envelope_LOOP	loop [Envelope_NBR_LOOPS];

	for (loop_type = 0; loop_type < Envelope_NBR_LOOPS; loop_type ++)
	{
		loop [loop_type] = ENV_get_loop (PatEdMenuEnvelopes::cur_env_type, GTK_instr_nbr, loop_type);
	}
	flags = ENV_get_flags (PatEdMenuEnvelopes::cur_env_type, GTK_instr_nbr);

	/* Mets a jour les donnees pour la fenetre */
	set_h_length (ENV_get_length_in_ticks (PatEdMenuEnvelopes::cur_env_type, GTK_instr_nbr) + 100);
	set_v_length (  (long)Envelope::CONFIG [PatEdMenuEnvelopes::cur_env_type].max_val
	              - Envelope::CONFIG [PatEdMenuEnvelopes::cur_env_type].min_val + 1);
	set_inversion_flag (Envelope::CONFIG [PatEdMenuEnvelopes::cur_env_type].inverted_flag);
	ICWindow::refresh ();

	/* Efface ce qu'il y avait avant */
	RSC_display_object (_window);

	nbr_points = ENV_get_nbr_points (PatEdMenuEnvelopes::cur_env_type, GTK_instr_nbr);

	/* Trace les lignes de l'enveloppe */
	for (point_cnt = 0; point_cnt < nbr_points; point_cnt ++)
	{
		point = ENV_get_point (PatEdMenuEnvelopes::cur_env_type, GTK_instr_nbr, point_cnt);
		pos_x = (int) floor ((ENV_get_length_in_ticks (PatEdMenuEnvelopes::cur_env_type, GTK_instr_nbr, point_cnt) - get_h_pos ()) * get_h_zoom ());
		pos_y = (int) floor (((long)point.val - Envelope::CONFIG [PatEdMenuEnvelopes::cur_env_type].min_val - get_v_pos ()) * get_v_zoom ());
		if (Envelope::CONFIG [PatEdMenuEnvelopes::cur_env_type].inverted_flag)
		{
			pos_y = RSC_get_height (_window) - 1 - pos_y;
		}

		if (point_cnt == 0)
		{
			old_pos_x = pos_x;
			old_pos_y = pos_y;
		}

		mask = 0x0F0F0F0F;
		for (loop_type = 0; loop_type < Envelope_NBR_LOOPS; loop_type ++)
		{
			color = line_color;
			if (flags & (Envelope_FLAG_ENV_LOOP << loop_type))
			{
				if (   point_cnt == loop [loop_type].start
				    || point_cnt == loop [loop_type].end)
				{
					RSC_display_line (_window,
					                  pos_x, 0, pos_x, RSC_get_height (_window) - 1,
					                  loop_color [loop_type], mask);
				}

				if (   point_cnt > loop [loop_type].start
				    && point_cnt <= loop [loop_type].end)
				{
					color = loop_color [loop_type];
				}
			}
			RSC_display_line (_window, old_pos_x, old_pos_y, pos_x, pos_y, color, mask);

			mask <<= 4;
		}

		old_pos_x = pos_x;
		old_pos_y = pos_y;
	}

	/* Trace les points */
	for (point_cnt = 0; point_cnt < nbr_points; point_cnt ++)
	{
		point = ENV_get_point (PatEdMenuEnvelopes::cur_env_type, GTK_instr_nbr, point_cnt);
		pos_x = (int) floor ((ENV_get_length_in_ticks (PatEdMenuEnvelopes::cur_env_type, GTK_instr_nbr, point_cnt) - get_h_pos ()) * get_h_zoom ());
		pos_y = (int) floor (((long)point.val - Envelope::CONFIG [PatEdMenuEnvelopes::cur_env_type].min_val - get_v_pos ()) * get_v_zoom ());
		if (Envelope::CONFIG [PatEdMenuEnvelopes::cur_env_type].inverted_flag)
		{
			pos_y = RSC_get_height (_window) - 1 - pos_y;
		}

		RSC_display_line (_window, pos_x-2, pos_y-2, pos_x+2, pos_y-2, point_color);
		RSC_display_line (_window, pos_x+2, pos_y-2, pos_x+2, pos_y+2, point_color);
		RSC_display_line (_window, pos_x+2, pos_y+2, pos_x-2, pos_y+2, point_color);
		RSC_display_line (_window, pos_x-2, pos_y+2, pos_x-2, pos_y-2, point_color);
	}

	refresh_dynamic (true);
}



/*==========================================================================*/
/*      Nom: refresh_dynamic                                                */
/*      Description: Rafraichit l'affichage des donnees dynamiques.         */
/*        - force_flag: true indique qu'on doit forcer le rafraichissement. */
/*==========================================================================*/

void	PatEdMenuEnvWin::refresh_dynamic (bool force_flag)
{
	ICWindow::refresh_dynamic (force_flag);
}



/*==========================================================================*/
/*      Nom: manage                                                         */
/*      Description: Gere la composante d'interface                         */
/*      Parametres en entree:                                               */
/*        - sel_object: objet detecte par le gestionnaire d'interface       */
/*        - sel_elder: aine de sel_object                                   */
/*==========================================================================*/

void	PatEdMenuEnvWin::manage (int sel_object, int sel_elder)
{
	ICWindow::manage (sel_object, sel_elder);
}



void	PatEdMenuEnvWin::set_h_pos (long pos)
{
	ICWindow::set_h_pos (pos);

	PatEdMenuEnvWin::env_view [GTK_instr_nbr] [PatEdMenuEnvelopes::cur_env_type].h_pos = pos;
}



void	PatEdMenuEnvWin::set_v_pos (long pos)
{
	ICWindow::set_v_pos (pos);

	PatEdMenuEnvWin::env_view [GTK_instr_nbr] [PatEdMenuEnvelopes::cur_env_type].v_pos = pos;
}



void	PatEdMenuEnvWin::set_h_zoom (double zoom)
{
	ICWindow::set_h_zoom (zoom);

	PatEdMenuEnvWin::env_view [GTK_instr_nbr] [PatEdMenuEnvelopes::cur_env_type].h_zoom = zoom;
}



void	PatEdMenuEnvWin::set_v_zoom (double zoom)
{
	ICWindow::set_v_zoom (zoom);

	PatEdMenuEnvWin::env_view [GTK_instr_nbr] [PatEdMenuEnvelopes::cur_env_type].v_zoom = zoom;
}



void	PatEdMenuEnvWin::manage_main_window (int sel_object, int sel_elder)
{
	long		point_x;
	long		point_y;
	int		dec;
	int		point_cnt;
	int		nbr_points;
	int		pos_x;
	int		pos_y;
	int		rel_mx;
	int		rel_my;
	int		locked_point;
	int		point_time;
	int		cur_time;
	int		loop_type;
	int		pred_point;
	char		nbr6_0 [6+1];
	Envelope_POINT	point;
	Envelope_LOOP	loop;
	bool		nbr_points_changed;

	static long		old_point_x = -1;
	static long		old_point_y = -1;

	/* Gestion par defaut */
	ICWindow::manage_main_window (sel_object, sel_elder);

	/* Recuperation des coordonnees reeles et clipees pointees par la souris */
	get_mouse_point (point_x, point_y, INTR_mouse.x, INTR_mouse.y);
	point_x = MAX (point_x, 0);
	point_y += Envelope::CONFIG [PatEdMenuEnvelopes::cur_env_type].min_val;
	point_y = MIN (point_y, Envelope::CONFIG [PatEdMenuEnvelopes::cur_env_type].max_val);
	point_y = MAX (point_y, Envelope::CONFIG [PatEdMenuEnvelopes::cur_env_type].min_val);

	/* Affichage des coordonnees du curseur */
	if (point_x != old_point_x)
	{
		sprintf (nbr6_0, "%6d", point_x);
		RSC_set_string (RSC_OBJ_MP_SUBM_ENV_CUR_INFO_X_VAL, nbr6_0);
		RSC_display_object (RSC_OBJ_MP_SUBM_ENV_CUR_INFO_X_VAL);
	}

	if (point_y != old_point_y)
	{
		if (Envelope::CONFIG [PatEdMenuEnvelopes::cur_env_type].hexa_flag)
		{
			if (point_y < 0)
			{
				sprintf (nbr6_0, "-%5X", -point_y);
			}
			else
			{
				sprintf (nbr6_0, "%6X", point_y);
			}
		}
		else
		{
			dec = Envelope::CONFIG [PatEdMenuEnvelopes::cur_env_type].fixed_point;
			if (dec > 0)
			{
				BASE_double_to_fix (nbr6_0, point_y / pow (10.0, dec), 5 - dec, dec);
			}
			else
			{
				sprintf (nbr6_0, "%6d", point_y);
			}
		}
		RSC_set_string (RSC_OBJ_MP_SUBM_ENV_CUR_INFO_Y_VAL, nbr6_0);
		RSC_display_object (RSC_OBJ_MP_SUBM_ENV_CUR_INFO_Y_VAL);
	}

	/* Regarde si on a souleve le bouton depuis le dernier appel */
	if (INTR_mouse.last_released > _last_click_time)
	{
		_old_locked_point = -1;
		old_point_y = -1;
		old_point_x = -1;
	}

	/* Si on n'a pas change la souris de position, pas la peine de rester */
	if (   old_point_y == point_y
	    && old_point_x == point_x)
	{
		return;
	}

	old_point_y = point_y;
	old_point_x = point_x;

	/* Si on n'a pas appuye sur le bouton, c'est plus la peine de rester */
	if (RSC_mouse_key == 0)
	{
		_last_click_time = 0;
		_old_locked_point = -1;
		return;
	}

	_last_click_time = INTR_mouse.last_pressed;

	rel_mx = INTR_mouse.x - RSC_absolute_object_pixxpos [_window];
	rel_my = INTR_mouse.y - RSC_absolute_object_pixypos [_window];
	nbr_points = ENV_get_nbr_points (PatEdMenuEnvelopes::cur_env_type, GTK_instr_nbr);

	/* On accroche un point ? */
	pred_point = -1;
	locked_point = -1;
	if (_old_locked_point >= 0)
	{
		locked_point = _old_locked_point;
	}
	for (point_cnt = 0; point_cnt < nbr_points; point_cnt ++)
	{
		point = ENV_get_point (PatEdMenuEnvelopes::cur_env_type, GTK_instr_nbr, point_cnt);
		pos_x = (int) floor ((ENV_get_length_in_ticks (PatEdMenuEnvelopes::cur_env_type, GTK_instr_nbr, point_cnt) - get_h_pos ()) * get_h_zoom ());
		pos_y = (int) floor (((long)point.val - Envelope::CONFIG [PatEdMenuEnvelopes::cur_env_type].min_val - get_v_pos ()) * get_v_zoom ());
		if (Envelope::CONFIG [PatEdMenuEnvelopes::cur_env_type].inverted_flag)
		{
			pos_y = RSC_get_height (_window) - 1 - pos_y;
		}

		if (pred_point < 0)
		{
			if (point_x < ENV_get_length_in_ticks (PatEdMenuEnvelopes::cur_env_type, GTK_instr_nbr, point_cnt))
			{
				pred_point = point_cnt - 1;
			}
		}

		/* Si le point est hors de la fenetre
			(horizontalement), on laisse tomber. */
		if (pos_x < 0 || pos_x >= RSC_get_width (_window))
		{
			continue;
		}

		/* On est suffisamment pres */
		if (   ABS (rel_mx - pos_x) < 3
			 && ABS (rel_my - pos_y) < 3
			 && _old_locked_point < 0)
		{
			locked_point = point_cnt;
		}
	}
	if (pred_point < 0 && nbr_points > 0)
	{
		pred_point = nbr_points - 1;
	}

	nbr_points_changed = false;

	/* Clic droit: effacement du point accroche */
	if (   locked_point >= 0 && (RSC_mouse_key & 2) != 0
	    && (nbr_points == 1 || locked_point > 0))	// Impossible d'effacer le premier point sauf si c'est le dernier
	{
		INTR_stop_song ();

		/* Dernier point: on kill carrement l'enveloppe */
		if (nbr_points == 1)
		{
			ENV_kill_envelope (PatEdMenuEnvelopes::cur_env_type, GTK_instr_nbr);
			nbr_points_changed = true;
		}

		else
		{
			/* Met a jour les boucles */
			for (loop_type = 0; loop_type < Envelope_NBR_LOOPS; loop_type ++)
			{
				loop = ENV_get_loop (PatEdMenuEnvelopes::cur_env_type, GTK_instr_nbr, loop_type);
				if (loop.start >= locked_point)
				{
					loop.start --;
				}
				if (loop.end >= locked_point)
				{
					loop.end --;
				}
				ENV_set_loop (PatEdMenuEnvelopes::cur_env_type, GTK_instr_nbr, loop_type, loop);
			}

			/* Rallonge la duree du point d'avant pour compenser */
			point = ENV_get_point (PatEdMenuEnvelopes::cur_env_type, GTK_instr_nbr, locked_point);
			point_time = point.time;
			point = ENV_get_point (PatEdMenuEnvelopes::cur_env_type, GTK_instr_nbr, locked_point - 1);
			point.time += point_time;
			ENV_set_point (PatEdMenuEnvelopes::cur_env_type, GTK_instr_nbr, locked_point - 1, point);

			/* Vire le point de la liste */
			for (point_cnt = locked_point + 1; point_cnt < nbr_points; point_cnt ++)
			{
				point = ENV_get_point (PatEdMenuEnvelopes::cur_env_type, GTK_instr_nbr, point_cnt);
				ENV_set_point (PatEdMenuEnvelopes::cur_env_type, GTK_instr_nbr, point_cnt - 1, point);
			}

			/* Change la taille de la liste */
			nbr_points --;
			ENV_set_nbr_points (PatEdMenuEnvelopes::cur_env_type, GTK_instr_nbr, nbr_points);

			nbr_points_changed = true;
			GTK_modified_flag = true;
		}
		_old_locked_point = -1;
		INTR_wait_mouse (true);
		_father_object_ptr->refresh ();

		return;
	}

	/* Point pas encore accroche: on en cree un s'il y a la place */
	if (locked_point < 0)
	{
		if (nbr_points < Envelope_MAX_NBR_POINTS)
		{
			INTR_stop_song ();

			if (pred_point < 0)
			{
				nbr_points ++;
				ENV_set_nbr_points (PatEdMenuEnvelopes::cur_env_type, GTK_instr_nbr, nbr_points);
				point.time = 1;
				point.val = Envelope::CONFIG [PatEdMenuEnvelopes::cur_env_type].std_val;
				ENV_set_point (PatEdMenuEnvelopes::cur_env_type, GTK_instr_nbr, 0, point);

				locked_point = pred_point + 1;
				nbr_points_changed = true;
				GTK_modified_flag = true;
			}
			else
			{
				point = ENV_get_point (PatEdMenuEnvelopes::cur_env_type, GTK_instr_nbr, pred_point);
				point_time = point.time;
				if (point_time > 1 || pred_point == nbr_points - 1)
				{
					/* Change la taille de la liste */
					nbr_points ++;
					ENV_set_nbr_points (PatEdMenuEnvelopes::cur_env_type, GTK_instr_nbr, nbr_points);

					/* Insere un point de la liste */
					for (point_cnt = nbr_points - 2; point_cnt >= pred_point + 1; point_cnt --)
					{
						point = ENV_get_point (PatEdMenuEnvelopes::cur_env_type, GTK_instr_nbr, point_cnt);
						ENV_set_point (PatEdMenuEnvelopes::cur_env_type, GTK_instr_nbr, point_cnt + 1, point);
					}
					point = ENV_get_point (PatEdMenuEnvelopes::cur_env_type, GTK_instr_nbr, pred_point);
					point.time = 1;
					ENV_set_point (PatEdMenuEnvelopes::cur_env_type, GTK_instr_nbr, pred_point, point);
					if (pred_point + 1 < nbr_points - 1)
					{
						point = ENV_get_point (PatEdMenuEnvelopes::cur_env_type, GTK_instr_nbr, pred_point + 1);
						point.time = point_time - 1;
					}
					else
					{
						point.time = 1;
						point.val = Envelope::CONFIG [PatEdMenuEnvelopes::cur_env_type].std_val;
					}
					ENV_set_point (PatEdMenuEnvelopes::cur_env_type, GTK_instr_nbr, pred_point + 1, point);

					/* Met a jour les boucles */
					for (loop_type = 0; loop_type < Envelope_NBR_LOOPS; loop_type ++)
					{
						loop = ENV_get_loop (PatEdMenuEnvelopes::cur_env_type, GTK_instr_nbr, loop_type);
						if (loop.start > pred_point)
						{
							loop.start ++;
						}
						if (loop.end > pred_point)
						{
							loop.end ++;
						}
						ENV_set_loop (PatEdMenuEnvelopes::cur_env_type, GTK_instr_nbr, loop_type, loop);
					}

					locked_point = pred_point + 1;
					nbr_points_changed = true;
					GTK_modified_flag = true;
				}
			}
		}

		else
		{
			_old_locked_point = -1;
			_last_click_time = 0;
			return;
		}
	}

	/* Deplacement du point (ordonnee) */
	point = ENV_get_point (PatEdMenuEnvelopes::cur_env_type, GTK_instr_nbr, locked_point);
	point.val = (SWORD) point_y;
	ENV_set_point (PatEdMenuEnvelopes::cur_env_type, GTK_instr_nbr, locked_point, point);
	GTK_modified_flag = true;

	/* Deplacement du point (abscisse) */
	if (locked_point > 0)
	{
		point_time = point.time;
		point = ENV_get_point (PatEdMenuEnvelopes::cur_env_type, GTK_instr_nbr, locked_point - 1);
		point_time += point.time;
		cur_time = point_x - ENV_get_length_in_ticks (PatEdMenuEnvelopes::cur_env_type, GTK_instr_nbr, locked_point - 1);
		if (locked_point < nbr_points - 1)
		{
			cur_time = MIN (cur_time, point_time - 1);
		}
		cur_time = MAX (cur_time, 1);
		point.time = cur_time;
		ENV_set_point (PatEdMenuEnvelopes::cur_env_type, GTK_instr_nbr, locked_point - 1, point);
		point = ENV_get_point (PatEdMenuEnvelopes::cur_env_type, GTK_instr_nbr, locked_point);
		point.time = point_time - cur_time;
		ENV_set_point (PatEdMenuEnvelopes::cur_env_type, GTK_instr_nbr, locked_point, point);
		GTK_modified_flag = true;
	}

	_old_locked_point = locked_point;

	if (/*nbr_points_changed*/ true)	/*** Pour contrer le bug sous win95/98 ***/
	{
		_father_object_ptr->refresh ();
	}
	else
	{
		refresh ();
	}
}



void	PatEdMenuEnvWin::reset_view (void)
{
	double	zoom;

	set_h_length (ENV_get_length_in_ticks (PatEdMenuEnvelopes::cur_env_type, GTK_instr_nbr) + 100);
	set_v_length (  Envelope::CONFIG [PatEdMenuEnvelopes::cur_env_type].max_val
	              - Envelope::CONFIG [PatEdMenuEnvelopes::cur_env_type].min_val + 1);
	set_h_zoom (1);
	zoom =   (double)RSC_get_height (_window)
	       / INIT_VIEW [PatEdMenuEnvelopes::cur_env_type].size;
	set_v_zoom (zoom);
	set_h_pos (0);
	set_v_pos (  INIT_VIEW [PatEdMenuEnvelopes::cur_env_type].pos
              - Envelope::CONFIG [PatEdMenuEnvelopes::cur_env_type].min_val);
	_old_locked_point = -1;

	RSC_set_string (RSC_OBJ_MP_SUBM_ENV_CUR_INFO_X_VAL, "");
	RSC_set_string (RSC_OBJ_MP_SUBM_ENV_CUR_INFO_Y_VAL, "");
}



void	PatEdMenuEnvWin::restore_view (void)
{
	if (PatEdMenuEnvWin::env_view [GTK_instr_nbr] [PatEdMenuEnvelopes::cur_env_type].h_pos < 0)
	{
		reset_view ();
	}

	else
	{
		set_h_zoom (PatEdMenuEnvWin::env_view [GTK_instr_nbr] [PatEdMenuEnvelopes::cur_env_type].h_zoom);
		set_v_zoom (PatEdMenuEnvWin::env_view [GTK_instr_nbr] [PatEdMenuEnvelopes::cur_env_type].v_zoom);
		set_h_pos (PatEdMenuEnvWin::env_view [GTK_instr_nbr] [PatEdMenuEnvelopes::cur_env_type].h_pos);
		set_v_pos (PatEdMenuEnvWin::env_view [GTK_instr_nbr] [PatEdMenuEnvelopes::cur_env_type].v_pos);
	}
}



/*\\\ METHODES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/****************************************************************************/
/*                                                                          */
/*                                                                          */
/*                                                                          */
/****************************************************************************/



/*==========================================================================*/
/*      Nom:                                                                */
/*      Description:                                                        */
/*      Parametres en entree:                                               */
/*      Parametres en sortie:                                               */
/*      Parametres en entree/sortie:                                        */
/*      Retour:                                                             */
/*==========================================================================*/
