/*****************************************************************************

        GRAOUMF TRACKER 2
        Author: Laurent de Soras, 1996-2016

--- Legal stuff ---

This program is free software. It comes without any warranty, to
the extent permitted by applicable law. You can redistribute it
and/or modify it under the terms of the Do What The Fuck You Want
To Public License, Version 2, as published by Sam Hocevar. See
http://sam.zoy.org/wtfpl/COPYING for more details.

*****************************************************************************/



/*\\\ FICHIERS INCLUDE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	<stdio.h>
#include	<stdlib.h>
#include	<math.h>

#include	"base.h"
#include	"base_ct.h"
#include	"EditString.h"
#include	"edstring.h"
#include	"env.h"
#include	"gtracker.h"
#include	"intrface.h"
#include	"log.h"
#include	"PatEdMenuEnvelopes.h"
#include	"PatEdMenuEnvMisc.h"
#include	"Popup.h"
#include	"resource.h"
#include	"rsc01.h"
#include	"WaveForm.h"



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ CONSTANTES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ TYPES & STRUCTURES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ DEFINITION DES VARIABLES DE CLASSE PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ DEFINITION DES VARIABLES DE CLASSE PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ METHODES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*==========================================================================*/
/*      Nom: check_ok                                                       */
/*      Description: Verifie l'intergrite de l'objet.                       */
/*      Retour: 0 si l'objet parait correct.                                */
/*==========================================================================*/

signed int	PatEdMenuEnvMisc::check_ok (void) const
{
	if (this == NULL)
	{
		LOG_printf ("PatEdMenuEnvMisc::check_ok: Error: \"this\" pointer is NULL.\n");
		return (-1);
	}

	/*** A faire ***/

	return (0);
}



/*==========================================================================*/
/*      Nom: self_display                                                   */
/*      Description: Affiche "textuellement" le contenu courant de l'objet. */
/*==========================================================================*/

void	PatEdMenuEnvMisc::self_display (void) const
{

	/*** A faire ***/

}



/*==========================================================================*/
/*      Nom: redraw                                                         */
/*      Description: Affiche la composante d'interface.                     */
/*==========================================================================*/

void	PatEdMenuEnvMisc::redraw (void)
{
	RSC_display_object (RSC_OBJ_MP_SUBM_ENV_MISC);

	refresh ();
}



/*==========================================================================*/
/*      Nom: refresh                                                        */
/*      Description: Rafraichit l'affichage des donnees.                    */
/*==========================================================================*/

void	PatEdMenuEnvMisc::refresh (void)
{
	int		flags;
	char		nbr5_0 [5+1];
	long		depth;
	int		dec;

	flags = ENV_get_flags (PatEdMenuEnvelopes::cur_env_type, GTK_instr_nbr);

	/* Fadeout On/Off */
	RSC_select_object_display (RSC_OBJ_MP_SUBM_ENV_MISC_FOUT_ACTIVE_CB, (flags & Envelope_FLAG_FADEOUT) != 0);

	/* Fadeout */
	sprintf (nbr5_0, INTR_base_song_5, (int) ENV_get_fadeout (PatEdMenuEnvelopes::cur_env_type, GTK_instr_nbr));
	RSC_set_string (RSC_OBJ_MP_SUBM_ENV_MISC_FOUT_BOX_VAL, nbr5_0);
	RSC_display_object (RSC_OBJ_MP_SUBM_ENV_MISC_FOUT_BOX_VAL);

	/* LFO On/Off */
	RSC_select_object_display (RSC_OBJ_MP_SUBM_ENV_MISC_ACTIVE_CB, (flags & Envelope_FLAG_LFO) != 0);

	/* LFO speed */
	sprintf (nbr5_0, "%5X", (int) ENV_get_lfo_speed (PatEdMenuEnvelopes::cur_env_type, GTK_instr_nbr));
	RSC_set_string (RSC_OBJ_MP_SUBM_ENV_MISC_LFOSP_BOX_VAL, nbr5_0);
	RSC_display_object (RSC_OBJ_MP_SUBM_ENV_MISC_LFOSP_BOX_VAL);

	/* LFO depth */
	if (Envelope::CONFIG [PatEdMenuEnvelopes::cur_env_type].hexa_flag)
	{
		sprintf (nbr5_0, "%5X", (int) ENV_get_lfo_depth (PatEdMenuEnvelopes::cur_env_type, GTK_instr_nbr));
	}
	else
	{
		dec = Envelope::CONFIG [PatEdMenuEnvelopes::cur_env_type].fixed_point;
		depth = ENV_get_lfo_depth (PatEdMenuEnvelopes::cur_env_type, GTK_instr_nbr);
		if (dec > 0)
		{
			BASE_double_to_fix (nbr5_0, depth / pow (10.0, dec), 4 - dec, dec);
		}
		else
		{
			sprintf (nbr5_0, "%5d", (int)depth);
		}
	}
	RSC_set_string (RSC_OBJ_MP_SUBM_ENV_MISC_LFODE_BOX_VAL, nbr5_0);
	RSC_display_object (RSC_OBJ_MP_SUBM_ENV_MISC_LFODE_BOX_VAL);

	/* LFO sweep */
	sprintf (nbr5_0, "%5d", (int) ENV_get_lfo_sweep (PatEdMenuEnvelopes::cur_env_type, GTK_instr_nbr));
	RSC_set_string (RSC_OBJ_MP_SUBM_ENV_MISC_LFOSW_BOX_VAL, nbr5_0);
	RSC_display_object (RSC_OBJ_MP_SUBM_ENV_MISC_LFOSW_BOX_VAL);

	/* LFO waveform */
	RSC_set_string (RSC_OBJ_MP_SUBM_ENV_MISC_LFOWF_BOX_VAL,
	                WaveForm::name_0_ptr [ENV_get_lfo_waveform (PatEdMenuEnvelopes::cur_env_type, GTK_instr_nbr)]);
	RSC_display_object (RSC_OBJ_MP_SUBM_ENV_MISC_LFOWF_BOX_VAL);

	refresh_dynamic (true);
}



/*==========================================================================*/
/*      Nom: refresh_dynamic                                                */
/*      Description: Rafraichit l'affichage des donnees dynamiques.         */
/*        - force_flag: true indique qu'on doit forcer le rafraichissement. */
/*==========================================================================*/

void	PatEdMenuEnvMisc::refresh_dynamic (bool force_flag)
{
	/* Rien */
}



/*==========================================================================*/
/*      Nom: manage                                                         */
/*      Description: Gere la composante d'interface                         */
/*      Parametres en entree:                                               */
/*        - sel_object: objet detecte par le gestionnaire d'interface       */
/*        - sel_elder: aine de sel_object                                   */
/*==========================================================================*/

void	PatEdMenuEnvMisc::manage (int sel_object, int sel_elder)
{
	int		flags;

	flags = ENV_get_flags (PatEdMenuEnvelopes::cur_env_type, GTK_instr_nbr);

	switch (sel_object)
	{

	/* Fadeout On/Off */
	case	RSC_OBJ_MP_SUBM_ENV_MISC_FOUT_ACTIVE_CB:
		flags ^= Envelope_FLAG_FADEOUT;
		ENV_set_flags (PatEdMenuEnvelopes::cur_env_type, GTK_instr_nbr, flags);
		GTK_modified_flag = true;
		refresh ();
		break;

	/* Fadeout */
	case	RSC_OBJ_MP_SUBM_ENV_MISC_FOUT_BOX:
		if (RSC_mouse_key & 2)
		{
			set_fadeout_intr (INTR_CHGTYPE_POP, 0);
		}
		else
		{
			set_fadeout_intr (INTR_CHGTYPE_KBD, 0);
		}
		break;

	case	RSC_OBJ_MP_SUBM_ENV_MISC_FOUT_U:
		set_fadeout_intr (INTR_CHGTYPE_REL, INTR_inc_speed [1] [RSC_mouse_key]);
		break;

	case	RSC_OBJ_MP_SUBM_ENV_MISC_FOUT_D:
		set_fadeout_intr (INTR_CHGTYPE_REL, -INTR_inc_speed [1] [RSC_mouse_key]);
		break;

	/* LFO On/Off */
	case	RSC_OBJ_MP_SUBM_ENV_MISC_ACTIVE_CB:
		flags ^= Envelope_FLAG_LFO;
		ENV_set_flags (PatEdMenuEnvelopes::cur_env_type, GTK_instr_nbr, flags);
		GTK_modified_flag = true;
		refresh ();
		break;

	/* LFO depth */
	case	RSC_OBJ_MP_SUBM_ENV_MISC_LFODE_BOX:
		if (RSC_mouse_key & 2)
		{
			set_lfo_depth_intr (INTR_CHGTYPE_POP, 0);
		}
		else
		{
			set_lfo_depth_intr (INTR_CHGTYPE_KBD, 0);
		}
		break;

	case	RSC_OBJ_MP_SUBM_ENV_MISC_LFODE_U:
		set_lfo_depth_intr (INTR_CHGTYPE_REL, INTR_inc_speed [1] [RSC_mouse_key]);
		break;

	case	RSC_OBJ_MP_SUBM_ENV_MISC_LFODE_D:
		set_lfo_depth_intr (INTR_CHGTYPE_REL, -INTR_inc_speed [1] [RSC_mouse_key]);
		break;

	/* LFO speed */
	case	RSC_OBJ_MP_SUBM_ENV_MISC_LFOSP_BOX:
		if (RSC_mouse_key & 2)
		{
			set_lfo_speed_intr (INTR_CHGTYPE_POP, 0);
		}
		else
		{
			set_lfo_speed_intr (INTR_CHGTYPE_KBD, 0);
		}
		break;

	case	RSC_OBJ_MP_SUBM_ENV_MISC_LFOSP_U:
		set_lfo_speed_intr (INTR_CHGTYPE_REL, INTR_inc_speed [1] [RSC_mouse_key]);
		break;

	case	RSC_OBJ_MP_SUBM_ENV_MISC_LFOSP_D:
		set_lfo_speed_intr (INTR_CHGTYPE_REL, -INTR_inc_speed [1] [RSC_mouse_key]);
		break;

	/* LFO sweep */
	case	RSC_OBJ_MP_SUBM_ENV_MISC_LFOSW_BOX:
		if (RSC_mouse_key & 2)
		{
			set_lfo_sweep_intr (INTR_CHGTYPE_POP, 0);
		}
		else
		{
			set_lfo_sweep_intr (INTR_CHGTYPE_KBD, 0);
		}
		break;

	case	RSC_OBJ_MP_SUBM_ENV_MISC_LFOSW_U:
		set_lfo_sweep_intr (INTR_CHGTYPE_REL, INTR_inc_speed [0] [RSC_mouse_key]);
		break;

	case	RSC_OBJ_MP_SUBM_ENV_MISC_LFOSW_D:
		set_lfo_sweep_intr (INTR_CHGTYPE_REL, -INTR_inc_speed [0] [RSC_mouse_key]);
		break;

	/* LFO waveform */
	case	RSC_OBJ_MP_SUBM_ENV_MISC_LFOWF_BOX:
		if (RSC_mouse_key & 2)
		{
			set_lfo_waveform_intr (INTR_CHGTYPE_POP, 0);
		}
		else
		{
			set_lfo_waveform_intr (INTR_CHGTYPE_KBD, 0);
		}
		break;

	case	RSC_OBJ_MP_SUBM_ENV_MISC_LFOWF_U:
		set_lfo_waveform_intr (INTR_CHGTYPE_REL, INTR_inc_speed [0] [RSC_mouse_key]);
		break;

	case	RSC_OBJ_MP_SUBM_ENV_MISC_LFOWF_D:
		set_lfo_waveform_intr (INTR_CHGTYPE_REL, -INTR_inc_speed [0] [RSC_mouse_key]);
		break;

	}
}



/*==========================================================================*/
/*      Nom: activate                                                       */
/*      Description: Active ou desactive le menu. Celui-ci n'est pas        */
/*                   reaffiche.                                             */
/*      Parametres en entree:                                               */
/*        - activated_flag: indique si le menu doit etre active ou          */
/*                          desactive.                                      */
/*==========================================================================*/

void	PatEdMenuEnvMisc::activate (bool activated_flag)
{
	RSC_pos_flag (RSC_OBJ_MP_SUBM_ENV_MISC, RSC_ATTR_NOTDISP, ! activated_flag);
	RSC_pos_flag (RSC_OBJ_MP_SUBM_ENV_PICN_MISC, RSC_ATTR_SELECTED, activated_flag);
}



/*==========================================================================*/
/*      Nom: set_fadeout_intr                                               */
/*      Description: Change la vitesse de fadeout de differentes manieres.  */
/*                   L'interface est ici mise en jeu.                       */
/*      Parametres en entree:                                               */
/*        - type: 0 = Le parametre est absolu,                              */
/*                1 = Le parametre est relatif,                             */
/*                2 = Entree au clavier,                                    */
/*                3 = Entree au pop-up.                                     */
/*        - value: le parametre en question.                                */
/*      Retour: 0 si tout s'est bien passe.                                 */
/*==========================================================================*/

signed int	PatEdMenuEnvMisc::set_fadeout_intr (int type, signed long value)
{
	long		new_value;
	signed int	line;
	signed long	code;
	char		nbr5_0 [5+1];
	Popup		popup_menu;

	new_value = ENV_get_fadeout (PatEdMenuEnvelopes::cur_env_type, GTK_instr_nbr);

	switch (type)
	{
	/* Position relative */
	case	INTR_CHGTYPE_REL:
		new_value += value;
		break;

	/* Entree au clavier */
	case	INTR_CHGTYPE_KBD:
		sprintf (nbr5_0, INTR_base_song_5, (int)new_value);
		EDIT_edit_string_base (nbr5_0, RSC_OBJ_MP_SUBM_ENV_MISC_FOUT_BOX_VAL, 5, INTR_base_song);
		new_value = strtol (nbr5_0, NULL, INTR_base_song);
		break;

	/* Position absolue  */
	case	INTR_CHGTYPE_ABS:
		new_value = value;
		break;

	/* Pop-up */
	case	INTR_CHGTYPE_POP:
		popup_menu.add_line ("0", 0);
		line = popup_menu.select_radio_by_code (new_value);
		code = popup_menu.manage (line);
		if (code >= 0)
		{
			new_value = code;
		}
		break;
	}

	new_value = MIN (new_value, Envelope_MAX_FADEOUT);
	new_value = MAX (new_value, 0);
	ENV_set_fadeout (PatEdMenuEnvelopes::cur_env_type, GTK_instr_nbr, (UWORD)new_value);
	GTK_modified_flag = true;
	refresh ();

	return (0);
}



/*==========================================================================*/
/*      Nom: set_lfo_depth_intr                                             */
/*      Description: Change l'amplitude du LFO de differentes manieres.     */
/*                   L'interface est ici mise en jeu.                       */
/*      Parametres en entree:                                               */
/*        - type: 0 = Le parametre est absolu,                              */
/*                1 = Le parametre est relatif,                             */
/*                2 = Entree au clavier,                                    */
/*                3 = Entree au pop-up.                                     */
/*        - value: le parametre en question.                                */
/*      Retour: 0 si tout s'est bien passe.                                 */
/*==========================================================================*/

signed int	PatEdMenuEnvMisc::set_lfo_depth_intr (int type, signed long value)
{
	long		new_value;
	signed int	line;
	signed long	code;
	char		nbr5_0 [5+1];
	Popup		popup_menu;
	int		base;
	int		dec;
	double	res;

	new_value = ENV_get_lfo_depth (PatEdMenuEnvelopes::cur_env_type, GTK_instr_nbr);

	switch (type)
	{
	/* Position relative */
	case	INTR_CHGTYPE_REL:
		new_value += value;
		break;

	/* Entree au clavier */
	case	INTR_CHGTYPE_KBD:
		if (Envelope::CONFIG [PatEdMenuEnvelopes::cur_env_type].hexa_flag)
		{
			sprintf (nbr5_0, "%5X", (int)new_value);
			base = 16;
		}
		else
		{
			dec = Envelope::CONFIG [PatEdMenuEnvelopes::cur_env_type].fixed_point;
			if (dec > 0)
			{
				BASE_double_to_fix (nbr5_0, new_value / pow (10.0, dec), 4 - dec, dec);
			}
			else
			{
				sprintf (nbr5_0, "%5d", (int)new_value);
			}
			base = 10;
		}
		EDIT_edit_string (nbr5_0, RSC_OBJ_MP_SUBM_ENV_MISC_LFODE_BOX_VAL, 5, EditString_TYPE_ALPHA);
		if (base == 10 && dec > 0)
		{
			sscanf (nbr5_0, "%lf", &res);
			new_value = (long) floor (res * pow (10.0, dec) + 0.5);
		}
		else
		{
			new_value = strtol (nbr5_0, NULL, base);
		}
		break;

	/* Position absolue  */
	case	INTR_CHGTYPE_ABS:
		new_value = value;
		break;

	/* Pop-up */
	case	INTR_CHGTYPE_POP:
		popup_menu.add_line ("0", 0);
		line = popup_menu.select_radio_by_code (new_value);
		code = popup_menu.manage (line);
		if (code >= 0)
		{
			new_value = code;
		}
		break;
	}

	new_value = MIN (new_value, Envelope_MAX_LFO_DEPTH);
	new_value = MAX (new_value, 0);
	ENV_set_lfo_depth (PatEdMenuEnvelopes::cur_env_type, GTK_instr_nbr, (UWORD)new_value);
	GTK_modified_flag = true;
	refresh ();

	return (0);
}



/*==========================================================================*/
/*      Nom: set_lfo_speed_intr                                             */
/*      Description: Change la vitesse du LFO de differentes manieres.      */
/*                   L'interface est ici mise en jeu.                       */
/*      Parametres en entree:                                               */
/*        - type: 0 = Le parametre est absolu,                              */
/*                1 = Le parametre est relatif,                             */
/*                2 = Entree au clavier,                                    */
/*                3 = Entree au pop-up.                                     */
/*        - value: le parametre en question.                                */
/*      Retour: 0 si tout s'est bien passe.                                 */
/*==========================================================================*/

signed int	PatEdMenuEnvMisc::set_lfo_speed_intr (int type, signed long value)
{
	long		new_value;
	signed int	line;
	signed long	code;
	char		nbr5_0 [5+1];
	Popup		popup_menu;

	new_value = ENV_get_lfo_speed (PatEdMenuEnvelopes::cur_env_type, GTK_instr_nbr);

	switch (type)
	{
	/* Position relative */
	case	INTR_CHGTYPE_REL:
		new_value += value;
		break;

	/* Entree au clavier */
	case	INTR_CHGTYPE_KBD:
		sprintf (nbr5_0, "%5X", (int)new_value);
		EDIT_edit_string_base (nbr5_0, RSC_OBJ_MP_SUBM_ENV_MISC_LFOSP_BOX_VAL, 5, 16);
		new_value = strtol (nbr5_0, NULL, 16);
		break;

	/* Position absolue  */
	case	INTR_CHGTYPE_ABS:
		new_value = value;
		break;

	/* Pop-up */
	case	INTR_CHGTYPE_POP:
		popup_menu.add_line ("0", 0);
		line = popup_menu.select_radio_by_code (new_value);
		code = popup_menu.manage (line);
		if (code >= 0)
		{
			new_value = code;
		}
		break;
	}

	new_value = MIN (new_value, Envelope_MAX_LFO_SPEED);
	new_value = MAX (new_value, 0);
	ENV_set_lfo_speed (PatEdMenuEnvelopes::cur_env_type, GTK_instr_nbr, (UWORD)new_value);
	GTK_modified_flag = true;
	refresh ();

	return (0);
}



/*==========================================================================*/
/*      Nom: set_lfo_sweep_intr                                             */
/*      Description: Change le balayage du LFO de differentes manieres.     */
/*                   L'interface est ici mise en jeu.                       */
/*      Parametres en entree:                                               */
/*        - type: 0 = Le parametre est absolu,                              */
/*                1 = Le parametre est relatif,                             */
/*                2 = Entree au clavier,                                    */
/*                3 = Entree au pop-up.                                     */
/*        - value: le parametre en question.                                */
/*      Retour: 0 si tout s'est bien passe.                                 */
/*==========================================================================*/

signed int	PatEdMenuEnvMisc::set_lfo_sweep_intr (int type, signed long value)
{
	long		new_value;
	signed int	line;
	signed long	code;
	char		nbr5_0 [5+1];
	Popup		popup_menu;

	new_value = ENV_get_lfo_sweep (PatEdMenuEnvelopes::cur_env_type, GTK_instr_nbr);

	switch (type)
	{
	/* Position relative */
	case	INTR_CHGTYPE_REL:
		new_value += value;
		break;

	/* Entree au clavier */
	case	INTR_CHGTYPE_KBD:
		sprintf (nbr5_0, "%5d", (int)new_value);
		EDIT_edit_string_base (nbr5_0, RSC_OBJ_MP_SUBM_ENV_MISC_LFOSW_BOX_VAL, 5, 10);
		new_value = strtol (nbr5_0, NULL, 10);
		break;

	/* Position absolue  */
	case	INTR_CHGTYPE_ABS:
		new_value = value;
		break;

	/* Pop-up */
	case	INTR_CHGTYPE_POP:
		popup_menu.add_line ("0", 0);
		line = popup_menu.select_radio_by_code (new_value);
		code = popup_menu.manage (line);
		if (code >= 0)
		{
			new_value = code;
		}
		break;
	}

	new_value = MIN (new_value, Envelope_MAX_LFO_SWEEP);
	new_value = MAX (new_value, 0);
	ENV_set_lfo_sweep (PatEdMenuEnvelopes::cur_env_type, GTK_instr_nbr, (UWORD)new_value);
	GTK_modified_flag = true;
	refresh ();

	return (0);
}



/*==========================================================================*/
/*      Nom: set_lfo_waveform_intr                                          */
/*      Description: Change la forme d'onde du LFO de differentes manieres. */
/*                   L'interface est ici mise en jeu.                       */
/*      Parametres en entree:                                               */
/*        - type: 0 = Le parametre est absolu,                              */
/*                1 = Le parametre est relatif,                             */
/*                2 = Entree au clavier,                                    */
/*                3 = Entree au pop-up.                                     */
/*        - value: le parametre en question.                                */
/*      Retour: 0 si tout s'est bien passe.                                 */
/*==========================================================================*/

signed int	PatEdMenuEnvMisc::set_lfo_waveform_intr (int type, signed long value)
{
	long		new_value;
	signed int	line;
	signed long	code;
	Popup		popup_menu;

	new_value = ENV_get_lfo_waveform (PatEdMenuEnvelopes::cur_env_type, GTK_instr_nbr);

	switch (type)
	{
	/* Position relative */
	case	INTR_CHGTYPE_REL:
		new_value += value;
		break;

	/* Entree au clavier */
	case	INTR_CHGTYPE_KBD:
		break;

	/* Position absolue  */
	case	INTR_CHGTYPE_ABS:
		new_value = value;
		break;

	/* Pop-up */
	case	INTR_CHGTYPE_POP:
		for (int cnt = 0; cnt < WaveForm_NBR_BASE_FORMS; cnt ++)
		{
			popup_menu.add_line (WaveForm::name_0_ptr [cnt], cnt);
		}
		line = popup_menu.select_radio_by_code (new_value);
		code = popup_menu.manage (line);
		if (code >= 0)
		{
			new_value = code;
		}
		break;
	}

	new_value = MIN (new_value, WaveForm_NBR_BASE_FORMS - 1);
	new_value = MAX (new_value, 0);
	ENV_set_lfo_waveform (PatEdMenuEnvelopes::cur_env_type, GTK_instr_nbr, (int)new_value);
	GTK_modified_flag = true;
	refresh ();

	return (0);
}



/*\\\ METHODES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/****************************************************************************/
/*                                                                          */
/*                                                                          */
/*                                                                          */
/****************************************************************************/



/*==========================================================================*/
/*      Nom:                                                                */
/*      Description:                                                        */
/*      Parametres en entree:                                               */
/*      Parametres en sortie:                                               */
/*      Parametres en entree/sortie:                                        */
/*      Retour:                                                             */
/*==========================================================================*/
