/*****************************************************************************

        GRAOUMF TRACKER 2
        Author: Laurent de Soras, 1996-2016

--- Legal stuff ---

This program is free software. It comes without any warranty, to
the extent permitted by applicable law. You can redistribute it
and/or modify it under the terms of the Do What The Fuck You Want
To Public License, Version 2, as published by Sam Hocevar. See
http://sam.zoy.org/wtfpl/COPYING for more details.

*****************************************************************************/



/*\\\ FICHIERS INCLUDE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	<stdio.h>
#include	<stdlib.h>

#include	"base.h"
#include	"base_ct.h"
#include	"edstring.h"
#include	"env.h"
#include	"Envelope.h"
#include	"gtracker.h"
#include	"intrface.h"
#include	"log.h"
#include	"PatEdMenuEnvelopes.h"
#include	"PatEdMenuEnvLoops.h"
#include	"Popup.h"
#include	"resource.h"
#include	"rsc01.h"



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ CONSTANTES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ TYPES & STRUCTURES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ DEFINITION DES VARIABLES DE CLASSE PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ DEFINITION DES VARIABLES DE CLASSE PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\*/

const PatEdMenuEnvLoops_OBJSTR	PatEdMenuEnvLoops::OBJECTS [Envelope_NBR_LOOPS] =
{
	{
		RSC_OBJ_MP_SUBM_ENV_LP_ELOOP_ACTIVE_CB,
		RSC_OBJ_MP_SUBM_ENV_LP_ELOOP_START_BOX_VAL,
		RSC_OBJ_MP_SUBM_ENV_LP_ELOOP_END_BOX_VAL,
		RSC_OBJ_MP_SUBM_ENV_LP_ELOOP_TIMES_BOX_VAL,
		RSC_OBJ_MP_SUBM_ENV_LP_ELOOP_START_BOX,
		RSC_OBJ_MP_SUBM_ENV_LP_ELOOP_END_BOX,
		RSC_OBJ_MP_SUBM_ENV_LP_ELOOP_TIMES_BOX,
		RSC_OBJ_MP_SUBM_ENV_LP_ELOOP_START_U,
		RSC_OBJ_MP_SUBM_ENV_LP_ELOOP_END_U,
		RSC_OBJ_MP_SUBM_ENV_LP_ELOOP_TIMES_U,
		RSC_OBJ_MP_SUBM_ENV_LP_ELOOP_START_D,
		RSC_OBJ_MP_SUBM_ENV_LP_ELOOP_END_D,
		RSC_OBJ_MP_SUBM_ENV_LP_ELOOP_TIMES_D,
		Envelope_FLAG_ENV_LOOP
	},
	{
		RSC_OBJ_MP_SUBM_ENV_LP_SLOOP_ACTIVE_CB,
		RSC_OBJ_MP_SUBM_ENV_LP_SLOOP_START_BOX_VAL,
		RSC_OBJ_MP_SUBM_ENV_LP_SLOOP_END_BOX_VAL,
		RSC_OBJ_MP_SUBM_ENV_LP_SLOOP_TIMES_BOX_VAL,
		RSC_OBJ_MP_SUBM_ENV_LP_SLOOP_START_BOX,
		RSC_OBJ_MP_SUBM_ENV_LP_SLOOP_END_BOX,
		RSC_OBJ_MP_SUBM_ENV_LP_SLOOP_TIMES_BOX,
		RSC_OBJ_MP_SUBM_ENV_LP_SLOOP_START_U,
		RSC_OBJ_MP_SUBM_ENV_LP_SLOOP_END_U,
		RSC_OBJ_MP_SUBM_ENV_LP_SLOOP_TIMES_U,
		RSC_OBJ_MP_SUBM_ENV_LP_SLOOP_START_D,
		RSC_OBJ_MP_SUBM_ENV_LP_SLOOP_END_D,
		RSC_OBJ_MP_SUBM_ENV_LP_SLOOP_TIMES_D,
		Envelope_FLAG_SUS_LOOP
	}
};


/*\\\ METHODES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*==========================================================================*/
/*      Nom: check_ok                                                       */
/*      Description: Verifie l'intergrite de l'objet.                       */
/*      Retour: 0 si l'objet parait correct.                                */
/*==========================================================================*/

signed int	PatEdMenuEnvLoops::check_ok (void) const
{
	if (this == NULL)
	{
		LOG_printf ("PatEdMenuEnvLoops::check_ok: Error: \"this\" pointer is NULL.\n");
		return (-1);
	}

	/*** A faire ***/

	return (0);
}



/*==========================================================================*/
/*      Nom: self_display                                                   */
/*      Description: Affiche "textuellement" le contenu courant de l'objet. */
/*==========================================================================*/

void	PatEdMenuEnvLoops::self_display (void) const
{

	/*** A faire ***/

}



/*==========================================================================*/
/*      Nom: redraw                                                         */
/*      Description: Affiche la composante d'interface.                     */
/*==========================================================================*/

void	PatEdMenuEnvLoops::redraw (void)
{
	RSC_display_object (RSC_OBJ_MP_SUBM_ENV_LP);

	refresh ();
}



/*==========================================================================*/
/*      Nom: refresh                                                        */
/*      Description: Rafraichit l'affichage des donnees.                    */
/*==========================================================================*/

void	PatEdMenuEnvLoops::refresh (void)
{
	int		loop_type;
	int		flags;
	char		nbr3_0 [3+1];
	Envelope_LOOP	loop;

	for (loop_type = 0; loop_type < Envelope_NBR_LOOPS; loop_type ++)
	{
		flags = ENV_get_flags (PatEdMenuEnvelopes::cur_env_type, GTK_instr_nbr);
		loop = ENV_get_loop (PatEdMenuEnvelopes::cur_env_type, GTK_instr_nbr, loop_type);

		/* On/Off */
		RSC_select_object_display (OBJECTS [loop_type].cb, (flags & OBJECTS [loop_type].loop_flag) != 0);

		/* Start */
		sprintf (nbr3_0, INTR_base_song_3, (int)loop.start);
		RSC_set_string (OBJECTS [loop_type].start_val, nbr3_0);
		RSC_display_object (OBJECTS [loop_type].start_val);

		/* End */
		sprintf (nbr3_0, INTR_base_song_3, (int)loop.end);
		RSC_set_string (OBJECTS [loop_type].end_val, nbr3_0);
		RSC_display_object (OBJECTS [loop_type].end_val);

		/* Nombres de boucles */
		if (loop.nbr_loops == Envelope_LOOP_INFINITE)
		{
			strcpy (nbr3_0, "Inf");
		}
		else
		{
			sprintf (nbr3_0, INTR_base_song_3, (int)loop.nbr_loops);
		}
		RSC_set_string (OBJECTS [loop_type].nbr_val, nbr3_0);
		RSC_display_object (OBJECTS [loop_type].nbr_val);
	}

	refresh_dynamic (true);
}



/*==========================================================================*/
/*      Nom: refresh_dynamic                                                */
/*      Description: Rafraichit l'affichage des donnees dynamiques.         */
/*        - force_flag: true indique qu'on doit forcer le rafraichissement. */
/*==========================================================================*/

void	PatEdMenuEnvLoops::refresh_dynamic (bool force_flag)
{
	/* Rien */
}



/*==========================================================================*/
/*      Nom: manage                                                         */
/*      Description: Gere la composante d'interface                         */
/*      Parametres en entree:                                               */
/*        - sel_object: objet detecte par le gestionnaire d'interface       */
/*        - sel_elder: aine de sel_object                                   */
/*==========================================================================*/

void	PatEdMenuEnvLoops::manage (int sel_object, int sel_elder)
{
	int		loop_type;
	int		flags;

	flags = ENV_get_flags (PatEdMenuEnvelopes::cur_env_type, GTK_instr_nbr);

	for (loop_type = 0; loop_type < Envelope_NBR_LOOPS; loop_type ++)
	{
		/* On/Off */
		if (sel_object == OBJECTS [loop_type].cb)
		{
			flags ^= OBJECTS [loop_type].loop_flag;
			ENV_set_flags (PatEdMenuEnvelopes::cur_env_type, GTK_instr_nbr, flags);
			GTK_modified_flag = true;
			_father_object_ptr->refresh ();
		}

		/* Start */
		else if (sel_object == OBJECTS [loop_type].start)
		{
			if (RSC_mouse_key & 2)
			{
				set_loop_start_intr (INTR_CHGTYPE_POP, 0, loop_type);
			}
			else
			{
				set_loop_start_intr (INTR_CHGTYPE_KBD, 0, loop_type);
			}
		}
		else if (sel_object == OBJECTS [loop_type].start_up)
		{
			set_loop_start_intr (INTR_CHGTYPE_REL, INTR_inc_speed [0] [RSC_mouse_key], loop_type);
		}
		else if (sel_object == OBJECTS [loop_type].start_down)
		{
			set_loop_start_intr (INTR_CHGTYPE_REL, -INTR_inc_speed [0] [RSC_mouse_key], loop_type);
		}

		/* End */
		else if (sel_object == OBJECTS [loop_type].end)
		{
			if (RSC_mouse_key & 2)
			{
				set_loop_end_intr (INTR_CHGTYPE_POP, 0, loop_type);
			}
			else
			{
				set_loop_end_intr (INTR_CHGTYPE_KBD, 0, loop_type);
			}
		}
		else if (sel_object == OBJECTS [loop_type].end_up)
		{
			set_loop_end_intr (INTR_CHGTYPE_REL, INTR_inc_speed [0] [RSC_mouse_key], loop_type);
		}
		else if (sel_object == OBJECTS [loop_type].end_down)
		{
			set_loop_end_intr (INTR_CHGTYPE_REL, -INTR_inc_speed [0] [RSC_mouse_key], loop_type);
		}

		/* Nbr */
		else if (sel_object == OBJECTS [loop_type].nbr)
		{
			if (RSC_mouse_key & 2)
			{
				set_loop_nbr_intr (INTR_CHGTYPE_POP, 0, loop_type);
			}
			else
			{
				set_loop_nbr_intr (INTR_CHGTYPE_KBD, 0, loop_type);
			}
		}
		else if (sel_object == OBJECTS [loop_type].nbr_up)
		{
			set_loop_nbr_intr (INTR_CHGTYPE_REL, INTR_inc_speed [0] [RSC_mouse_key], loop_type);
		}
		else if (sel_object == OBJECTS [loop_type].nbr_down)
		{
			set_loop_nbr_intr (INTR_CHGTYPE_REL, -INTR_inc_speed [0] [RSC_mouse_key], loop_type);
		}
	}
}



/*==========================================================================*/
/*      Nom: activate                                                       */
/*      Description: Active ou desactive le menu. Celui-ci n'est pas        */
/*                   reaffiche.                                             */
/*      Parametres en entree:                                               */
/*        - activated_flag: indique si le menu doit etre active ou          */
/*                          desactive.                                      */
/*==========================================================================*/

void	PatEdMenuEnvLoops::activate (bool activated_flag)
{
	RSC_pos_flag (RSC_OBJ_MP_SUBM_ENV_LP, RSC_ATTR_NOTDISP, ! activated_flag);
	RSC_pos_flag (RSC_OBJ_MP_SUBM_ENV_PICN_LP, RSC_ATTR_SELECTED, activated_flag);
}



/*==========================================================================*/
/*      Nom: set_loop_start_intr                                            */
/*      Description: Change le debut de la boucle differentes manieres.     */
/*                   L'interface est ici mise en jeu.                       */
/*      Parametres en entree:                                               */
/*        - type: 0 = Le parametre est absolu,                              */
/*                1 = Le parametre est relatif,                             */
/*                2 = Entree au clavier,                                    */
/*                3 = Entree au pop-up.                                     */
/*        - value: le parametre en question.                                */
/*      Retour: 0 si tout s'est bien passe.                                 */
/*==========================================================================*/

signed int	PatEdMenuEnvLoops::set_loop_start_intr (int type, signed long value, int loop_type)
{
	long		new_value;
	signed int	line;
	signed long	code;
	char		nbr3_0 [3+1];
	Popup		popup_menu;
	Envelope_LOOP	loop;

	loop = ENV_get_loop (PatEdMenuEnvelopes::cur_env_type, GTK_instr_nbr, loop_type);
	new_value = loop.start;

	switch (type)
	{
	/* Position relative */
	case	INTR_CHGTYPE_REL:
		new_value += value;
		break;

	/* Entree au clavier */
	case	INTR_CHGTYPE_KBD:
		sprintf (nbr3_0, INTR_base_song_3, (int)new_value);
		EDIT_edit_string_base (nbr3_0, OBJECTS [loop_type].start_val, 3, INTR_base_song);
		new_value = strtol (nbr3_0, NULL, INTR_base_song);
		break;

	/* Position absolue  */
	case	INTR_CHGTYPE_ABS:
		new_value = value;
		break;

	/* Pop-up */
	case	INTR_CHGTYPE_POP:
		popup_menu.add_line ("0", 0);
		line = popup_menu.select_radio_by_code (new_value);
		code = popup_menu.manage (line);
		if (code >= 0)
		{
			new_value = code;
		}
		break;
	}

	new_value = MIN (new_value, loop.end);
	new_value = MAX (new_value, 0);
	loop.start = (UWORD)new_value;
	ENV_set_loop (PatEdMenuEnvelopes::cur_env_type, GTK_instr_nbr, loop_type, loop);
	GTK_modified_flag = true;
	_father_object_ptr->refresh ();

	return (0);
}



/*==========================================================================*/
/*      Nom: set_loop_end_intr                                              */
/*      Description: Change le debut de la boucle differentes manieres.     */
/*                   L'interface est ici mise en jeu.                       */
/*      Parametres en entree:                                               */
/*        - type: 0 = Le parametre est absolu,                              */
/*                1 = Le parametre est relatif,                             */
/*                2 = Entree au clavier,                                    */
/*                3 = Entree au pop-up.                                     */
/*        - value: le parametre en question.                                */
/*      Retour: 0 si tout s'est bien passe.                                 */
/*==========================================================================*/

signed int	PatEdMenuEnvLoops::set_loop_end_intr (int type, signed long value, int loop_type)
{
	long		new_value;
	signed int	line;
	signed long	code;
	char		nbr3_0 [3+1];
	Popup		popup_menu;
	Envelope_LOOP	loop;

	loop = ENV_get_loop (PatEdMenuEnvelopes::cur_env_type, GTK_instr_nbr, loop_type);
	new_value = loop.end;

	switch (type)
	{
	/* Position relative */
	case	INTR_CHGTYPE_REL:
		new_value += value;
		break;

	/* Entree au clavier */
	case	INTR_CHGTYPE_KBD:
		sprintf (nbr3_0, INTR_base_song_3, (int)new_value);
		EDIT_edit_string_base (nbr3_0, OBJECTS [loop_type].end_val, 3, INTR_base_song);
		new_value = strtol (nbr3_0, NULL, INTR_base_song);
		break;

	/* Position absolue  */
	case	INTR_CHGTYPE_ABS:
		new_value = value;
		break;

	/* Pop-up */
	case	INTR_CHGTYPE_POP:
		popup_menu.add_line ("0", 0);
		line = popup_menu.select_radio_by_code (new_value);
		code = popup_menu.manage (line);
		if (code >= 0)
		{
			new_value = code;
		}
		break;
	}

	new_value = MIN (new_value, ENV_get_nbr_points (PatEdMenuEnvelopes::cur_env_type, GTK_instr_nbr) - 1);
	new_value = MAX (new_value, loop.start);
	loop.end = (UWORD)new_value;
	ENV_set_loop (PatEdMenuEnvelopes::cur_env_type, GTK_instr_nbr, loop_type, loop);
	GTK_modified_flag = true;
	_father_object_ptr->refresh ();

	return (0);
}



/*==========================================================================*/
/*      Nom: set_loop_nbr_intr                                              */
/*      Description: Change le nombre de boucles differentes manieres.      */
/*                   L'interface est ici mise en jeu.                       */
/*      Parametres en entree:                                               */
/*        - type: 0 = Le parametre est absolu,                              */
/*                1 = Le parametre est relatif,                             */
/*                2 = Entree au clavier,                                    */
/*                3 = Entree au pop-up.                                     */
/*        - value: le parametre en question.                                */
/*      Retour: 0 si tout s'est bien passe.                                 */
/*==========================================================================*/

signed int	PatEdMenuEnvLoops::set_loop_nbr_intr (int type, signed long value, int loop_type)
{
	long		new_value;
	signed int	line;
	signed long	code;
	char		nbr3_0 [3+1];
	Popup		popup_menu;
	Envelope_LOOP	loop;

	loop = ENV_get_loop (PatEdMenuEnvelopes::cur_env_type, GTK_instr_nbr, loop_type);
	new_value = loop.nbr_loops;

	switch (type)
	{
	/* Position relative */
	case	INTR_CHGTYPE_REL:
		new_value += value;
		break;

	/* Entree au clavier */
	case	INTR_CHGTYPE_KBD:
		if (new_value == Envelope_LOOP_INFINITE)
		{
			new_value = 0;
		}
		sprintf (nbr3_0, INTR_base_song_3, (int)new_value);
		EDIT_edit_string_base (nbr3_0, OBJECTS [loop_type].nbr_val, 3, INTR_base_song);
		new_value = strtol (nbr3_0, NULL, INTR_base_song);
		if (new_value == 0)
		{
			new_value = Envelope_LOOP_INFINITE;
		}
		break;

	/* Position absolue  */
	case	INTR_CHGTYPE_ABS:
		new_value = value;
		break;

	/* Pop-up */
	case	INTR_CHGTYPE_POP:
		popup_menu.add_line ("Infinite loop", Envelope_LOOP_INFINITE);
		line = popup_menu.select_radio_by_code (new_value);
		code = popup_menu.manage (line);
		if (code >= 0)
		{
			new_value = code;
		}
		break;
	}

	if (new_value != Envelope_LOOP_INFINITE)
	{
		new_value = MIN (new_value, Envelope_MAX_NBR_LOOPS);
		new_value = MAX (new_value, 1);
	}
	loop.nbr_loops = (UWORD)new_value;
	ENV_set_loop (PatEdMenuEnvelopes::cur_env_type, GTK_instr_nbr, loop_type, loop);
	GTK_modified_flag = true;
	refresh ();

	return (0);
}



/*\\\ METHODES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/****************************************************************************/
/*                                                                          */
/*                                                                          */
/*                                                                          */
/****************************************************************************/



/*==========================================================================*/
/*      Nom:                                                                */
/*      Description:                                                        */
/*      Parametres en entree:                                               */
/*      Parametres en sortie:                                               */
/*      Parametres en entree/sortie:                                        */
/*      Retour:                                                             */
/*==========================================================================*/
