/*****************************************************************************

        GRAOUMF TRACKER 2
        Author: Laurent de Soras, 1996-2016

--- Legal stuff ---

This program is free software. It comes without any warranty, to
the extent permitted by applicable law. You can redistribute it
and/or modify it under the terms of the Do What The Fuck You Want
To Public License, Version 2, as published by Sam Hocevar. See
http://sam.zoy.org/wtfpl/COPYING for more details.

*Tab=3***********************************************************************/



#pragma once
#if ! defined (Meter_HEADER_INCLUDED)
#define	Meter_HEADER_INCLUDED

#if defined (_MSC_VER)
	#pragma warning (4 : 4250)
#endif



/*\\\ INCLUDE FILES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



class Meter
{

/*\\\ PUBLIC \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:

	               Meter ();
	
	void           set_sample_freq (double freq);
	void           clear_buffers ();
	void           process_block (const float data_ptr [], long buf_len, int nbr_voices);
	void           skip_block (long buf_len);
	double         get_peak () const;
	double         get_peak_hold () const;
	double         get_rms () const;
	void           clear_peak ();




/*\\\ PROTECTED \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

protected:



/*\\\ PRIVATE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:

	struct Decay
	{
		long           _hold_time;    // Samples
		double         _coef_r;
		double         _coef_r2;
		double         _coef_a2;
	};

	void           fix_tiny_values ();

	double         _sample_freq;     // Hz
	double         _peak_max;        // Maximum peak value
	double         _peak_hold;       // Hold value for peak
	long           _hold_counter;    // Counter for holding time (samples). Set to the maximum at a peak, and decreased. When reaching 0, the peak is set to the instantaneous value.
   double         _rms_sq;          // RMS value with an envelope, squared

	Decay          _dec [2];         // For mono and stereo



/*\\\ FORBIDDEN MEMBER FUNCTIONS \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:

	               Meter (const Meter &other);
	bool           operator == (const Meter &other) const;
	bool           operator != (const Meter &other) const;

};	// class Meter



//#include	"Meter.hpp"



#endif	// Meter_HEADER_INCLUDED



/*\\\ EOF \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
