/*****************************************************************************

        GRAOUMF TRACKER 2
        Author: Laurent de Soras, 1996-2016

--- Legal stuff ---

This program is free software. It comes without any warranty, to
the extent permitted by applicable law. You can redistribute it
and/or modify it under the terms of the Do What The Fuck You Want
To Public License, Version 2, as published by Sam Hocevar. See
http://sam.zoy.org/wtfpl/COPYING for more details.

*****************************************************************************/



/*\\\ FICHIERS INCLUDE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	<stdio.h>
#include	<stdlib.h>

#include	"archi.h"
#include	"base_ct.h"
#include	"Image.h"
#include	"log.h"
#include	"memory.h"



/*\\\ CONSTANTES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ CONSTANTES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ TYPES & STRUCTURES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ DEFINITION DES VARIABLES DE CLASSE PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ DEFINITION DES VARIABLES DE CLASSE PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*\\\ METHODES PUBLIQUES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/*==========================================================================*/
/*      Nom: (constructeur)                                                 */
/*      Description: Cree une image                                         */
/*      Parametres en entree:                                               */
/*        - width: largeur de l'image                                       */
/*        - height: Hauteur de l'image                                      */
/*==========================================================================*/

Image::Image (int width, int height)
{
	_data_ptr = NULL;

	_pos_x = 0;
	_pos_y = 0;
	_width = width;
	_height = height;
	
	_data_ptr = (UBYTE *) MALLOC ((long)width * height);
	if (_data_ptr == NULL)
	{
		LOG_printf ("Image::Image: Error: could't allocate memory for image data.\n");
	}
}



/*==========================================================================*/
/*      Nom: (destructeur)                                                  */
/*      Description: Detruit                                                */
/*==========================================================================*/

Image::~Image ()
{
	if (_data_ptr != NULL)
	{
		FREE (_data_ptr);
		_data_ptr = NULL;
	}
}



/*==========================================================================*/
/*      Nom: check_ok                                                       */
/*      Description: Verifie l'intergrite de l'objet.                       */
/*      Retour: 0 si l'objet parait correct.                                */
/*==========================================================================*/

signed int	Image::check_ok (void) const
{
	if (this == NULL)
	{
		LOG_printf ("Image::check_ok: Error: \"this\" pointer is NULL.\n");
		return (-1);
	}

	if (_data_ptr == NULL)
	{
		LOG_printf ("Image::check_ok: Error: _data_ptr is NULL.\n");
		return (-1);
	}
	MCHECK (_data_ptr);

	return (0);
}



/*==========================================================================*/
/*      Nom: self_display                                                   */
/*      Description: Affiche "textuellement" le contenu courant de l'objet. */
/*==========================================================================*/

void	Image::self_display (void) const
{

	/*** A faire ***/

}



int		Image::get_width (void) const
{
	return (_width);
}



int		Image::get_height (void) const
{
	return (_height);
}



UBYTE		*Image::get_data_ptr (void) const
{
	return (_data_ptr);
}



/*\\\ METHODES PRIVEES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/



/****************************************************************************/
/*                                                                          */
/*                                                                          */
/*                                                                          */
/****************************************************************************/



/*==========================================================================*/
/*      Nom:                                                                */
/*      Description:                                                        */
/*      Parametres en entree:                                               */
/*      Parametres en sortie:                                               */
/*      Parametres en entree/sortie:                                        */
/*      Retour:                                                             */
/*==========================================================================*/
