/*****************************************************************************

        GRAOUMF TRACKER 2
        Author: Laurent de Soras, 1996-2016

--- Legal stuff ---

This program is free software. It comes without any warranty, to
the extent permitted by applicable law. You can redistribute it
and/or modify it under the terms of the Do What The Fuck You Want
To Public License, Version 2, as published by Sam Hocevar. See
http://sam.zoy.org/wtfpl/COPYING for more details.

*****************************************************************************/



#if ! defined (Drumpad_HEADER_INCLUDED)
#define	Drumpad_HEADER_INCLUDED

#if defined (_MSC_VER)
	#pragma once
	#pragma warning (4 : 4250) // "Inherits via dominance."
#endif



/*\\\ INCLUDE FILES \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

#include	"mods_ct.h"



class Drumpad
{

/*\\\ PUBLIC \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

public:

	enum {			NBR_SLOTS	= 64	};

						Drumpad ();
	virtual			~Drumpad () {}

	// Basic functions
	void				clear_all ();

	bool				is_slot_full (int index) const;
	void				get_slot (int index, MODS_GT2_SPL_NOTE &content) const;
	void				set_slot (int index, const MODS_GT2_SPL_NOTE &content);
	void				clear_slot (int index);

	// With the use of the GUI
	int				record_slot (int index);
	int				restitute_slot (int index) const;



/*\\\ PROTECTED \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

protected:



/*\\\ PRIVATE \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:

	class Slot
	{
	public:
							Slot ();
		void				clear ();
		MODS_GT2_SPL_NOTE
							_note;
		bool				_full_flag;
	};

	typedef	Slot	SlotArr [NBR_SLOTS];

	SlotArr			_slot_arr;



/*\\\ FORBIDDEN MEMBER FUNCTIONS \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/

private:

						Drumpad (const Drumpad &other);
	Drumpad &		operator = (const Drumpad &other);
	bool				operator == (const Drumpad &other);
	bool				operator != (const Drumpad &other);

};	// class Drumpad





//#include	"Drumpad.hpp"



#endif	// Drumpad_HEADER_INCLUDED



/*\\\ EOF \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\*/
