/***************************************************************************
****************************************************************************
****************************************************************************
*
* FunktrackerGOLD - By Jason Nunn
* Copyright (C) 1996,1998 Jason Nunn
*
* FunktrackerGOLD now comes under the GNU General Public License. Please
* read the COPYING notice in this distribution.
*
* ================================================================
* Sequence Editor
*
****************************************************************************
****************************************************************************
***************************************************************************/
#include <curses.h>
#include "funktracker_defs.h"
#include "dsp_mixxer.h"
#include "funktracker.h"
#include "funkload.h"
#include "funkgold_misc.h"
#include "funkgold_dir.h"
#include "funkgold_pe.h"
#include "funkgold.h"

unsigned char se_pos_real;
unsigned char se_pos_hl;
unsigned char se_pos_hl_old;

/***************************************************************************
*
***************************************************************************/
void se_display_bg(void)
{
  register int y;
  register int amaxy = maxy - 5;
  char tmpstr[10];

  char *cpu_table[] = {
    "Unknown",
    "IBM PC ?",
    "IBM PC ?",
    "i386 PC",
    "i486 PC",
    "Pentium PC",
    "Linux",
    "FreeBSD",
    "Not Used",
    "Not Used",
    "Not Used",
    "Not Used",
    "Not Used",
    "Not Used",
    "Not Used",
    "Other"
  };

  char *crd_table[] = {
    "SB2.0",
    "SBPRO",
    "GUS var pan",
    "SB1.x",
    "SB16",
    "GUS fix pan",
    "Ripped",
    "PAS",
    "Vox 8 bit",
    "Vox 16 bit",
    "Unused",
    "Unused",
    "Unused",
    "Unused",
    "Unused",
    "Other"
  };

  display_topbar();
  move(1,0);
  set_colour(COL_TITLE);
  addstr("Sequence Editor");
  move(1,40);
  addstr("Funk Info");

  set_colour(COL_TEXT2);
  move(4,42);
  addstr("FNK Type: ");
  addnstr(funk_hr_ptr->funk_type,4);
  move(5,42);
  addstr("Creation: ");
  sprintf(tmpstr,"%d/",funk_hr_ptr->info[0] & 0x1f);
  addstr(tmpstr);
  sprintf(tmpstr,"%d/",
    ((funk_hr_ptr->info[1] & 1) << 3) + (funk_hr_ptr->info[0] >> 5));
  addstr(tmpstr);
  sprintf(tmpstr,"%d",(funk_hr_ptr->info[1] >> 1) + 1980);
  addstr(tmpstr);
  move(6,42);
  addstr("CPU Type: ");
  addstr(cpu_table[funk_hr_ptr->info[2] >> 4]);
  move(7,42);
  addstr("CRD Type: ");
  addstr(crd_table[funk_hr_ptr->info[2] & 0xf]);
  move(8,42);
  addstr("FNK Size: ");
  sprintf(tmpstr,"%dk",funk_hr_ptr->LZH_check_size >> 10);
  addstr(tmpstr);
  move(9,42);
  addstr("BPM rate: ");
  sprintf(tmpstr,"%d",funk_info.bpm_rate);
  addstr(tmpstr);
  move(10,42);
  addstr("FNK prec: ");
  if(funk_info.sample_precision == 16)
    addstr("16");
  else
    addch('8');
  addstr(" bit");

  set_colour_hl(COL_BOX);
  for(y = 0;y < (maxy - 8);y++)
  {
    move(y + 3,0);
    addch(' ');
    move(y + 3,4);
    addch(' ');
    move(y + 3,7);
    addch(' ');
    move(y + 3,40);
    addch(' ');
    move(y + 3,65);
    addch(' ');
  }
  move(2,0);
  addstr("Seq  Pt ");
  move(amaxy,0);
  addstr("        ");
  clear_area(2,40,2,65);
  clear_area(amaxy,40,amaxy,65);
}

/***************************************************************************
*
***************************************************************************/
void se_dis_seqentry(unsigned char hlpos)
{
  char bstr[] = "  ";
  register int seq_no = se_pos_real + hlpos,x;

  move(hlpos + 3,1);
  byte2str(bstr,seq_no);
  addstr(bstr);
  if(seq_no == funk_hr_ptr->loop_order)
    addch('*');
  else
    addch(' ');
  move(hlpos + 3,5);
  x = funk_hr_ptr->order_list[seq_no];
  if(x == 0xff)
    addstr("--");
  else
  {
    byte2str(bstr,funk_hr_ptr->order_list[seq_no]);
    addstr(bstr);
  }
}

/***************************************************************************
*
***************************************************************************/
void se_display_all(void)
{
  register int seq_no;

  set_colour(COL_TEXT);
  for(seq_no = 0;seq_no < (maxy - 8);seq_no++)
    se_dis_seqentry(seq_no);
  set_colour(COL_TITLE);
  attron(A_REVERSE);
  se_dis_seqentry(se_pos_hl);
  se_pos_hl_old = se_pos_hl;
}

void se_move_hl(void)
{
  set_colour(COL_TEXT);
  se_dis_seqentry(se_pos_hl_old);
  set_colour(COL_TITLE);
  attron(A_REVERSE);
  se_dis_seqentry(se_pos_hl);
  se_pos_hl_old = se_pos_hl;
}

/***************************************************************************
*
***************************************************************************/
void se_edit_seq(void)
{
  register int x,seq_no;
  char str[] = "  ";

  seq_no = se_pos_real + se_pos_hl;
  get_string(3 + se_pos_hl,5,str,2);
  x = hex2charn(str);
  if(x > (MAXIMUM_PATTERNS - 1))
    x = 0xff;
  funk_hr_ptr->order_list[seq_no] = x;
  se_dis_seqentry(se_pos_hl);
  update_screen();
}

/***************************************************************************
*
***************************************************************************/
void se_cursor_up(void)
{
  if(se_pos_hl > 0)
  {
    se_pos_hl--;
    se_move_hl();
    update_screen();
  }
  else
  {
    if(se_pos_real > 0) se_pos_real--;
    se_display_all();
    update_screen();
  }
}

void se_cursor_down(void)
{
  if(se_pos_hl < (maxy - 9))
  {
    se_pos_hl++;
    se_move_hl();
    update_screen();
  }
  else
  {
    if(se_pos_real < ((256 + 8) - maxy)) se_pos_real++;
    se_display_all();
    update_screen();
  }
}

/***************************************************************************
*
***************************************************************************/
void se_insert_seq(void)
{
  register int x,seq_no = se_pos_real + se_pos_hl;
  for(x = 0xff;x > seq_no;x--)
    funk_hr_ptr->order_list[x] = funk_hr_ptr->order_list[x - 1];
  funk_hr_ptr->order_list[x] = 0xff;
  se_display_all();
  update_screen();
}

void se_delete_seq(void)
{
  register int x,seq_no = se_pos_real + se_pos_hl;
  for(x = seq_no;x < 0xff;x++)
    funk_hr_ptr->order_list[x] = funk_hr_ptr->order_list[x + 1];
  funk_hr_ptr->order_list[0xff] = 0xff;
  se_display_all();
  update_screen();
}

/***************************************************************************
*
***************************************************************************/
void se_edit_bpm(void)
{
  char str[] = "    ";

  set_colour(COL_TEXT2);
  get_string(9,52,str,3);
  sscanf(str,"%d",&(funk_info.bpm_rate));
  if(funk_info.bpm_rate < MIN_BPM_RATE)
    funk_info.bpm_rate = MIN_BPM_RATE;
  if(funk_info.bpm_rate > MAX_BPM_RATE)
    funk_info.bpm_rate = MAX_BPM_RATE;
  attroff(A_REVERSE);
  move(9,52);
  sprintf(str,"%d",funk_info.bpm_rate);
  addstr(str);
  addch(' ');
  update_screen();
}

/***************************************************************************
*
***************************************************************************/
void se_main(void)
{
  register int sepos;

  switch(ch)
  {
    case FC_GOTO_SAM_EDIT:
      edit_mode = EM_SAMPLE;
      main_editor_dis_bg();
      break;
    case FC_GOTO_PAT_EDIT:
      edit_mode = EM_PATTERN;
      main_editor_dis_bg();
      break;
    case FC_ARROW_UP:
      se_cursor_up();
      break;
    case FC_ARROW_DN:
      se_cursor_down();
      break;
    case FC_SE_EDIT_ENTRY:
      se_edit_seq();
      break;
    case FC_SE_SET_LOOP:
      sepos = se_pos_real + se_pos_hl;
      find_pats_seqs();
      funk_hr_ptr->loop_order = sepos;
      se_display_all();
      update_screen();
      break;
    case FC_SE_SET_NOLOOP:
      funk_hr_ptr->loop_order = 0xff;
      se_display_all();
      update_screen();
      break;
    case FC_DEL_ENTRY:
      se_delete_seq();
      break;
    case FC_INS_ENTRY:
      se_insert_seq();
      break;
    case FC_SE_SET_BPM:
      se_edit_bpm();
      break;
    default:
      global_keys();
      break;
  }
}
