/***************************************************************************
    This file is part of the CheeseTronic Music Tools
    url                  : http://reduz.com.ar/cheesetronic
    copyright            : (C) 2003 by Juan Linietsky
    email                : coding@reduz.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
//
//
// C++ Implementation: cpp
//
// Description:
//
//
// Author: Juan Linietsky <coding@reduz.com.ar>, (C) 2003
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "property_bridge_edit.h"


//////////////////////////////////////////////////////////////////////////////
///////////////////// INT PROPERTY //////////////////////////
//////////////////////////////////////////////////////////////////////////////

void Q_Property_Bridge_Int::value_changed(int p_newval) {

	if (!bridge) return;

	char buf[40];
	sprintf(buf," %i",p_newval);
	slider_label->setText(buf);
	bridge->set(p_newval);
}

void Q_Property_Bridge_Int::set_bridge(Int_Property_Bridge *p_bridge) {

	bridge=p_bridge;
	int bridge_val=bridge->get();
	slider->setRange(bridge->get_min(),bridge->get_max());
	slider->setValue(bridge_val);
	label->setText(bridge->get_name().c_str());
	value_changed(bridge_val);
}

Q_Property_Bridge_Int::Q_Property_Bridge_Int(QWidget *p_parent) :  QVBox(p_parent) {

	bridge=NULL;
	label = new QLabel("Bridge:",this);
	slider_hbox = new QHBox(this);
	slider = new QSlider(Qt::Horizontal,slider_hbox);
	slider_label = new QLabel("0",slider_hbox);

	QObject::connect( slider, SIGNAL(valueChanged(int)),this, SLOT(value_changed(int)) );
}

//////////////////////////////////////////////////////////////////////////////
///////////////////// FLOAT PROPERTY //////////////////////////
//////////////////////////////////////////////////////////////////////////////

void Q_Property_Bridge_Float::value_changed(int p_newval) {

	if (!bridge) return;

        double real_range=bridge->get_max()-bridge->get_min();

	double own_range=(double)MAX-(double)MIN;
	double real_val=(double)p_newval*real_range/own_range;
	real_val+=bridge->get_min();

	bridge->set(real_val);

	char buf[40];
	sprintf(buf,"%.3f",real_val);
	text_edit->setText(buf);

}

void Q_Property_Bridge_Float::text_changed() {

	if (!bridge) return;

	float textval=atof(text_edit->text().ascii());

	//validate
	bridge->set(textval);
	textval=bridge->get();

        double real_range=bridge->get_max()-bridge->get_min();
	double own_range=(double)MAX-(double)MIN;
	double real_val=(double)(textval-bridge->get_min())*own_range/real_range;

        slider->setValue((int)real_val);

	char buf[40];
	sprintf(buf,"%.3f",textval);
	text_edit->setText(buf);

//	value_changed(real_val);

}

void Q_Property_Bridge_Float::set_bridge(Float_Property_Bridge *p_bridge) {

	bridge=p_bridge;
	slider->setRange(MIN,MAX);
	label->setText(bridge->get_name().c_str());
	char buf[40];
	sprintf(buf,"%.3f",bridge->get());
	text_edit->setText(buf);
	text_changed();
}

Q_Property_Bridge_Float::Q_Property_Bridge_Float(QWidget *p_parent) :  QVBox(p_parent) {

	bridge=NULL;
	label = new QLabel("Bridge:",this);
	slider_hbox = new QHBox(this);
	slider = new QSlider(Qt::Horizontal,slider_hbox);
	text_edit = new QLineEdit(slider_hbox);
	QObject::connect( slider, SIGNAL(valueChanged(int)),this, SLOT(value_changed(int)) );
	QObject::connect( text_edit, SIGNAL(returnPressed()),this, SLOT(text_changed()) );
}

//////////////////////////////////////////////////////////////////////////////
///////////////////// INT PROPERTY CSPIN //////////////////////////
//////////////////////////////////////////////////////////////////////////////

void Q_Property_Bridge_Int_CSpinButon::value_changed(int p_newval) {

	if (!bridge) return;
	bridge->set(p_newval);
}

void Q_Property_Bridge_Int_CSpinButon::set_bridge(Int_Property_Bridge *p_bridge) {

	bridge=p_bridge; //now finally we can set the real one and the value
	int bridge_val=bridge->get();
	spin->setMaxValue(bridge->get_max());
	spin->setMinValue(bridge->get_min());
	spin->setValue(bridge_val);

//	spin->setSizePolicy(QSizePolicy(QSizePolicy::Maximum,QSizePolicy::Maximum));
	label->setText(bridge->get_name().c_str());
	value_changed(bridge_val);
}

Q_Property_Bridge_Int_CSpinButon::Q_Property_Bridge_Int_CSpinButon(QWidget *p_parent) :  QHBox(p_parent) {

	bridge=NULL;
	label = new QLabel("Bridge:",this);
	spin = new CSpinButton(this);

	QObject::connect( spin, SIGNAL(valueChanged(int)),this, SLOT(value_changed(int)) );
}

///////////////////////////////////////////////////////////////////////////////////
///////////////////// BOOL PROPERTY //////////////////////////
//////////////////////////////////////////////////////////////////////////////////

void Q_Property_Bridge_Bool::toggled_cbk(bool p_on) {

	if (!bridge) return;
	bridge->set(p_on);

}

Q_Property_Bridge_Bool::Q_Property_Bridge_Bool(QWidget *p_parent) : QCheckBox(p_parent) {

	bridge=NULL;
	setText("Bridge");
	QObject::connect(this, SIGNAL(toggled(bool)),this, SLOT(toggled_cbk(bool)) );
}

void Q_Property_Bridge_Bool::set_bridge(Bool_Property_Bridge *p_bridge) {

	bridge=p_bridge;
	setChecked(bridge->get());
	setText(bridge->get_name().c_str());
}

///////////////////////////////////////////////////////////////////////////////////
///////////////////// OPTIONS PROPERTY //////////////////////////
//////////////////////////////////////////////////////////////////////////////////

void Q_Property_Bridge_Options::value_changed(int p_newval) {

	if (!bridge) return;

	bridge->set(p_newval);
//	//printf("Selected %i\n",p_newval);
}

void Q_Property_Bridge_Options::set_bridge(Options_Property_Bridge *p_bridge) {

        bridge=p_bridge;
	label->setText(p_bridge->get_name().c_str());
	combo->clear();
	for (int i=0;i<p_bridge->get_option_count();i++) {

		combo->insertItem(bridge->get_option_text(i),i);
	}

	combo->setCurrentItem(bridge->get());
}

Q_Property_Bridge_Options::Q_Property_Bridge_Options(QWidget *p_parent) :  QVBox(p_parent) {

	bridge=NULL;
	label = new QLabel("Bridge:",this);
	combo = new QComboBox(this);

	QObject::connect( combo , SIGNAL(activated(int)),this, SLOT(value_changed(int)) );
}

///////////////////////////////////////////////////////////////////////////////////
///////////////////// STRING SINGLE LINE//////////////////////////
//////////////////////////////////////////////////////////////////////////////////


void Q_Property_Bridge_String::value_changed(const QString& p_text) {

	if (!bridge || validating) return;

	string new_text=text_edit->text().ascii();
	if (new_text.length()>bridge->get_max_length()) {
		new_text=new_text.substr(0,bridge->get_max_length());
		validating=true;
		bridge->set(new_text);
		text_edit->setText(new_text.c_str());
		validating=false;
	} else {
		bridge->set(new_text);
	}
}

void Q_Property_Bridge_String::set_bridge(String_Property_Bridge *p_bridge) {

	bridge=p_bridge;
	label->setText(bridge->get_name().c_str());
	text_edit->setText(p_bridge->get().c_str());

}

Q_Property_Bridge_String::Q_Property_Bridge_String(QWidget *p_parent) :  QVBox(p_parent) {

	bridge=NULL;
	label = new QLabel("Bridge:",this);
	text_edit= new QLineEdit(this);
	text_edit->setSizePolicy(QSizePolicy(QSizePolicy::Expanding,QSizePolicy::Expanding));
	validating=false;

	QObject::connect( text_edit, SIGNAL(textChanged(const QString&)),this, SLOT(value_changed(const QString&)) );
}




///////////////////////////////////////////////////////////////////////////////////
///////////////////// STRING MULTILINE//////////////////////////
//////////////////////////////////////////////////////////////////////////////////


void Q_Property_Bridge_String_Multiline::value_changed() {

	if (!bridge) return;

	bridge->set(text_edit->text().ascii());
}

void Q_Property_Bridge_String_Multiline::set_bridge(String_Property_Bridge *p_bridge) {

	bridge=p_bridge;
	label->setText(bridge->get_name().c_str());
	text_edit->setText(p_bridge->get().c_str());
}

Q_Property_Bridge_String_Multiline::Q_Property_Bridge_String_Multiline(QWidget *p_parent) :  QVBox(p_parent) {

	bridge=NULL;
	label = new QLabel("Bridge:",this);
	text_edit= new QTextEdit(this);
	text_edit->setSizePolicy(QSizePolicy(QSizePolicy::Expanding,QSizePolicy::Expanding));

	QObject::connect( text_edit, SIGNAL(textChanged()),this, SLOT(value_changed()) );
}

