;Ŀ
;EXAMPLE OF USING THE MASTER TRACKER 2.x AKMTRK2.OBJ FILE IN ASSEMBLER
;BY [PYRO-FYRE]/ARKHAM                                        06/05/95
;

.386P

AKMTRACK  SEGMENT PARA PUBLIC USE16 ;INIT CODE SEGMENT FOR THE PLAYER
AKMTRACK  ENDS
  
  EXTRN   INITADL:FAR             ;THE START MUSIC PROCEDURE
  EXTRN   STOPADL:FAR             ;PROCEDURE FOR STOPING MUSIC
  EXTRN   BARNOTE0:BYTE           ;BARNOTEx IS SET TO 1 WHEN THE VOICE x IS USED FOR A NEW KEY
  EXTRN   BARNOTE1:BYTE
  EXTRN   BARNOTE2:BYTE
  EXTRN   BARNOTE3:BYTE
  EXTRN   BARNOTE4:BYTE
  EXTRN   BARNOTE5:BYTE
  EXTRN   BARNOTE6:BYTE
  EXTRN   BARNOTE7:BYTE
  EXTRN   BARNOTE8:BYTE
  EXTRN   RESTART:BYTE            ;RESTART AT THIS POSITION AT THE END OF THE MUSIC
  EXTRN   NUMVOICE:BYTE           ;NUMBER OF ADLIB VOICE (MAX 9)
  EXTRN   POSITIONFIN:BYTE        ;LENGHT OF THE MUSIC
  EXTRN   POSITION:BYTE           ;CURRENT POSITION OF THE MUSIC
  EXTRN   SEGPATTERN:WORD         ;SEGMENT OF THE PATTERNS
  EXTRN   OFFPATTERN:WORD         ;OFFSET OF THE PATTERNS
  EXTRN   SEGSONG:WORD            ;SEGMENT OF THE POSITIONS + ADLIB SAMPLES
  EXTRN   OFFSONG:WORD            ;OFFSET OF THE POSITION +ADLIB SAMPLES
  EXTRN   PATPOSITION:BYTE        ;CURRENT PATTERN PLAYED
  EXTRN   SPEED:WORD              ;THIS VALUE IS SET IN THE TIMER INTERRUPTION 8
  EXTRN   FASTADLREG:BYTE         ;IF SET TO 0->SLOW ADLIB/SB REGISTER, IF SET TO 1->FAST REGISTERS FOR SBPRO/SB16/GUS

PILE      SEGMENT STACK USE16
  DW      512 DUP (0)
PILE      ENDS

ZONE      SEGMENT USE16           ;MEMORY WHERE IS STOCKED THE MUSIC
  DB      11584 DUP (0)           ;THE LARGER MUST BE THE SAME AS THE .MTR FILE
ZONE      ENDS

CODE      SEGMENT USE16
          ASSUME CS:CODE,DS:CODE,SS:PILE

ASC2HEX   PROC FAR
  XOR     EDX,EDX
ASC2HEX3:  
  LODSB
  CMP     AL,57
  JG      ASC2HEX1
  SUB     AL,48
  JMP     ASC2HEX2
ASC2HEX1:
  SUB     AL,55
ASC2HEX2:
  SHL     EDX,4
  OR      DL,AL
LOOP      ASC2HEX3
  RET
ASC2HEX   ENDP
  
  FREEWAY_MTR DB 'FREEWAY.MTR',0
  NUMFILE     DW 0
  
START:

  MOV     AX,AKMTRACK
  MOV     ES,AX
  MOV     AX,CS
  MOV     DS,AX
  MOV     AX,03D00H               ;OPEN FILE
  MOV     DX,OFFSET FREEWAY_MTR
  INT     021H
  MOV     BX,AX
  MOV     CS:NUMFILE,BX

  MOV     AX,ZONE                 ;READ MUSIC FILE'S INFORMATIONS
  MOV     DS,AX                   ;TARGET SEGMENT
  MOV     AX,03F00H               ;READ MODE
  XOR     DX,DX                   ;TARGET OFFSET
  MOV     CX,50                   ;LENGTH OF THE INFORMATIONS
  INT     021H                    ;DOS CALL
  
  MOV     SI,10                   ;FIND NUMBER OF VOICES
  MOV     CX,2
  CALL    ASC2HEX
  INC     DL
  MOV     ES:NUMVOICE,DL

  MOV     SI,19                   ;FIND LENGHT
  MOV     CX,2
  CALL    ASC2HEX
  INC     DL
  MOV     ES:POSITIONFIN,DL

  MOV     SI,22                   ;FIND NUMBER OF INSTRUMENTS
  MOV     CX,2
  CALL    ASC2HEX
  XOR     DH,DH
  SHL     DX,6
  ADD     DX,276
  PUSH    DX                      ;STORE LOCATION OF THE PATTERNS

  MOV     SI,25                   ;FIND RESTART
  MOV     CX,2
  CALL    ASC2HEX
  MOV     ES:RESTART,DL

  MOV     SI,28                   ;FIND SPEED
  MOV     CX,4
  CALL    ASC2HEX
  MOV     ES:SPEED,DX

  MOV     SI,33                   ;FIND FILE LENGHT
  MOV     CX,8
  CALL    ASC2HEX
  SUB     DX,61
  
  MOV     BX,CS:NUMFILE
  MOV     AX,03F00H               ;READ MODE
  MOV     CX,DX                   ;LENGTH OF FILE
  XOR     DX,DX                   ;TARGET OFFSET
  INT     021H                    ;DOS CALL

  MOV     AX,03E00H               ;CLOSE FILE
  INT     021H

  MOV     AX,ZONE
  MOV     ES:SEGPATTERN,AX        ;INITIALISE INFORMATIONS
  MOV     ES:SEGSONG,AX
  POP     DX                      ;RESTORE LOCATION OF THE PATTERNS
  MOV     ES:OFFPATTERN,DX        ;MEMORY LOCATION OF THE PATTERNS
  MOV     ES:OFFSONG,20           ;MEMORY LOCATION OF THE POSITION
  MOV     ES:POSITION,0           ;POSITION START AT 0
  MOV     BYTE PTR ES:FASTADLREG,0 ;0=SLOW ADLIB/SB 1=FAST SBPRO/SB16/GUS
  
  CALL    INITADL                 ;START MUSIC (NOT ENTRIES)
  XOR     AH,AH                   ;WAIT KEYBOARD
  INT     16H

  CALL    STOPADL                 ;STOP MUSIC
  MOV     AX,04C00H               ;RETURN TO DOS (NOT WINDOWS OR SLOW OS PLEASE!)
  INT     21H

CODE      ENDS

END START

'-------------------------
'FILE FORMAT:      LENGTH
'-------------------------
'INFORMATION      | 0050 | MTRACK NOM_MUSIQUE (20 CHAR) 00 (NBVOICES%-1) 00 (NB PATTERN-1) 00 (LENGTH) 01F3 (RESTART)  00000000 (LONGUEUR) + CHR(1AH)
'SPEED            | 0002 |
'DEVICE           | 0001 | 0=SPK 1=ADL 2=SBP ;NOT USED NOW 
'POSITIONS        | 0256 |
'VOICES TYPE      | 0256 |
'-------------------------
'INSTRUMENTS:     | 4096 | (TOTAL BYTES, 64 INSTRUMENTS)
'-------------------------
'INSTRUM NAME     | 0020 |
'DATAS            | 0044 | (TOTAL BYTES, 1 INSTRUMENT
'IDENTIFICATION---|------|------|
'                 | 0001 | 0001 | IDENTIFICATION: THIS BYTE=02 WHEN IT IS USED OR 00 WHEN NOT.
'1 OPPERATOR-----|------|------|
'                 |      | 0004B| MODULATOR FREQUECY MULTIPLE
'                 |      | 0001B| KSR
'                 |      | 0001B| EG TYPE
'                 |      | 0001B| VIBRATO
'                 |      | 0001B| AMPLITUDE MODULATION
'                 |      |      |
'                 |      | 0006B| TOTAL LEVEL
'                 |      | 0002B| SCALING LEVEL
'                 |      |      |
'                 |      | 0004B| DECAY RATE
'                 |      | 0004B| ATTACK RATE
'                 |      |      |
'                 |      | 0004B| RELEASE RATE
'                 |      | 0004B| SUBSTAIN LEVEL
'                 |      |      |
'                 |      | 0001B| ALGORITHM
'                 |      | 0003B| CONNECTION
'                 |      |      |
'                 |      | 0002B| WAVEFORM SELECT
'                 |      | 0004B| MODULATOR FREQUECY MULTIPLE
'                 |      | 0001B| KSR
'                 |      | 0001B| EG TYPE
'                 |      | 0001B| VIBRATO
'                 |      | 0001B| AMPLITUDE MODULATION
'2 OPPERATOR-----|------|------|
'                 |      | 0006B| TOTAL LEVEL
'                 |      | 0002B| SCALING LEVEL
'                 |      |      |
'                 |      | 0004B| DECAY RATE
'                 |      | 0004B| ATTACK RATE
'                 |      |      |
'                 |      | 0004B| RELEASE RATE
'                 |      | 0004B| SUBSTAIN LEVEL
'                 |      |      |
'                 |      | 0001B| ALGORITHM
'                 |      | 0003B| CONNECTION
'                 |      |      |
'                 |      | 0002B| WAVEFORM SELECT
' OTHER BYTES UNUSED     |      |
'-------------------------
'PATTERN          | ???? | ????=NUMBER OF VOICES * NUMBER OF PATTERN * 256 -> MAX=65536
'-------------------------
