uses A2replay;

{$IFDEF FPC}
    {$ASMMODE INTEL}
{$ENDIF}

var
  f: File;
  buf: Pointer;
  temp,factor,fkey: Word;

function keypressed: Boolean; assembler;
asm
        mov     ah,01h
        int     16h
        mov     al,TRUE
        jnz     @@1
        mov     al,FALSE
@@1:
end;

procedure delay(ms: Word); assembler;
asm
        mov     ax,1000
        mul     ms
        mov     cx,dx
        mov     dx,ax
        mov     ah,86h
        int     15h
end;

procedure fade_out;

var
  temp: Byte;

begin
  For temp := 63 downto 0 do
    begin
      set_overall_volume(temp);
      delay(temp DIV 2); // don't forget to use kinda logarithmic delay :)
      Write('Order ',current_order:3,', ',
            'Pattern ',current_pattern:3,', ',
            'Row ',current_line:3,' -- fading out (',100-Round(100/63*temp),'%)',#13);
    end;
end;

begin
  If (ParamCount = 0) then
    begin
      WriteLn('syntax: ',ParamStr(0),' a2t_module_name');
      EXIT;
    end;

  GetMem(buf,65535);
  Assign(f,ParamStr(1));
  Reset(f,1);
  BlockRead(f,buf^,65535,temp);
  Close(f);

  opl3port := $388; // YAMAHA YMF262/OPL3 base address
  start_playing(buf^,temp); // play buffer pointer is BUF^
                            // size of data is TEMP

  If (error_code <> 0) then
    begin
      Case error_code of
        -1: WriteLn('Incorrect module data!');
        else
            WriteLn('Insufficient memory!');
      end;
      FreeMem(buf,65535);
      EXIT;
    end;

  WriteLn(' iRQ MODE');
  WriteLn('  Press ESC to quit,'+#13#10+
          '  any other key to continue in POLL MODE.');
  Repeat
    Write('Order ',current_order:3,', ',
          'Pattern ',current_pattern:3,', ',
          'Row ',current_line:3,#13);
  until keypressed;

  asm
        mov     ah,0
        int     16h
        mov     fkey,ax
  end;

  If (fkey <> $011b) then
    begin
      irq_mode := FALSE; // disable IRQ mode -> POLL mode
      Write(' ':75);
      WriteLn;
      WriteLn(' POLL MODE');
      WriteLn('  Press a key to quit.');

      Repeat
        Write('Order ',current_order:3,', ',
              'Pattern ',current_pattern:3,', ',
              'Row ',current_line:3,#13);

  // that's a shitty way to do timing-- better use your own routines :)
        factor := 1;
        While (factor <= macro_speedup) do
          begin
            delay(Round(1000/(tempo*macro_speedup)));
            macro_poll_proc; // execute polling proc for macros
            Inc(factor);
          end;
        poll_proc; // execute polling proc
      until keypressed;
    end;

  If irq_mode then fade_out; // fade out if using IRQ
  stop_playing;
  MEMW[0:$041c] := MEMW[0:$041a];
  Write(' ':75);
  WriteLn;
  FreeMem(buf,65535);
end.