/*
** Winamp input plug-in
** Copyright (c) 1998, Justin Frankel/Nullsoft Inc.
*/

#include <windows.h>
#include <windowsx.h>
#include <mmreg.h>
#include <msacm.h>
#include <math.h>

#include "winamp_sym_In2.h"
#include "winamp_sym_API.h"
#include "wsr_player.h"

static In_Module mod;

char lastfn[MAX_PATH];
short sample_buffer[576*2*2];
char SongTitle[256] = "\0";

int paused = 0;
int killDecodeThread = 0;
HANDLE thread_handle = INVALID_HANDLE_VALUE;
void *lpWndProcOld = NULL;
int SongNo = 0;
int ChgSong = 0;
int SongTime = 5*60*1000;
int LoopTime = 0;
int FadeTime = 5*1000;
int TotalTime = (5*60 + 5)*1000;
int SeekTime = -1;
int EndWinamp = 0;

int nCh = 2;
int Bps = 16;

DWORD WINAPI __stdcall PlayThread(void *b);

// avoid CRT. Evil. Big. Bloated.
BOOL WINAPI DllMain(HINSTANCE hInst, ULONG ul_reason_for_call, LPVOID lpReserved)
{
	return TRUE;
}

// Winamp Preferences
void config(HWND hwndParent)
{
	MessageBox(hwndParent,"No configuration.","Configuration", MB_OK);
}

void about(HWND hwndParent)
{
	MessageBox(hwndParent,"WSR Sound Player","About WSR Sound Player", MB_OK);
}

// One time Initialize
// ex.) Load configuration
void init()
{
}

// One time shutdown
// ex.) Save configuration
void quit()
{
	Close_WSR();
}


LRESULT CALLBACK WndProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	if(message == WM_COMMAND)
	{
		int cmd = GET_WM_COMMAND_ID(wParam, lParam);
		if(cmd == WINAMP_BUTTON1)
		{
			SongNo--;
			if(SongNo<0) SongNo = 0;
			ChgSong = 1;

			wParam = WINAMP_BUTTON2;
		}
		if(cmd == WINAMP_BUTTON1_SHIFT)
		{
			SongNo -= 10;
			if(SongNo<0) SongNo = 0;
			ChgSong = 1;

			wParam = WINAMP_BUTTON2;
		}
		if(cmd == WINAMP_BUTTON5)
		{
			SongNo++;
			if(SongNo>255) SongNo = 255;
			ChgSong = 1;

			wParam = WINAMP_BUTTON2;
		}
		if(cmd == WINAMP_BUTTON5_SHIFT)
		{
			SongNo += 10;
			if(SongNo>255) SongNo = 255;
			ChgSong = 1;

			wParam = WINAMP_BUTTON2;
		}
	}

	if(message == WM_CLOSE || message == WM_DESTROY)
	{
		EndWinamp = 1;
		return 0;
	}

	return CallWindowProc(lpWndProcOld,hwnd,message,wParam,lParam);
}


// ΉĂt@CH
int isourfile(char *fn)
{
	char *p;
	for(p = fn; *p != '\0'; p++)
	{
		if(p[0] == ':' && p[1] == ':' &&
		  (p[2]|0x20) == 'w' && (p[3]|0x20) == 's' && (p[4]|0x20) == 'r')
			return p + 5 - fn;
	}

	return 0;
}


// ꎞ~
void pause()
{
	paused = 1;
	mod.outMod->Pause(1);
}

// ꎞ~
void unpause()
{
	paused = 0;
	mod.outMod->Pause(0);
}

// Aꎞ~H
int ispaused()
{
	return paused;
}

#define NEXT_BLOCK \
while (*s != ',' && *s != '\0') s++; \
if (*s == ',') s++

#define SKIP_SPACE \
while (*s == ' ') s++

int GetNumber(char **strad)
{
	char *s = strad[0];
	int n = 0;

	if (*s == '$')
	{
		/* Hex */
		s++;
		while ((*s >= '0' && *s <= '9') || ((*s|0x20) >= 'a' && (*s|0x20) <= 'f'))
		{
			n <<= 4;
			if (*s >= '0' && *s <= '9')
				n += *s++ - '0';				/* 0 ... 9 */
			else
				n += (*s++|0x20) - 'a' + 10;	/* a ... f */
		}
	}
	else
	{
		/* Dec */
		while (*s >= '0' && *s <= '9')
		{
			n *= 10;
			n += *s++ - '0';
		}
	}

	strad[0] = s;
	return (n);
}

int GetTime(char **strad)
{
	char *s = strad[0];
	int n = 0, n2 = 0, n3 = 0;

	while ((*s >= '0' && *s <= '9') || *s == ':')
	{
		if(*s == ':')
		{
			/* ':' */
			n2 = n2*60 + n;
			n = 0;
			s++;
		}
		else
		{
			/* 0 ... 9 */
			n *= 10;
			n += *s++ - '0';
		}
	}
	if(*s == '.')
	{
		s++;
		while (*s >= '0' && *s <= '9')
		{
			n3 *= 10;
			n3 += *s++ - '0';
		}
	}

	strad[0] = s;
	return ((n2*60 + n)*1000) + n3;
}

// ĐJn
int play(char *fn)
{
	int maxlatency;
	int thread_id;
	int ad;

	if(ad = isourfile(fn))
	{
		char *s = fn+ad;
		int n;

		strcpy(lastfn, fn);
		lastfn[ad-5] = '\0';

		// Song Number
		NEXT_BLOCK;
		SKIP_SPACE;
		SongNo = GetNumber(&s);

		// get Song Title
		NEXT_BLOCK;
		n = 0;
		while (*s != ',' && *s != '\0')
		{
			SongTitle[n++] = *s++;
		}
		SongTitle[n] = '\0';

		// get Time
		NEXT_BLOCK;
		SKIP_SPACE;
		if(*s != '\0')
		{
			SongTime = GetTime(&s);
		}
		else
		{
			SongTime = 5*60*1000;
		}

		// get Loop Time
		NEXT_BLOCK;
		SKIP_SPACE;
		if(*s != '\0')
		{
			LoopTime = GetTime(&s);
			if(*s == '-')
			{
				s++;
				LoopTime = SongTime - LoopTime;
			}
		}
		else
		{
			LoopTime = 0;
		}

		// get Fadeout Time
		NEXT_BLOCK;
		SKIP_SPACE;
		if(*s != '\0')
		{
			FadeTime = GetTime(&s);
		}
		else
		{
			FadeTime = 5*1000;
		}

		TotalTime = SongTime + LoopTime + FadeTime;
		ChgSong = 0;

		Load_WSR(lastfn);
	}
	else
	{
		char *p;
		int i;

		if (ChgSong == 0)
		{
			for (i=0; i<MAX_PATH; i++)
			{
				if (fn[i] != lastfn[i]) break;
				if (fn[i] == NULL)
				{
					ChgSong = 1;
					SongNo++;
					if (SongNo>255) SongNo = 255;
					break;
				}
			}
		}

		strcpy(lastfn, fn);
		Load_WSR(lastfn);

		if (!ChgSong) SongNo = Get_FirstSong();
		else ChgSong = 0;

		p = strrchr(fn, '\\');
		if(p) p++;
		else p = fn;

		wsprintf(SongTitle, "%s: $%02x", p, SongNo);

		SongTime = 5*60*1000;
		LoopTime = 0;
		FadeTime = 5*1000;
		TotalTime = SongTime + FadeTime;

		if(lpWndProcOld == NULL)
		{
			lpWndProcOld = (void *) GetWindowLong(mod.hMainWindow, GWL_WNDPROC);
			SetWindowLong(mod.hMainWindow, GWL_WNDPROC, WndProc);
		}
	}

	paused = 0;
	SeekTime = -1;
	memset(sample_buffer, 0, sizeof(sample_buffer));

	maxlatency = mod.outMod->Open(SampleRate, nCh, Bps, -1, -1);
	if (maxlatency < 0)
	{
		return 1;
	}
	mod.SetInfo(0, SampleRate/1000, nCh, 1);
	mod.SAVSAInit(maxlatency, SampleRate);
	mod.VSASetInfo(SampleRate, nCh);
	mod.outMod->SetVolume(-666);

	EndWinamp = 0;
	killDecodeThread = 0;
	thread_handle = (HANDLE) CreateThread(NULL, 0, (LPTHREAD_START_ROUTINE) PlayThread, (void *) &killDecodeThread, 0, (LPDWORD)&thread_id);

	return 0; 
}

// ~
void stop()
{
	if (thread_handle != INVALID_HANDLE_VALUE)
	{
		killDecodeThread = 1;
		if (WaitForSingleObject(thread_handle, INFINITE) == WAIT_TIMEOUT)
		{
			MessageBox(mod.hMainWindow,"error asking thread to die!\n","error killing decode thread",0);
			TerminateThread(thread_handle,0);
		}
		CloseHandle(thread_handle);
		thread_handle = INVALID_HANDLE_VALUE;

		if(lpWndProcOld != NULL)
		{
			SetWindowLong(mod.hMainWindow, GWL_WNDPROC, lpWndProcOld);
			lpWndProcOld = NULL;
		}
	}

	mod.outMod->Close();
	mod.SAVSADeInit();

	Close_WSR();
}


int getlength()
{
	return TotalTime;
}

int getoutputtime()
{
	return mod.outMod->GetOutputTime();
}

void setoutputtime(int time_in_ms)
{
	SeekTime = time_in_ms;
}

void setvolume(int volume)
{
	mod.outMod->SetVolume(volume);
}

void setpan(int pan)
{
	mod.outMod->SetPan(pan);
}

int infoDlg(char *fn, HWND hwnd)
{
	return 0;
}

void getfileinfo(char *filename, char *title, int *length_in_ms)
{
	int ad;

	if (title)
	{
		if(ad = isourfile(filename))
		{
			char *s = filename+ad;
			int n;

			NEXT_BLOCK;
			NEXT_BLOCK;		//skip SongNo
			n = 0;
			while (*s != ',' && *s != '\0')
			{
				title[n++] = *s++;
			}
			title[n] = '\0';
		}
		else
		{
			strcpy(title, SongTitle);
		}
	}
	if (length_in_ms)
	{
		if(ad = isourfile(filename))
		{
			char *s = filename+ad;

			NEXT_BLOCK;
			NEXT_BLOCK;		//skip SongNo
			NEXT_BLOCK;		//skip SongTitle
			SKIP_SPACE;
			if(*s != '\0')
			{
				*length_in_ms = GetTime(&s);
			}
			else
			{
				*length_in_ms = 5*60*1000 + 5*1000;
			}
		}
		else
		{
			*length_in_ms = TotalTime;
		}
	}
}

void eq_set(int on, char data[10], int preamp)
{
}

DWORD WINAPI __stdcall PlayThread(void *b)
{
	int PlayCount = 0;
	int FadeCount;
	int EndPlay = 0;
	int VolDown = 256;

	memset(sample_buffer, 0, sizeof(sample_buffer));
	mod.outMod->Flush(0);

	Reset_WSR(SongNo);

	while (!*((int *)b) && !EndPlay && !EndWinamp)
	{
		if (mod.outMod->CanWrite() >= ((576*nCh*(Bps/8))<<(mod.dsp_isactive()?1:0)))
		{
			int l = 576*nCh*(Bps/8), x = 576;
			int i, t, v;

			// CPU Clock: 3072000/76.5 = 40157
			// Sample:    44100/76.5   = 576
			// 576Tvɍ쐬̂́AWinamp PlugiñTvȂĂ̂ŁB
			// ȊO̐łǂ񂾂낤ǁB

			Update_WSR(40157, 576);

			// Fadeout
			FadeCount = PlayCount - ((TotalTime-FadeTime)*441/10);		//44100/1000
			if (FadeCount>0)
			{
				if (FadeTime)
					VolDown = 256 - (256*FadeCount/(FadeTime*441/10));	//44100/1000
				else
					VolDown = 0;
				if (VolDown < 0) VolDown = 0;
			}
			PlayCount += x;
			if (VolDown < 256)
			{
				for(i=0; i<x; i++)
				{
					v = sample_buffer[i*2];
					v = (v * VolDown) / 256;
					sample_buffer[i*2] = v;
					v = sample_buffer[i*2+1];
					v = (v * VolDown) / 256;
					sample_buffer[i*2+1] = v;
				}
			}

			t = mod.outMod->GetWrittenTime();
			mod.SAAddPCMData((char *)sample_buffer, nCh, Bps, t);
			mod.VSAAddPCMData((char *)sample_buffer, nCh, Bps, t);

			l = mod.dsp_dosamples(sample_buffer, l/nCh/(Bps/8), Bps, nCh, SampleRate)*(nCh*(Bps/8));
			mod.outMod->Write((char *)sample_buffer,l);

			if(mod.outMod->GetOutputTime() > TotalTime)
			{
				EndPlay = 1;
			}
		}
		else Sleep(30);
	}

	if (!*((int *)b))
		PostMessage(mod.hMainWindow, WM_WA_MPEG_EOF, 0, 0);

	if (EndWinamp)
	{
		if (lpWndProcOld != NULL)
		{
			PostMessage(mod.hMainWindow, WM_COMMAND, WINAMP_BUTTON4, 0);
		}

		PostMessage(mod.hMainWindow, WM_CLOSE, 0, 0);
	}

	return 0;
}

static In_Module mod = 
{
	IN_VER,
	"WSR Sound Player (x86)",
	0,	// hMainWindow  (filled in by winamp)
	0,	// hDllInstance (filled in by winamp)
	"WSR\0WSR file (*.WSR)\0",
	0,	// is_seekable
	1,	// uses output
	config,
	about,
	init,
	quit,
	getfileinfo,
	infoDlg,
	isourfile,
	play,
	pause,
	unpause,
	ispaused,
	stop,

	getlength,
	getoutputtime,
	setoutputtime,

	setvolume,
	setpan,

	0,0,0,0,0,0,0,0,0, // vis stuff


	0,0, // dsp

	eq_set,

	NULL,		// setinfo

	0 // out_mod

};

__declspec(dllexport) In_Module *winampGetInModule2()
{
	return &mod;
}

