;dsp context
struc DSP

;Config
.DSPRAM:	resd	1	;Pointer to DSPRAM
.DSPRAM_L:	resd	1	;Length of DSPRAM
.RBP:		resd	1	;Ring buf pointer
.RBL:		resd	1	;Delay ram (Ring buffer) size in words

;context
.COEF:		resw	64	;16 bit signed
.MADRS:		resw	32	;offsets (in words), 16 bit
.MPRO:		resw	128*4	;128 steps 64 bit
.TEMP:		resd	128	;TEMP regs,24 bit signed
.MEMS:		resd	32	;MEMS regs,24 bit signed
.DEC:		resd	1

;input
.MIXS:		resd	16	;MIXS, 24 bit signed
.EXTS:		resw	2	;External inputs (CDDA)    16 bit signed

;output
.EFREG:		resw	16	;EFREG, 16 bit signed

.Stopped:	resd	1
.LastStep:	resd	1

endstruc

%define DSP_DSPRAM [ebp + DSP.DSPRAM]
%define DSP_RBP [ebp + DSP.RBP]
%define DSP_RBL [ebp + DSP.RBL]
%define DSP_COEF(i) [ebp + DSP.COEF + i * 2]
%define DSP_MADRS(i) [ebp + DSP.MADRS + i * 2]
%define DSP_TEMP(i) [ebp + DSP.TEMP + i * 4]
%define DSP_MEMS(i) [ebp + DSP.MEMS + i * 4]
%define DSP_DEC [ebp + DSP.DEC]
%define DSP_MIXS(i) [ebp + DSP.MIXS + i * 4]
%define DSP_EFREG(i) [ebp + DSP.EFREG + i * 2]

;stack frame
struc SF
.ACC:		resd	1
.MEMVAL:	resd	1
.FRC_REG:	resd	1
.Y_REG:		resd	1
.ADRS_REG:	resd	1
;.SHIFTED:	resd	1
;.X:			resd	1
;.Y:			resd	1
;.B:			resd	1
;.INPUT:		resd	1
;.ADDR:		resd	1
.SIZE:
endstruc

%define _ACC		dword [esp + SF.ACC]
%define _SHIFTED	esi;dword [esp + SF.SHIFTED]
%define _X		edx;dword [esp + SF.X]
%define _Y		edi;dword [esp + SF.Y]
%define _B		ecx;dword [esp + SF.B]
%define _INPUT		ebx;dword [esp + SF.INPUT]
%define _MEMVAL		dword [esp + SF.MEMVAL]
%define _FRC_REG	dword [esp + SF.FRC_REG]
%define _Y_REG		dword [esp + SF.Y_REG]
%define _ADDR		edx;dword [esp + SF.ADDR]
%define _ADRS_REG	dword [esp + SF.ADRS_REG]

section .text

	global	_DSPX86_CHECK_CMOV
_DSPX86_CHECK_CMOV:
	push	ebx
	push	ecx
	push	edx
	xor	eax,eax
	pushfd
	pop	edx
	mov	ecx,edx
	xor	edx,0x200000
	push	edx
	popfd
	pushfd
	pop	edx
	xor	edx,ecx
	setnz	al
	or	eax,eax
	jz	short .skip

	xor	edx,edx
	cpuid
	mov	eax,edx
	shr	eax,15
	and	eax,1

.skip:
	pop	edx
	pop	ecx
	pop	ebx
	ret

section .rodata

		align	4
PPACK		dd	PACK
PUNPACKC	dd	UNPACKC
PUNPACK		dd	UNPACK

section .text

	global	_DSPX86_PACK
	global	_DSPX86_UNPACKC
	global	_DSPX86_UNPACK

_DSPX86_PACK:
	mov	eax,[esp+4]
	jmp	[PPACK]
_DSPX86_UNPACKC:
	mov	eax,[esp+4]
	jmp	[PUNPACKC]
_DSPX86_UNPACK:
	mov	eax,[esp+4]
	jmp	[PUNPACK]
PACK:
	push	ebx
	push	ecx
	push	edx

	;sign
	mov	ebx,eax
	shr	ebx,19
	and	ebx,0x10

	;temp
	mov	edx,eax
	shl	edx,1
	xor	edx,eax
	shl	edx,8
	or	edx,0x00080000
	bsr	ecx,edx
	xor	ecx,0x1f
	or	ebx,ecx
	cmp	ecx,12
	sbb	edx,edx	;0-11:edx=-1 12:edx=0
	sub	ecx,edx	;0-11:ecx=ecx+1 12:ecx=12
	and	edx,0xffc00000	;0-11:edx=0xffc00000 12:edx=0
	sub	ecx,1	;0-11:ecx=ecx-1 12:ecx=11
	not	edx	;0-11:edx=0x003fffff 12:edx=0xffffffff
	shl	eax,cl
	and	eax,edx
	shr	eax,11
	and	eax,0x7ff
	shl	ebx,11
	or	eax,ebx
	pop	edx
	pop	ecx
	pop	ebx

	ret

UNPACKC:
	push	ebx
	push	ecx
	push	edx

	and	eax,0xffff

	mov	ebx,eax
	and	ebx,0x8000

	mov	ecx,eax
	shr	ecx,11
	and	ecx,0xf

	mov	edx,eax
	and	edx,0x7ff
	shl	edx,11

	mov	eax,ebx
	shl	eax,8
	or	edx,eax

	mov	eax,ebx
	shl	eax,7
	or	eax,edx
	mov	edx,0x00400000

	mov	ebx,11
	cmp	ecx,ebx
	cmova	ecx,ebx
	mov	ebx,0x00000000
	cmova	edx,ebx
	xor	eax,edx

	and	eax,0x00ffffff
	xor	eax,0x00800000
	sub	eax,0x00800000
	sar	eax,cl

	pop	edx
	pop	ecx
	pop	ebx
	ret

UNPACK:
	push	ebx
	push	ecx
	push	edx

	and	eax,0xffff

	mov	ebx,eax
	and	ebx,0x8000

	mov	ecx,eax
	shr	ecx,11
	and	ecx,0xf

	mov	edx,eax
	and	edx,0x7ff
	shl	edx,11

	mov	eax,ebx
	shl	eax,8
	or	edx,eax

	mov	eax,ebx
	xor	eax,0x8000
	shl	eax,7

	mov	ebx,11
	cmp	ecx,ebx
	jbe	short .skip
	mov	ecx,ebx
	xor	eax,0x00400000
.skip:
	or	eax,edx
	
	and	eax,0x00ffffff
	xor	eax,0x00800000
	sub	eax,0x00800000
	sar	eax,cl

	pop	edx
	pop	ecx
	pop	ebx
	ret

%macro	DSPX86	1
section .rodata
align	4
	global	_DSPX86_S_%1
_DSPX86_S_%1:
	dd		_DSPX86_C_%1.END-_DSPX86_C_%1
section .text
	global	_DSPX86_C_%1
_DSPX86_C_%1:
%endmacro

%macro	DSPX86P	1
section .rodata
align	4
	global	_DSPX86_S_%1
_DSPX86_S_%1:
	dd		_DSPX86_C_%1.END-_DSPX86_C_%1
	global	_DSPX86_P_%1
_DSPX86_P_%1:
	dd		_DSPX86_C_%1.PTR-_DSPX86_C_%1
section .text
	global	_DSPX86_C_%1
_DSPX86_C_%1:
%endmacro

DSPX86	ENTRY
	push	ebp
	mov	ebp,[esp + 8]	; arg1
	push	ebx
	push	esi
	push	edi
	pushf
	cld
	sub	esp,SF.SIZE

	xor	eax,eax
	lea	edi,DSP_EFREG(0)
	mov	ecx,8
	rep stosd

	mov	_ACC,eax
	mov	_SHIFTED,eax
	mov	_X,eax
	mov	_Y,eax
	mov	_B,eax
	mov	_INPUT,eax
	mov	_MEMVAL,eax
	mov	_FRC_REG,eax
	mov	_Y_REG,eax
	mov	_ADDR,eax
	mov	_ADRS_REG,eax
.END:

DSPX86	EXIT
	mov	eax,dword DSP_DEC
	sub	eax,1
	mov	dword DSP_DEC,eax
	xor	eax,eax
	lea	edi,DSP_MIXS(4 * 0)
	mov	ecx,16
	rep stosd

	add	esp,SF.SIZE
	popf
	pop	edi
	pop	esi
	pop	ebx
	pop	ebp
	ret
.END:

DSPX86P	IN_0
	mov	eax,strict dword 0
.PTR	EQU $-4
	mov	eax,DSP_MEMS(eax)
.END:

DSPX86P	IN_1
	mov	eax,strict dword 0
.PTR	EQU $-4
	mov	eax,DSP_MIXS(eax)
	shl	eax,4
.END:

DSPX86	IN_2
	xor	eax,eax
.END:

DSPX86	IN_3
	mov	eax,_INPUT
.END:

DSPX86	IN_4
	and	eax,0x00ffffff
	xor	eax,0x00800000
	sub	eax,0x00800000
	mov	_INPUT,eax
.END:

DSPX86P	IW_0
	mov	edx,strict dword 0
.PTR	EQU $-4
	mov	eax,_MEMVAL
	mov	DSP_MEMS(edx),eax
.END:

DSPX86	IW_1
	mov	_INPUT,eax
.END:

DSPX86	OB_0
	mov	_B,_ACC
.END:

DSPX86P	OB_1
	mov	eax,strict dword 0
.PTR	EQU $-4
;	add	eax,DSP_DEC
;	and	eax,0x7f
	mov	_B,DSP_TEMP(eax)
	and	_B,0x00ffffff
	xor	_B,0x00800000
	sub	_B,0x00800000
.END:

DSPX86P	OB_1O
	mov	eax,strict dword 0
.PTR	EQU $-4
	add	eax,DSP_DEC
	and	eax,0x7f
	mov	_B,DSP_TEMP(eax)
	and	_B,0x00ffffff
	xor	_B,0x00800000
	sub	_B,0x00800000
.END:

DSPX86	OB_2
	neg	_B
.END:

DSPX86	OB_3
	xor	_B,_B
.END:

DSPX86	OX_0
	mov	_X,_INPUT
.END:

DSPX86P	OX_1
	mov	eax,strict dword 0
.PTR	EQU $-4
;	add	eax,DSP_DEC
;	and	eax,0x7f
	mov	_X,DSP_TEMP(eax)
	and	_X,0x00ffffff
	xor	_X,0x00800000
	sub	_X,0x00800000
.END:

DSPX86P	OX_1O
	mov	eax,strict dword 0
.PTR	EQU $-4
	add	eax,DSP_DEC
	and	eax,0x7f
	mov	_X,DSP_TEMP(eax)
	and	_X,0x00ffffff
	xor	_X,0x00800000
	sub	_X,0x00800000
.END:

DSPX86	OY_0
	mov	_Y,_FRC_REG
.END:

DSPX86P	OY_1
	mov	eax,strict dword 0
.PTR	EQU $-4
	movsx	_Y,word DSP_COEF(eax)
	sar	_Y,3
.END:

DSPX86	OY_2
	mov	_Y,_Y_REG
	sar	_Y,11
	and	_Y,0x1fff
.END:

DSPX86	OY_3
	mov	_Y,_Y_REG
	sar	_Y,4
	and	_Y,0xfff
.END:

DSPX86	OY_4
	mov	_Y_REG,_INPUT
.END:

DSPX86	OS_0
	mov	eax,_ACC
	cmp	eax,0x007fffff
	jle	short .skip1
	mov	eax,0x007fffff
.skip1:
	cmp	eax,0xff800000
	jge	short .skip2
	mov	eax,0xff800000
.skip2:
	mov	_SHIFTED,eax
.END:

DSPX86	OS_0C
	mov	_SHIFTED,edx
	mov	eax,_ACC
	mov	edx,0x007fffff
	cmp	eax,edx
	cmovg	eax,edx
	not	edx
	cmp	eax,edx
	cmovl	eax,edx
	mov	edx,_SHIFTED
	mov	_SHIFTED,eax
.END:

DSPX86	OS_1
	mov	eax,_ACC
	add	eax,eax
	cmp	eax,0x007fffff
	jle	short .skip1
	mov	eax,0x007fffff
.skip1:
	cmp	eax,0xff800000
	jge	short .skip2
	mov	eax,0xff800000
.skip2:
	mov	_SHIFTED,eax
.END:

DSPX86	OS_1C
	mov	_SHIFTED,edx
	mov	eax,_ACC
	add	eax,eax
	mov	edx,0x007fffff
	cmp	eax,edx
	cmovg	eax,edx
	not	edx
	cmp	eax,edx
	cmovl	eax,edx
	mov	edx,_SHIFTED
	mov	_SHIFTED,eax
.END:

DSPX86	OS_2
	mov	_SHIFTED,_ACC
	add	_SHIFTED,_SHIFTED
	and	_SHIFTED,0x00ffffff
	xor	_SHIFTED,0x00800000
	sub	_SHIFTED,0x00800000
.END:

DSPX86	OS_3
	mov	_SHIFTED,_ACC
	and	_SHIFTED,0x00ffffff
	xor	_SHIFTED,0x00800000
	sub	_SHIFTED,0x00800000
.END:

DSPX86	OA_0
	shl	_Y,19
	mov	eax,_Y
%ifidni _X,edx
%else
	mov	edx,_X
%endif
	add	edx,edx
	imul	edx
	add	edx,_B
;	and	edx,0x03ffffff
;	xor	edx,0x02000000
;	sub	edx,0x02000000
	mov	_ACC,edx
.END:

DSPX86P	TW_0
	mov	eax,strict dword 0
.PTR	EQU $-4
;	add	eax,DSP_DEC
;	and	eax,0x7f
	mov	DSP_TEMP(eax),_SHIFTED
.END:

DSPX86P	TW_0O
	mov	eax,strict dword 0
.PTR	EQU $-4
	add	eax,DSP_DEC
	and	eax,0x7f
	mov	DSP_TEMP(eax),_SHIFTED
.END:

DSPX86	OF_0
	mov	eax,_SHIFTED
	and	eax,0x0fff
	mov	_FRC_REG,eax
.END:

DSPX86	OF_1
	mov	eax,_SHIFTED
	sar	eax,11
	and	eax,0x1fff
	mov	_FRC_REG,eax
.END:

DSPX86P	OM_0
	mov	eax,strict dword 0
.PTR	EQU $-4
	movzx	_ADDR,word DSP_MADRS(eax)
.END:

DSPX86	OM_1
	add	_ADDR,DSP_DEC
.END:

DSPX86	OM_2
	mov	eax,_ADRS_REG
	and	eax,0xfff
	add	_ADDR,eax
.END:

DSPX86	OM_3
	add	_ADDR,1
.END:

DSPX86	OM_4
	mov	eax,DSP_RBL
	sub	eax,1
	and	_ADDR,eax
.END:

DSPX86	OM_5
	and	_ADDR,0xffff
.END:

DSPX86	OM_6
	mov	eax,DSP_RBP
	shl	eax,12
	add	_ADDR,eax
.END:

DSPX86	OM_6AICA
	mov	eax,DSP_RBP
	shl	eax,10
	add	_ADDR,eax
.END:

DSPX86	OM_7
	mov	edi,DSP_DSPRAM
	movzx	eax,word [edi + _ADDR*2]
	shl	eax,8
	mov	_MEMVAL,eax
.END:

DSPX86	OM_8
	mov	edi,DSP_DSPRAM
	movzx	eax,word [edi + _ADDR*2]
	call	[PUNPACK]
	mov	_MEMVAL,eax
.END:

DSPX86	OM_8C
	mov	edi,DSP_DSPRAM
	movzx	eax,word [edi + _ADDR*2]
	call	[PUNPACKC]
	mov	_MEMVAL,eax
.END:

DSPX86	OM_9
	mov	edi,DSP_DSPRAM
	mov	eax,_SHIFTED
	sar	eax,8
	mov	word [edi + _ADDR*2],ax
;	;Core-MA stall with LCP(prefix 66h)
;	mov	byte [edi + _ADDR*2 + 0],al
;	mov	byte [edi + _ADDR*2 + 1],ah
.END:

DSPX86	OM_A
	mov	edi,DSP_DSPRAM
	mov	eax,_SHIFTED
	call	[PPACK]
	mov	word [edi + _ADDR*2],ax
;	;Core-MA stall with LCP(prefix 66h)
;	mov	byte [edi + _ADDR*2 + 0],al
;	mov	byte [edi + _ADDR*2 + 1],ah
.END:

DSPX86	OR_0
	mov	eax,_SHIFTED
	sar	eax,12
	and	eax,0xfff
	mov	_ADRS_REG,eax
.END:

DSPX86	OR_1
	mov	eax,_INPUT
	sar	eax,16
	mov	_ADRS_REG,eax
.END:

DSPX86P	EW_0
	mov	edx,strict dword 0
.PTR	EQU $-4
	mov	eax,_SHIFTED
	sar	eax,8
	add	word DSP_EFREG(edx),ax
;	movsx	edi,word DSP_EFREG(edx)
;	add	eax,edi
;	mov	word DSP_EFREG(edx),ax
;	;Core-MA stall with LCP(prefix 66h)
;	mov byte DSP_EFREG(0 + edx),al
;	mov byte DSP_EFREG(1 + edx),ah
.END:

