#define HES_PLAYER_API __declspec(dllexport)


//#include <stdio.h>
//#include <stdlib.h>
//#include <string.h>

#include "hes_player.h"
#include "Ootake/MainBoard.h"
#include "Ootake/CPU.h"
//#include "Ootake/Cartridge.h"


#define HES_HEADER_MAGIC 0x4D534548
#define HES_HEADER_SUB	0x41544144
//1024LoCg Mamiyahesspec.txtɂƂԂ񂱂ŗǂ?
#define OOTAKE_HES_MAX_SIZE 0x100000


static Uint8* _pHesData = 0;
static Uint32 _HesDataSize = 0;
static Uint32 _ChannelMute = 0;


struct HES_Info
{
	Uint32	init_address;
	Uint8	init_mpr[8];
	Uint32	data_size;
	Uint32	data_load_address;
	Uint32	player_rom_address;	//refferd to nezplug++. thanks Mamiya, RuRuRu, and OffGao. 
	Uint8	player_rom[0x10];
	bool	cosmic_fantasy;
	static const char* const cosmic_fantasy_magic;

	void clear()
	{
		init_address = 0;
		data_size = 0;
		data_load_address = 0x20;
		player_rom_address = 0x1ff0;
		memset(init_mpr, 0x00, 8);
		memset(player_rom, 0x00, 0x10);
		cosmic_fantasy = false;
	}

	HES_Info()
	{
		clear();
	}
};

const char* const HES_Info::cosmic_fantasy_magic = "Cosmic Fantasy - Bouken Shounen Yuu";


static struct HES_Info hes_info;

//refferd to viogsf's drvimpl.cpp. thanks the author.
static struct
{
	Uint8 * ptr;
	Uint32 len;
	Uint32 fil;
	Uint32 cur;
}
buffer =
{
	0, 0, 0, 0
};

static Uint16 ReadLE16(const Uint8* pData)
{
	return (pData[0x01] << 8) | (pData[0x00] << 0);
}

static Uint32 ReadLE32(const Uint8* pData)
{
	return	(pData[0x03] << 24) | (pData[0x02] << 16) |	(pData[0x01] << 8) | (pData[0x00] << 0);
}

//MainBoard.cppĂ΂
Uint32 HES_Load(Uint8** ppRom, Uint32* pRomSize)
{
	if (!_pHesData || _HesDataSize < 0x20)
		goto LOAD_ERROR;

	if (HES_HEADER_MAGIC == ReadLE32(_pHesData))	{//'HESM'
		
	}
	else if (_HesDataSize > 0x220 && HES_HEADER_MAGIC == ReadLE32(_pHesData + 0x200))	{//512 byte header
		_pHesData = _pHesData + 0x200;
		_HesDataSize -= 0x200;
	}
	else
		goto LOAD_ERROR;

	if (HES_HEADER_SUB != ReadLE32(_pHesData + 0x10))	//'DATA'
		goto LOAD_ERROR;

	hes_info.init_address = ReadLE16(_pHesData + 6);
	for (unsigned i = 0; i < 8; i++)
		hes_info.init_mpr[i] = _pHesData[8 + i];
	hes_info.data_size = ReadLE32(_pHesData + 0x14);
	if (hes_info.data_size > _HesDataSize - 0x20)
	{
		hes_info.data_size = _HesDataSize - 0x20;
	}

	hes_info.data_load_address = ReadLE32(_pHesData + 0x18);

	if (hes_info.data_size > OOTAKE_HES_MAX_SIZE || 		
		hes_info.data_load_address + hes_info.data_size >  OOTAKE_HES_MAX_SIZE ||
		hes_info.init_address > OOTAKE_HES_MAX_SIZE
		) 
	{
		goto LOAD_ERROR;
	}

	//refferd to nezplug++. thanks Mamiya, RuRuRu, and OffGao.
	hes_info.player_rom[0x00] = 0x20;	/* JSR */
	hes_info.player_rom[0x01] = (Uint8)((hes_info.init_address >> 0) & 0xff);
	hes_info.player_rom[0x02] = (Uint8)((hes_info.init_address >> 8) & 0xff);
	hes_info.player_rom[0x03] = 0x4c;	/* JMP */
	hes_info.player_rom[0x04] = (Uint8)(((hes_info.player_rom_address + 3) >> 0) & 0xff);
	hes_info.player_rom[0x05] = (Uint8)(((hes_info.player_rom_address + 3) >> 8) & 0xff);

	//ɗǂʕ@vȂ
	if (strcmp((const char*)_pHesData + 0x40, hes_info.cosmic_fantasy_magic) == 0)
		hes_info.cosmic_fantasy = true;

	
	Uint32 mask = 0x2000;
	while (mask < hes_info.data_load_address + hes_info.data_size)
			mask <<= 1;
	

	*ppRom = (Uint8*)malloc(mask);
	if (*ppRom == NULL)
	{
		goto LOAD_ERROR;
	}
	memset(*ppRom, 0xFF, mask);
	--mask;

	memcpy(*ppRom + hes_info.data_load_address, _pHesData + 0x20, hes_info.data_size);
	return mask;

LOAD_ERROR:
	_pHesData = 0;
	_HesDataSize = 0;
	return 0;
}

Uint8 HES_GetPlayerRomValue(Uint32 Address)
{ 
	Address -= hes_info.player_rom_address;
	if (Address < 0x10)
		return hes_info.player_rom[Address];
	return 0xFF;
}

void HES_Close(Uint8* pRom)
{
	if (pRom)
		free(pRom);
}

bool __stdcall HES_Init(const void* pHesData, unsigned HesDataSize, unsigned SongNo, unsigned long SampleRate)
{
	if (HesDataSize <= 0x20 || pHesData == NULL) return false;

	_pHesData = (Uint8*)pHesData;
	_HesDataSize = HesDataSize;

	if (!MAINBOARD_Init(NULL))
		return false;

	_pHesData = 0;

	//̐lݒ肵Ȑl̂Ƃ̂ADPCMI[o[TvO
	Uint32 OverSampleRate = 1;
	if (SampleRate <= 48000)
		OverSampleRate = 4;
	else if (48000 < SampleRate && SampleRate <= 96000)
		OverSampleRate = 2;
	ADPCM_SetOverSampleRate(OverSampleRate);
	//APU_SetOverSampleRate(OverSampleRate);

	//over sample rateZbĝق]vȌvZȂėǂ
	//CDROM SetEffectVlume͌ݕsgp
	const Uint32 VolumeEffect = 1;	//1 == normal volume
	PSG_SetVolumeEffect(VolumeEffect);
	ADPCM_SetVolumeEffect(VolumeEffect);

	APU_SetSampleRate(SampleRate);
	if (APU_SetBufferSize(SampleRate / 60 + (SampleRate>>10)) == FALSE)	//1t[(60Hz)ŏo͂Tv傫lm
		return false;

// Ȃvgmƃpb`ł͏CłȂ̂ō폜B
//	if (hes_info.cosmic_fantasy && SongNo == 0x14)
//		PSG_SetCosmicFantasyTowerWave();
	
	for (unsigned i = 0; i < 8; i++) CPU_SetMPR(i, hes_info.init_mpr[i]);	
	CPU_SetPC(hes_info.player_rom_address);
	CPU_SetS(0xff);
	CPU_SetA(SongNo);
	
	Uint32 buflen = ((SampleRate / 50 + (SampleRate >> 10)) << 2);	//1t[(60Hz)ŏo͂Tv傫lm
	buffer.ptr = (Uint8*)malloc(buflen);
	if (!buffer.ptr)
	{
		return false;
	}
	buffer.len = buflen;
	buffer.fil = 0;
	buffer.cur = 0;

	return true;
}

unsigned __stdcall HES_GetFirstSongNo(void)
{
	if (_pHesData)
		return _pHesData[5];

	return 0;	
}


/*
void HES_SetSampleRate(unsigned SampleRate)
{
	
}
*/

void __stdcall HES_SetChannelMuting(unsigned int Mute)
{
	_ChannelMute = Mute;
	for (unsigned i = 0; i < 6; i++)
	{
		PSG_SetMutePsgChannel(i, (Mute & (1 << i)) ? TRUE : FALSE);
	}
	APU_SetMuteAdpcmChannel((Mute & (1 << 6)) ? TRUE: FALSE);
}

unsigned int __stdcall HES_GetChannelMuting(void)
{
	return _ChannelMute;
}



void __stdcall HES_Reset(unsigned SongNo)
{
	MAINBOARD_Reset();
	for (unsigned i = 0; i < 8; i++) CPU_SetMPR(i, hes_info.init_mpr[i]);
	CPU_SetPC(hes_info.player_rom_address);
	CPU_SetS(0xff);
	CPU_SetA(SongNo);
	buffer.fil = 0;
	buffer.cur = 0;
}

void __stdcall HES_Deinit(void)
{
	_pHesData = 0;
	_HesDataSize = 0;
	MAINBOARD_Deinit();
	if (buffer.ptr)
	{
		free(buffer.ptr);
		buffer.ptr = 0;
	}
	buffer.len = 0;
	buffer.fil = 0;
	buffer.cur = 0;

	hes_info.clear();
}

//APU.cppĂ΂
void HES_FlushBuffer(Uint16 * finalWave, unsigned length)
{
	if (length > buffer.len - buffer.fil)
	{
		length = buffer.len - buffer.fil;
	}
	if (length > 0)
	{
		CopyMemory(buffer.ptr + buffer.fil, finalWave, length);
		buffer.fil += length;
	}
}

//refferd to viogsf's drvimpl.cpp. thanks the author.
int __stdcall HES_UpdateSamples(void* pBuf, unsigned Buflen, unsigned Samples)
{
	int ret = 0;
	Uint32 bytes = Samples << 2;
	Uint8* des = (Uint8*)pBuf;

	while (bytes > 0)
	{
		Uint32 remain = buffer.fil - buffer.cur;
		while (remain == 0)
		{
			buffer.cur = 0;
			buffer.fil = 0;

			MAINBOARD_AdvanceFrame();
				
			remain = buffer.fil - buffer.cur;
		}
		Uint32 len = remain;
		if (len > bytes)
		{
			len = bytes;
		}
		CopyMemory(des, buffer.ptr + buffer.cur, len);
		bytes -= len;
		des += len;
		buffer.cur += len;
		ret += len;
	}
	return ret;

}


static HESPlayerApi g_hes_player_api =
{
	HES_Init, 
	HES_GetFirstSongNo, 
	HES_SetChannelMuting, 
	HES_GetChannelMuting, 
	HES_Reset, 
	HES_Deinit, 
	HES_UpdateSamples
};

HESPlayerApi* HESPlayerSetUp(void)
{
	return &g_hes_player_api;
}
