#ifndef INC_FOO_INPUT_HES_H
#define INC_FOO_INPUT_HES_H

// foobar2000 component for playing hes file
#include "stdafx.h"
#include "extended_m3u_playlist.h"
#include "../../hes_player/hes_player.h"


class input_hes : public input_stubs
{
private:
	
	HESPlayerApi*					m_api;

	//instance
#ifdef _DEBUG
	HINSTANCE						m_dll_hnd;
#else
	void*							m_dll_hnd;
#endif

	service_ptr_t<file>				m_file;			//handle of input file

	//buffer
	pfc::array_t<t_uint8>			m_file_buf;		// in-memory copy of input file
	t_size							m_file_buf_len;		// buffer size for memory copy of input file
	pfc::array_t<t_uint8>			m_decode_buf;	// decode buffer
	t_size							m_decode_buf_len;	// buffer size for decode buffer
	
	// about input file 
	pfc::string8					m_file_path;		// input file path
	t_filesize						m_file_len;		// input file size
		
	//song time
	int								m_song_len;
	int								m_fade_len;
	int								m_default_song_len;
	int								m_default_fade_len;
	int								m_default_loop_count;
	t_uint64						m_song_sample;
	t_uint64						m_fade_sample;
	bool							m_set_len;

	//playback
	int								m_index_num;
	unsigned int					m_first_subsong;
	unsigned int					m_total_subsong; // max of subsong
	t_uint32						m_sample_rate;
	static const unsigned int		m_channels;
	static const unsigned int		m_bps;
	double							m_volume;
	bool							m_play_infinitely;
	static const unsigned int		m_update_sample;	// buffer duration [sample]
	unsigned int					m_update_done;
	t_uint64						m_played_sample;	//played time [sample]
	bool							m_dynamic_info;		//reporting configuration dynamically

	//detect silence
	bool							m_detect_silence;
	int								m_silence_len;
	t_uint64						m_silence_sample;
	static const int				m_silence_level;
	t_uint64						m_detected_silence;

	//misc.
	bool							m_display_track_num;
	unsigned int					m_decode_flags;

	//extended_m3u_playlist class
	extended_m3u_playlist			m_exm3u;
	extended_m3u_playlist::info_t	m_exm3u_album_info;
	bool							m_exm3u_ignore;
	int								m_exm3u_load;
	int								m_exm3u_line;
	bool							m_exm3u_utf8_enc;

	void check_encode_meta_set_multi_field(file_info &p_info, const char* name, const char* value);
	void check_encode_meta_set(file_info &p_info, const char* name, const char* value);

	bool loaddll();
	void freedll();

public:
	
	input_hes() :
		m_file_buf_len(0),		m_decode_buf_len(0),		m_song_len(300000),				m_fade_len(5000), 
		m_set_len(false),		m_dynamic_info(false),		m_update_done(0),				m_first_subsong(0),
		m_played_sample(0),		m_detected_silence(0),		m_display_track_num(false),		m_volume(1.00), 
		m_total_subsong(255),	m_exm3u_ignore(false),		m_exm3u_line(0),				m_exm3u_load(0), 
		m_dll_hnd(0),			m_exm3u_utf8_enc(false),	m_play_infinitely(false),		m_decode_flags(0), 
		m_sample_rate(44100),   m_api(0)
	{}
	~input_hes();

	static bool g_is_our_path(const char *p_path, const char *p_extension);

	static bool g_is_our_content_type(const char *p_content_type) { return false; }
	
	void open(service_ptr_t<file> p_filehint, const char * p_path, t_input_open_reason p_reason, abort_callback &p_abort);
	t_filestats get_file_stats(abort_callback & p_abort) { return m_file->get_stats(p_abort); }
	unsigned get_subsong_count();
	t_uint32 get_subsong(unsigned p_index);
	void get_info(t_uint32 p_subsong, file_info &p_info, abort_callback &p_abort);
	
	bool decode_get_dynamic_info(file_info &p_out, double &p_timestamp_delta);
	bool decode_get_dynamic_info_track(file_info &p_out, double &p_timestamp_delta) { return false; }
	
	void decode_initialize(t_uint32 p_subsong, unsigned int p_flags, abort_callback &p_abort);
	bool decode_run(audio_chunk &p_chunk, abort_callback &p_abort);
	bool decode_can_seek();
	void decode_seek(double p_seconds, abort_callback &p_abort);
	void decode_on_idle(abort_callback & p_abort) { m_file->on_idle(p_abort); }

	void retag_set_info(t_uint32 p_subsong, const file_info &p_info, abort_callback &p_abort) { throw exception_io_unsupported_format(); }
	void retag_commit(abort_callback & p_abort){};

	static GUID g_get_guid()
	{
		return { 0x67eaa0a, 0xb8a3, 0x428d, { 0x8f, 0x74, 0xc3, 0x10, 0xfd, 0x4f, 0x15, 0x5 } };
	}

	static const char * g_get_name()
	{
		return "HES input";
	}

	static GUID g_get_preferences_guid()
	{
		return { 0xdcec94f6, 0x1c4b, 0x467c, { 0xb5, 0xcf, 0xf5, 0x8f, 0xce, 0x1d, 0x4a, 0x5d } };;
	}
};

#endif