#include "resource.h"
#include "../SDK/foobar2000.h"
#include "../helpers/helpers.h"
#include "foo_input_hes.h"
#include "cfg_int_t_atomic.h"



//static const GUID guid_prefs_hes = { 0xdcec94f6, 0x1c4b, 0x467c, { 0xb5, 0xcf, 0xf5, 0x8f, 0xce, 0x1d, 0x4a, 0x5d } };
static const GUID guid_cfg_default_song_len = { 0x3538e08a, 0xf424, 0x46cd, { 0x93, 0x5a, 0xe3, 0x99, 0x43, 0x4c, 0x56, 0xaf } };
static const GUID guid_cfg_default_fade_len = { 0x2981771, 0x4e7a, 0x4787, { 0xbd, 0xfa, 0x5c, 0x55, 0x30, 0xe0, 0xf8, 0xf } };
static const GUID guid_cfg_default_loop_count = { 0x8469adc7, 0x18f3, 0x42da, { 0x9a, 0x6b, 0x40, 0x59, 0x83, 0xc4, 0xb8, 0x38 } };
static const GUID guid_cfg_ignore_playlist = { 0x2e8c0fc2, 0x9581, 0x479d, { 0xad, 0x7b, 0x79, 0xf1, 0x19, 0xe2, 0x36, 0x13 } };
static const GUID guid_cfg_default_subsong_max = { 0x2339761c, 0xf135, 0x405b, { 0xa6, 0x3b, 0x32, 0x3d, 0x8b, 0x35, 0x75, 0xff } };
static const GUID guid_cfg_play_infinitely = { 0x65d08bf4, 0x8a4f, 0x4c50, { 0x94, 0x7e, 0x8a, 0x6f, 0xe1, 0x4a, 0xc8, 0x14 } };
static const GUID guid_cfg_detect_silence = { 0x53e70196, 0xc172, 0x4043, { 0xa2, 0xff, 0x2b, 0x67, 0xcf, 0x92, 0xa6, 0xaa } };
static const GUID guid_cfg_silence_len = { 0xdacf2a4f, 0x43cd, 0x47a2, { 0x99, 0x5b, 0x17, 0x2c, 0x5a, 0x77, 0xe8, 0xe9 } };
static const GUID guid_cfg_volume = { 0xbbf512f0, 0xa800, 0x4f7d, { 0xaa, 0x40, 0xff, 0x54, 0xa3, 0x9a, 0xdd, 0xfd } };
static const GUID guid_cfg_display_track_num = { 0x9fadde7a, 0x1d38, 0x481b, { 0xb5, 0xd2, 0x50, 0x53, 0xa0, 0x96, 0x6f, 0xec } };
static const GUID guid_cfg_channel_muting = { 0xe16b8130, 0x5123, 0x4d8c, { 0xae, 0xa7, 0x1d, 0x21, 0x3d, 0xa6, 0x67, 0x57 } };
static const GUID guid_cfg_sample_rate = { 0x57edfdfa, 0x86b9, 0x4a4c, { 0xb8, 0x85, 0x3a, 0x8a, 0xd0, 0xef, 0x58, 0x6c } };
static const GUID guid_cfg_support_hes = { 0xea40da90, 0x8983, 0x454b, { 0xb5, 0xad, 0x5c, 0xc9, 0xa3, 0x7e, 0x62, 0xd7 } };




cfg_int cfg_default_song_len(guid_cfg_default_song_len, 300000);
cfg_int cfg_default_fade_len(guid_cfg_default_fade_len, 5000);
cfg_int cfg_default_loop_count(guid_cfg_default_loop_count, 2);
cfg_int cfg_detect_silence(guid_cfg_detect_silence, 1);
cfg_int cfg_silence_len(guid_cfg_silence_len, 5);
cfg_int cfg_ignore_playlist(guid_cfg_ignore_playlist, false);
cfg_int cfg_default_subsong_max(guid_cfg_default_subsong_max, 255);
cfg_int cfg_play_infinitely(guid_cfg_play_infinitely, 0);
cfg_int cfg_volume(guid_cfg_volume, 100);
cfg_int cfg_display_track_num(guid_cfg_display_track_num, 0);
cfg_uint_atomic cfg_channel_muting(guid_cfg_channel_muting, 0, std::memory_order_relaxed);
cfg_int cfg_sample_rate(guid_cfg_sample_rate, 44100);
cfg_int cfg_support_hes(guid_cfg_support_hes, 1);



class preferences_page_instance_hes : public preferences_page_instance
{
	HWND m_parent;
	HWND m_hwnd;
	preferences_page_callback::ptr m_callback;

#define combo_sample_rate_count 17
#define hes_channel_count 7
static const char* const combo_sample_rate_name[combo_sample_rate_count];
static const unsigned combo_sample_rate_value[combo_sample_rate_count];

public:
	static BOOL CALLBACK ConfigProc(HWND wnd, UINT msg, WPARAM wp, LPARAM lp);

//Constructeor
	preferences_page_instance_hes(HWND parent, preferences_page_callback::ptr callback) : 
		m_parent(parent), 
		m_callback(callback)
	{
		m_hwnd = create(m_parent);
	}

	HWND get_wnd()
	{
		return m_hwnd;
	}

	HWND create(HWND p_parent)
	{
		return uCreateDialog(IDD_DIALOG1, p_parent, ConfigProc, reinterpret_cast<LPARAM>(this));
	}

	t_uint32 get_state()
	{
		unsigned cur_sample_rate_sel = SendDlgItemMessage(m_hwnd, IDC_SAMPLE_RATE, CB_GETCURSEL, 0, 0);

		if (cfg_play_infinitely != IsDlgButtonChecked(m_hwnd, IDC_PLAY_INFINITELY) ||
			cfg_default_song_len != uGetDlgItemInt(m_hwnd, IDC_DEFAULT_SONG_LEN, NULL, FALSE) ||
			cfg_default_fade_len != uGetDlgItemInt(m_hwnd, IDC_DEFAULT_FADE_LEN, NULL, FALSE) ||
			cfg_default_loop_count != uSendDlgItemMessage(m_hwnd, IDC_SPIN_DEFAULT_LOOP_COUNT, UDM_GETPOS, 0, 0) ||
			cfg_detect_silence != IsDlgButtonChecked(m_hwnd, IDC_DETECT_SILENCE) ||
			cfg_silence_len != uSendDlgItemMessage(m_hwnd, IDC_SPIN_SILENCE_LEN, UDM_GETPOS, 0, 0) ||
			cfg_display_track_num != IsDlgButtonChecked(m_hwnd, IDC_DISPLAY_TRACK_NUM) ||
			cfg_volume != uGetDlgItemInt(m_hwnd, IDC_VOLUME, NULL, FALSE) ||
			cfg_ignore_playlist != IsDlgButtonChecked(m_hwnd, IDC_IGNORE_PLAYLIST) ||
			cfg_default_subsong_max != uSendDlgItemMessage(m_hwnd, IDC_SPIN_DEFAULT_SUBSONG_MAX, UDM_GETPOS, 0, 0) ||
			cfg_sample_rate != combo_sample_rate_value[cur_sample_rate_sel] ||
			cfg_support_hes != IsDlgButtonChecked(m_hwnd, IDC_SUPPORT_HES)
			)
			return preferences_state::changed | preferences_state::resettable;
		return preferences_state::resettable;
	}

	void apply()
	{
		cfg_play_infinitely = IsDlgButtonChecked(m_hwnd, IDC_PLAY_INFINITELY);
		cfg_default_song_len = uGetDlgItemInt(m_hwnd, IDC_DEFAULT_SONG_LEN, NULL, FALSE);
		cfg_default_fade_len = uGetDlgItemInt(m_hwnd, IDC_DEFAULT_FADE_LEN, NULL, FALSE);
		cfg_default_loop_count = uSendDlgItemMessage(m_hwnd, IDC_SPIN_DEFAULT_LOOP_COUNT, UDM_GETPOS, 0, 0);
		cfg_detect_silence = IsDlgButtonChecked(m_hwnd, IDC_DETECT_SILENCE);
		cfg_silence_len = uSendDlgItemMessage(m_hwnd, IDC_SPIN_SILENCE_LEN, UDM_GETPOS, 0, 0);
		cfg_display_track_num = IsDlgButtonChecked(m_hwnd, IDC_DISPLAY_TRACK_NUM);

		cfg_volume = uGetDlgItemInt(m_hwnd, IDC_VOLUME, NULL, FALSE);
		if (cfg_volume > 500) cfg_volume = 500;
		if (cfg_volume <= 0) cfg_volume = 100;
		uSetDlgItemInt(m_hwnd, IDC_VOLUME, cfg_volume.get_value(), FALSE);

		cfg_ignore_playlist = IsDlgButtonChecked(m_hwnd, IDC_IGNORE_PLAYLIST);
		cfg_default_subsong_max = uSendDlgItemMessage(m_hwnd, IDC_SPIN_DEFAULT_SUBSONG_MAX, UDM_GETPOS, 0, 0);

		unsigned cur_sel = SendDlgItemMessage(m_hwnd, IDC_SAMPLE_RATE, CB_GETCURSEL, 0, 0);
		cfg_sample_rate = combo_sample_rate_value[cur_sel];

		cfg_support_hes = IsDlgButtonChecked(m_hwnd, IDC_SUPPORT_HES);
		m_callback->on_state_changed();
	}

	// Resets this page's content to the default values.
	// Does not apply any changes -
	// lets user preview the changes before hitting "apply".
	void reset()
	{
		CheckDlgButton(m_hwnd, IDC_PLAY_INFINITELY, BST_UNCHECKED);
		uSetDlgItemInt(m_hwnd, IDC_DEFAULT_SONG_LEN, 300000, FALSE);
		uSetDlgItemInt(m_hwnd, IDC_DEFAULT_FADE_LEN, 5000, FALSE);
		uSendDlgItemMessage(m_hwnd, IDC_SPIN_DEFAULT_LOOP_COUNT, UDM_SETPOS, 0, (LPARAM)MAKELONG(2, 0));
		CheckDlgButton(m_hwnd, IDC_DETECT_SILENCE, BST_CHECKED);
		uSendDlgItemMessage(m_hwnd, IDC_SPIN_SILENCE_LEN, UDM_SETPOS, 0, (LPARAM)MAKELONG(5, 0));
		CheckDlgButton(m_hwnd, IDC_DISPLAY_TRACK_NUM, BST_UNCHECKED);
		uSetDlgItemInt(m_hwnd, IDC_VOLUME, 100, FALSE);
		CheckDlgButton(m_hwnd, IDC_IGNORE_PLAYLIST, BST_UNCHECKED);
		uSendDlgItemMessage(m_hwnd, IDC_SPIN_DEFAULT_SUBSONG_MAX, UDM_SETPOS, 0, (LPARAM)MAKELONG(255, 0));

		uSendDlgItemMessage(m_hwnd, IDC_SAMPLE_RATE, CB_SETCURSEL, 5, 0);

		for (unsigned i = 0; i < hes_channel_count; i++)
		{
			CheckDlgButton(m_hwnd, IDC_MUTING1 + i, BST_UNCHECKED);
		}
		cfg_channel_muting.store(0);

		CheckDlgButton(m_hwnd, IDC_SUPPORT_HES, BST_CHECKED);
		m_callback->on_state_changed();
	}

};

const char * const preferences_page_instance_hes::combo_sample_rate_name[combo_sample_rate_count] = { "11025", "16000", "22050", "24000", "32000", "44100", "48000", "64000", "88200", "96000", "110250", "128000", "132300", "144000", "160000", "176400", "192000" };
const unsigned preferences_page_instance_hes::combo_sample_rate_value[combo_sample_rate_count] = { 11025, 16000, 22050, 24000, 32000, 44100, 48000, 64000, 88200, 96000, 110250, 128000, 132300, 144000, 160000, 176400, 192000 };


BOOL CALLBACK  preferences_page_instance_hes::ConfigProc(HWND wnd, UINT msg, WPARAM wp, LPARAM lp)
{
	switch (msg)
	{
	case WM_INITDIALOG:
	{
		uSetWindowLong(wnd, DWL_USER, lp);

		CheckDlgButton(wnd, IDC_PLAY_INFINITELY, (UINT)cfg_play_infinitely);
		uSetDlgItemInt(wnd, IDC_DEFAULT_SONG_LEN, cfg_default_song_len, FALSE);
		uSetDlgItemInt(wnd, IDC_DEFAULT_FADE_LEN, cfg_default_fade_len, FALSE);

		uSendDlgItemMessage(wnd, IDC_SPIN_DEFAULT_LOOP_COUNT, UDM_SETRANGE32, (WPARAM)0, (LPARAM)50);
		uSendDlgItemMessage(wnd, IDC_SPIN_DEFAULT_LOOP_COUNT, UDM_SETPOS, 0, (LPARAM)MAKELONG(cfg_default_loop_count, 0));

		CheckDlgButton(wnd, IDC_DETECT_SILENCE, (UINT)cfg_detect_silence);
		uSendDlgItemMessage(wnd, IDC_SPIN_SILENCE_LEN, UDM_SETRANGE32, (WPARAM)1, (LPARAM)3600);
		uSendDlgItemMessage(wnd, IDC_SPIN_SILENCE_LEN, UDM_SETPOS, 0, (LPARAM)MAKELONG(cfg_silence_len, 0));

		CheckDlgButton(wnd, IDC_DISPLAY_TRACK_NUM, (UINT)cfg_display_track_num);
		uSetDlgItemInt(wnd, IDC_VOLUME, cfg_volume, FALSE);
		CheckDlgButton(wnd, IDC_IGNORE_PLAYLIST, (UINT)cfg_ignore_playlist);

		uSendDlgItemMessage(wnd, IDC_SPIN_DEFAULT_SUBSONG_MAX, UDM_SETRANGE32, (WPARAM)0, (LPARAM)255);
		uSendDlgItemMessage(wnd, IDC_SPIN_DEFAULT_SUBSONG_MAX, UDM_SETPOS, 0, (LPARAM)MAKELONG(cfg_default_subsong_max, 0));

		//combo box
		HWND h = uGetDlgItem(wnd, IDC_SAMPLE_RATE);
		unsigned cur_sel = 0;
		for (unsigned i = 0; i < combo_sample_rate_count; i++)
		{
			uSendMessageText(h, CB_ADDSTRING, 0, combo_sample_rate_name[i]);
			if (cfg_sample_rate == combo_sample_rate_value[i])
				cur_sel = i;
		}
		::SendMessage(h, CB_SETCURSEL, cur_sel, 0);

		for (unsigned i = 0; i < hes_channel_count; i++)
		{
			CheckDlgButton(wnd, IDC_MUTING1 + i, (cfg_channel_muting.load() & (1 << i)));
		}

		CheckDlgButton(wnd, IDC_SUPPORT_HES, (UINT)cfg_support_hes);
		break;
	}
	case WM_COMMAND:
	{
		//Channel Muting. I will update them immediately.
		if (LOWORD(wp) >= IDC_MUTING1 && LOWORD(wp) < IDC_MUTING1 + hes_channel_count)
		{
			unsigned cur_channel = LOWORD(wp) - IDC_MUTING1;
			UINT checked = IsDlgButtonChecked(wnd, LOWORD(wp));

			cfg_channel_muting.fetch_and(~(1 << cur_channel));
			cfg_channel_muting.fetch_or(checked << cur_channel);

			break;
		}
		preferences_page_instance_hes* p_this;
		p_this = reinterpret_cast<preferences_page_instance_hes*> (uGetWindowLong(wnd, DWL_USER));
		switch (LOWORD(wp))
		{
		case IDC_DETECT_SILENCE: case IDC_DEFAULT_FADE_LEN: case IDC_PLAY_INFINITELY:
		case IDC_IGNORE_PLAYLIST: case IDC_DEFAULT_LOOP_COUNT: case IDC_SILENCE_LEN: case IDC_DEFAULT_SONG_LEN:
		case IDC_SPIN_DEFAULT_LOOP_COUNT: case IDC_SPIN_DEFAULT_SUBSONG_MAX: case IDC_DEFAULT_SUBSONG_MAX: case IDC_VOLUME:
		case IDC_DISPLAY_TRACK_NUM: case IDC_SPIN_SILENCE_LEN: case IDC_SAMPLE_RATE: case IDC_SUPPORT_HES:
			if (p_this) p_this->m_callback->on_state_changed();
			break;
		default:
			break;
		}
		break;
	}
	case WM_DESTROY:
	{
		uSetWindowLong(wnd, DWL_USER, 0);
		break;
	}
	default:
		return FALSE;
	}
	return TRUE;
}

class preferences_foo_input_hes : public preferences_page_v3
{
public:

	virtual const char * get_name()
	{
		return input_hes::g_get_name();
	}

	virtual GUID get_guid()
	{
		return input_hes::g_get_preferences_guid();
	}

	virtual GUID get_parent_guid()
	{
		return guid_input;
	}

	virtual preferences_page_instance::ptr instantiate(HWND parent, preferences_page_callback::ptr callback)
	{
		return new service_impl_t< preferences_page_instance_hes>(parent, callback);
	}

};

static preferences_page_factory_t<preferences_foo_input_hes> g_preferences_foo_input_hes;
