//////////////////////////////////////////////////////////////////////
//
// File:        bstypes.h
// Author:      Brian Postma
// Created:     30 December 1999
//
// Purpose:     All types and defines for the replayer.
//
//////////////////////////////////////////////////////////////////////

#ifndef  _TYPES_H_INCLUDED_
#define _TYPES_H_INCLUDED_

#include <stdio.h>
#include <unistd.h>

// Platform independent types

typedef unsigned char  BYTE;
typedef unsigned short WORD;
typedef unsigned long  DWORD;

// mixer settings

#define SAMPLERATE 44100

// Soundmon modstruct settings

#define SONGDATASIZE	32
#define INSTRSIZE		32
#define NUMINSTR		15
#define HEADERSIZE		(NUMINSTR*INSTRSIZE)+SONGDATASIZE
#define VOICES			4
#define NOTESPERPATTERN	16
#define NOTESIZE		3
#define PATTERNSIZE		NOTESPERPATTERN * NOTESIZE
#define STEPVOICESIZE	4
#define STEPSIZE		VOICES*STEPVOICESIZE
#define TABLESIZE		64
#define SYNTHFXSIZE		32

//#define PERTOFREQCONST	0x179d8 * 10
#define PERTOFREQCONST  8192 * 428

enum BS_ERROR
{
	BS_OK,
	BS_ERR_NO_V3_MODULE,
	BS_ERR_API,
	BS_ERR_MEMORY
};
#endif