//////////////////////////////////////////////////////////////////////
//
// File:        LSoundPlayer.h
// Author:      Brian Postma
// Created:     30 December 1999
//
// Purpose:     The hardware/OS dependent soundplayer layer. Provides
//              all means and methods to play sounds.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_LSOUNDPLAYER_H__7C349EF1_B2D7_11D3_BEBA_00104B26B3E4__INCLUDED_)
#define AFX_LSOUNDPLAYER_H__7C349EF1_B2D7_11D3_BEBA_00104B26B3E4__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#define BUFFERSIZE SAMPLERATE/50

#include <stdio.h>
#include <AudioUnit/AudioUnit.h>
#include <CoreAudio/AudioHardware.h>
#include "bstypes.h"
#include "LChannel.h"
#include "Module.h"

class LSoundPlayer
{
public:
	LSoundPlayer(Module *modptr);
	virtual ~LSoundPlayer();
	bool CleanUp();
	bool Initialize(short nrofvoices, bool stereo=true);
	bool Play(short voicenr, BYTE instrument, int frequency, int volume);
	bool Stop(short voicenr);
	bool SetPan(short voicenr, int val);
	bool SetFrequency(short voicenr, int frequency);
	bool SetVolume(short voicenr, int volume);
	bool Update(short voicenr, BYTE *memptr, int offset, int numofbytes);
        bool Mix();

private:
        Module				*modptr;
	short				nrofvoices;
        int				stereo;
        LChannel			*channels;
        static AudioUnit                outputAudioUnit;
};

#endif // !defined(AFX_LSOUNDPLAYER_H__7C349EF1_B2D7_11D3_BEBA_00104B26B3E4__INCLUDED_)