/***************************************************************************
                          tables.h  -  various data tables needed by MTP
			  can only be included once (duh).  this is lame and
			  ought to be a .c file.
                             -------------------
    begin                : Thu Dec 9 1999
    copyright            : (C) 1999 by Ian Schmidt
    email                : ischmidt@cfl.rr.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __TABLES_H__
#define __TABLES_H__

/* VolumeConversion table - helps prevent clipping on
   output with both our software mixer and the actual
   GS.  Direct GUS hardware mixing doesn't need this
   and you can get slightly better dynamics by bypassing
   this table. 

   There are 127 entries in this table.
 */

// the IIgs' 5503 would clip if you played many loud waves at
// high volumes.  Many GS music programs thus used a volume
// scaling table so the user saw 0-255 volumes but the chip
// only saw things in a safe range (0-192).  We could
// not use this, but the dynamics are more accurate to what
// you'd hear on the GS this way.

uint8 VolumeConversion[] = 
{
	0x00,0x02,0x04,0x05,0x06,0x07,0x09,0x0A,0x0C,0x0D,0x0F,
	0x10,0x12,0x13,0x15,0x16,0x18,0x19,0x1B,0x1C,0x1E,0x1F,
	0x21,0x22,0x24,0x25,0x27,0x28,0x2A,0x2B,0x2D,0x2E,0x30,
	0x31,0x33,0x34,0x36,0x37,0x39,0x3A,0x3C,0x3D,0x3F,0x40,
	0x42,0x43,0x45,0x46,0x48,0x49,0x4B,0x4C,0x4E,0x4F,0x51,
	0x52,0x54,0x55,0x57,0x58,0x5A,0x5B,0x5D,0x5E,0x60,0x61,
	0x63,0x64,0x66,0x67,0x69,0x6A,0x6C,0x6D,0x6F,0x70,0x72,
	0x73,0x75,0x76,0x78,0x79,0x7B,0x7C,0x7E,0x7F,0x81,0x82,
	0x84,0x85,0x87,0x88,0x8A,0x8B,0x8D,0x8E,0x90,0x91,0x93,
	0x94,0x96,0x97,0x99,0x9A,0x9C,0x9D,0x9F,0xA0,0xA2,0xA3,
	0xA5,0xA6,0xA8,0xA9,0xAB,0xAC,0xAE,0xAF,0xB1,0xB2,0xB4,
	0xB5,0xB7,0xB8,0xBA,0xBB,0xBD,0xBE,0xC0,0xC0
};

// IIgs DOC frequency tables.  multiply by 51 to get
// the playback rate in Hz.

// SS/MT DOC pitch table

uint16 FreqTable[] = 
{
	0x00,0x16,0x17,0x18,0x1A,0x1B,0x1D,0x1E,0x20,0x22,0x24,0x26,
	0x29,0x2B,0x2E,0x31,0x33,0x36,0x3A,0x3D,0x41,0x45,0x49,0x4D,
	0x52,0x56,0x5C,0x61,0x67,0x6D,0x73,0x7A,0x81,0x89,0x91,0x9A,
	0xA3,0xAD,0xB7,0xC2,0xCE,0xD9,0xE6,0xF4,0x102,0x112,0x122,0x133,
	0x146,0x15A,0x16F,0x184,0x19B,0x1B4,0x1CE,0x1E9,0x206,0x225,0x246,
	0x269,0x28D,0x2B4,0x2DD,0x309,0x337,0x368,0x39C,0x3D3,0x40D,0x44A,
	0x48C,0x4D1,0x51A,0x568,0x5BA,0x611,0x66E,0x6D0,0x737,0x7A5,0x81A,
	0x895,0x918,0x9A2,0xA35,0xAD0,0xB75,0xC23,0xCDC,0xD9F,0xE6F,0xF4B,
	0x1033,0x112A,0x122F,0x1344,0x1469,0x15a0,0x16e9,0x1846,0x19B7,0x1b3F,
	0x1cde,0x1e95,0x2066,0x2254,0x245e,0x2688
};

// MIDI DOC table.  down 1 octave from SS version
uint16 MIDIFreqTable[] = 
{
	0x00,0xb,0xb,0xc,0xd,0xd,0xe,0xe,0x10,0x11,0x12,0x13,
	0x00,0x16,0x17,0x18,0x1A,0x1B,0x1D,0x1E,0x20,0x22,0x24,0x26,
	0x29,0x2B,0x2E,0x31,0x33,0x36,0x3A,0x3D,0x41,0x45,0x49,0x4D,
	0x52,0x56,0x5C,0x61,0x67,0x6D,0x73,0x7A,0x81,0x89,0x91,0x9A,
	0xA3,0xAD,0xB7,0xC2,0xCE,0xD9,0xE6,0xF4,0x102,0x112,0x122,0x133,
	0x146,0x15A,0x16F,0x184,0x19B,0x1B4,0x1CE,0x1E9,0x206,0x225,0x246,
	0x269,0x28D,0x2B4,0x2DD,0x309,0x337,0x368,0x39C,0x3D3,0x40D,0x44A,
	0x48C,0x4D1,0x51A,0x568,0x5BA,0x611,0x66E,0x6D0,0x737,0x7A5,0x81A,
	0x895,0x918,0x9A2,0xA35,0xAD0,0xB75,0xC23,0xCDC,0xD9F,0xE6F,0xF4B,
	0x1033,0x112A,0x122F,0x1344,0x1469,0x15a0,0x16e9,0x1846,0x19B7,0x1b3F,
	0x1cde,0x1e95,0x2066,0x2254,0x245e,0x2688
};


// the vibrato sine table (you didn't think I had the GS
// doing these multiplys on the fly, did you?)

uint16 SineTable[] =
{
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0x0000,0x0000,0x0000,0x0001,0x0001,0x0001,0x0001,0x0001, /* depth=1 (32) */
	0x0001,0x0001,0x0001,0x0001,0x0001,0x0001,0x0000,0x0000,
        0x0000,000000,0xff00,0xffff,0xffff,0xffff,0xffff,0xffff,
        0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x0000,0x0000,
        0x0000,0x0000,0x0001,0x0002,0x0002,0x0003,0x0003,0x0003, /* depth=2 (64) */
	0x0003,0x0003,0x0003,0x0003,0x0002,0x0002,0x0001,0x0000,
        0x0000,0x0000,0xffff,0xfffe,0xfffe,0xfffd,0xfffd,0xfffd,
        0xfffd,0xfffd,0xfffd,0xfffd,0xfffe,0xfffe,0xffff,0x0000,
        0x0000,0x0001,0x0002,0x0003,0x0004,0x0004,0x0005,0x0005, /* depth=3 (96) */
	0x0005,0x0005,0x0005,0x0004,0x0004,0x0003,0x0002,0x0001,
        0x0000,0xffff,0xfffe,0xfffd,0xfffc,0xfffc,0xfffb,0xfffb,
        0xfffb,0xfffb,0xfffb,0xfffc,0xfffc,0xfffd,0xfffe,0xffff,
        0x0000,0x0001,0x0003,0x0004,0x0005,0x0006,0x0007,0x0007, /* depth=4 */
	0x0007,0x0007,0x0007,0x0006,0x0005,0x0004,0x0003,0x0001,
        0x0000,0xffff,0xfffd,0xfffc,0xfffb,0xfffa,0xffff,0xfff9,
        0xfff9,0xfff9,0xfff9,0xfffa,0xfffb,0xfffc,0xfffd,0xffff,      
        0x0000,0x0001,0x0003,0x0005,0x0007,0x0008,0x0009,0x0009, /* depth=5 */
	0x0009,0x0009,0x0009,0x0008,0x0007,0x0005,0x0003,0x0001,
        0x0000,0xffff,0xfffd,0xfffb,0xfff9,0xfff8,0xfff7,0xfff7,
        0xfff7,0xfff7,0xfff7,0xfff8,0xfff9,0xfffb,0xfffd,0xffff,
        0x0000,0x0002,0x0004,0x0006,0x0008,0x0009,0x000A,0x000B, /* depth=6 */
	0x000B,0x000B,0x000A,0x0009,0x0008,0x0006,0x0004,0x0002,
        0x0000,0xFFFE,0xFFFC,0xFFFA,0xFFF8,0xFFF7,0xFFF6,0xFFF5,
        0xFFF5,0xFFF5,0xFFF6,0xFFF7,0xFFF8,0xFFFA,0xFFFC,0xFFFE,
        0x0000,0x0002,0x0005,0x0007,0x0009,0x000B,0x000C,0x000D, /* depth=7 */
	0x000D,0x000D,0x000C,0x000B,0x0009,0x0007,0x0005,0x0002,
        0x0000,0xFFFE,0xFFFB,0xFFF9,0xFFF7,0xFFF5,0xFFF4,0xFFF3,
        0xFFF3,0xFFF3,0xFFF4,0xFFF5,0xFFF7,0xFFF9,0xFFFB,0xFFFE,
        0x0000,0x0003,0x0006,0x0008,0x000B,0x000D,0x000E,0x000F, /* depth=8 */
	0x000F,0x000F,0x000E,0x000D,0x000B,0x0008,0x0006,0x0003,
        0x0000,0xFFFD,0xFFFA,0xFFF8,0xFFF5,0xFFF3,0xFFF2,0xFFF1,
        0xFFF1,0xFFF1,0xFFF2,0xFFF3,0xFFF5,0xFFF8,0xFFFA,0xFFFD,
        0x0000,0x0003,0x0006,0x0009,0x000C,0x000E,0x0001,0x0011, /* depth=9 */
        0x0011,0x0011,0x0010,0x000E,0x000C,0x0009,0x0006,0x0003,
        0x0000,0xFFFD,0xFFFA,0xFFF7,0xFFF4,0xFFF2,0xFFF0,0xFFFE,
        0xFFEF,0xFFEF,0xFFF0,0xFFF2,0xFFF4,0xFFF7,0xFFFA,0xFFFD,
        0x0000,0x0003,0x0007,0x000B,0x000E,0x0010,0x0012,0x0013, /* depth=A */
        0x0013,0x0013,0x0012,0x0010,0x000E,0x000B,0x0007,0x0003,
        0x0000,0xFFFD,0xFFF9,0xFFF5,0xFFF2,0xFFF0,0xFFEE,0xFFED,
        0xFFED,0xFFED,0xFFEE,0xFFF0,0xFFF2,0xFFF5,0xFFF9,0xFFFD,
        0x0000,0x0004,0x0008,0x000C,0x000F,0x0012,0x0014,0x0015, /* depth=B */
        0x0015,0x0015,0x0014,0x0012,0x000F,0x000C,0x0008,0x0004,
        0x0000,0xFFFC,0xFFF8,0xFFF4,0xFFF1,0xFFEE,0xFFEC,0xFFEB,
        0xFFEB,0xFFEB,0xFFEC,0xFFEE,0xFFF1,0xFFF4,0xFFF8,0xFFFC,
        0x0000,0x0004,0x0009,0x000D,0x0010,0x0013,0x0015,0x0017, /* depth=C */
        0x0017,0x0017,0x0015,0x0013,0x0010,0x000D,0x0009,0x0004,
        0x0000,0xFFFC,0xFFF7,0xFFF3,0xFFF0,0xFFED,0xFFEB,0xFFE9,
        0xFFE9,0xFFE9,0xFFEB,0xFFED,0xFFF0,0xFFF3,0xFFF7,0xFFFC,
        0x0000,0x0005,0x0009,0x000E,0x0012,0x0015,0x0017,0x0019, /* depth=D */
        0x0019,0x0019,0x0017,0x0015,0x0012,0x000E,0x0009,0x0005,
        0x0000,0xFFFB,0xFFF7,0xFFF2,0xFFEE,0xFFEB,0xFFE9,0xFFE7,
        0xFFE7,0xFFE7,0xFFE9,0xFFEB,0xFFEE,0xFFF2,0xFFF7,0xFFFB,      
        0x0000,0x0005,0x000A,0x000F,0x0013,0x0017,0x0019,0x001B, /* depth=E */
        0x0013,0x0017,0x0019,0x001B,0x001B,0x001B,0x0019,0x0017,
        0x0013,0x000F,0x000A,0x0005,0x0000,0xFFFB,0xFFF6,0xFFF1,
        0xFFED,0xFFE9,0xFFE7,0xFFE5,0xFFE5,0xFFE5,0xFFE7,0xFFE9,
        0xFFED,0xFFF1,0xFFF6,0xFFFB,0x0000,0x0005,0x000B,0x0010, /* depth=F */
        0x0015,0x0018,0x001B,0x001D,0x001D,0x001D,0x001B,0x0018,
        0x0015,0x0010,0x000B,0x0005,0x0000,0xFFFB,0xFFF5,0xFFF0,
        0xFFEB,0xFFE8,0xFFE5,0xFFE3,0xFFE3,0xFFE3,0xFFE5,0xFFE8,
        0xFFEB,0xFFF0,0xFFF5,0xFFFB,0x0000,0x0000,0x0000,0x0000
};

#endif
