/***************************************************************************
                          main.c  -  Main program (traditional C main())
                             -------------------
    begin                : Wed Dec  8 23:53:24 EST 1999
    copyright            : (C) 1999-2000 by Ian Schmidt
    email                : ischmidt@cfl.rr.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "mtptypes.h"
#include "file.h"
#include "ssmt.h"
#include "ntgs.h"
#include "smus.h"
#include "oss.h"

// local protos
void _ShowUsage(void);

// static variables

// input plugin table - add your input plugin to this table
// and it will automatically be "hooked up"
static MTPInputT *input_plugins[] =
{
	&ssmt_plugin,		// soundsmith/megatracker
	&ntgs_plugin,		// noisetracker GS
	&smus_plugin,		// will harvey SMUS
	(MTPInputT *)NULL	
};

// functions
int main(int argc, char *argv[])
{
	int16 arg, ftype;
	int8 scroll = 0;
	int8 oldstyle = 0;

	// print startup info	
	printf("\nMegaTracker Player for %s v4.3.1 [27-OCT-2000]\n", PLAT_NAME);
	printf("Written by and copyright (c) 1996-2000 Ian Schmidt.\n");
	printf("This software comes with ABSOLUTELY NO WARRANTY.\n");
	printf("Refer to the file COPYING for details.\n");
	printf("\n");

	// we need at least one argument
	if (argc < 2)
	{
		_ShowUsage();
		exit(-1);
	}
	
	// now scan for arguments.  yes there's ways to do this, but none
	// are portable.
	arg = 1;

	// note: following line uses short-circuit evaluation.
	// the order of tests is important lest a segfault happen.
	while ((arg < argc) && (argv[arg][0] == '-'))	// get all minus options
	{
		switch (argv[arg][1])
		{
			case 's':
			case 'S':
				scroll = 1;
				break;

			case 'o':
			case 'O':
			  	oldstyle = 1;
				break;	

			case 'v':
			case 'V':
				ftype = 0;
				printf("================================\n");
				while (input_plugins[ftype] != (MTPInputT *)NULL)
				{
					printf("Plugin %d is: \n%s", ftype+1, input_plugins[ftype]->VerString());
					printf("================================\n");
					ftype++;
				}
				exit(0);
				break;

			default:
				printf("Unknown switch -%c.\n", argv[arg][1]);
				break;
		}

		arg++;
	}

	if (argc <= arg)
	{
		_ShowUsage();
		exit(-1);
	}

	// now ask each of our filetype "objects" if they can handle this
	ftype = 0;

	while (input_plugins[ftype] != (MTPInputT *)NULL)
	{
		if (input_plugins[ftype]->IsFile(argv[arg]))
		{
			printf("File identified: %s\n", input_plugins[ftype]->TypeName());
			break;
		}
		else
		{
			ftype++;
		}
	}

	// did we find one?
	if (input_plugins[ftype] == (MTPInputT *)NULL)
	{
		printf("Sorry, I don't know how to handle this type of file.\n");
		exit(-1);
	}
	
	// init output driver (must be before xx_LoadFile call to init inst. structs)
	if (GUS_Init())
	{
		printf("Output driver initialized\n");
	}
	else
	{
		printf("Error opening output driver\n");
		exit(-1);
	}

	// now load the file
	input_plugins[ftype]->LoadFile(argv[arg]);

	// start playback
	input_plugins[ftype]->SetOldstyle(oldstyle);
	input_plugins[ftype]->SetScroll(scroll);
	input_plugins[ftype]->PlayStart();

	// start the output plugin
	GUS_PlayStart();

	// main playback loop (should thread this off)
	while (input_plugins[ftype]->GetSongStat())
	{
		GUS_TimeCheck();
	}

	GUS_Exit();
	
	return EXIT_SUCCESS;
}

void _ShowUsage(void)
{
	printf("Usage: mtp [switches] file\n");
	printf("file is a MTPNG compatible song.\n");
	printf("\n Switches:\n");
	printf("   -o: (SS/MT only): use old pitchslides\n");
	printf("   -s: show scrolling display\n");
	printf("   -v: show versions of MTPng modules\n");
	exit(-1);
}
