/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.swingui.projectui;

import java.awt.KeyEventDispatcher;
import java.awt.event.KeyEvent;
import javax.swing.Action;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import uk.org.toot.audio.server.NonRealTimeAudioServer;
import uk.org.toot.project.SingleTransportProject;
import uk.org.toot.swingui.projectui.SingleProjectPanel;
import uk.org.toot.swingui.transportui.TransportActions;
import uk.org.toot.swingui.transportui.TransportToggleButton;
import uk.org.toot.transport.Transport;

public class SingleTransportProjectPanel
extends SingleProjectPanel {
    private Transport transport;
    private TransportActions transportActions;
    private KeyEventDispatcher transportDispatcher;

    public SingleTransportProjectPanel(SingleTransportProject p, JToolBar toolBar) {
        super(p, toolBar);
        this.transport = p.getTransport();
        this.transportActions = new TransportActions(this.transport);
        NonRealTimeAudioServer nonRealTimeAudioServer = p.getNonRealTimeAudioServer();
        if (nonRealTimeAudioServer != null) {
            Action realTimeAction = this.transportActions.getRealTimeAction(nonRealTimeAudioServer);
            toolBar.addSeparator();
            toolBar.add(new TransportToggleButton(realTimeAction));
        }
        TransportActions.addTransportTools(this.transportActions, toolBar);
    }

    protected void dispose() {
        this.unhookKeys();
        this.transportActions.dispose();
        this.transportActions = null;
        super.dispose();
    }

    public void addNotify() {
        super.addNotify();
        this.hookKeys();
    }

    public void removeNotify() {
        super.removeNotify();
        this.unhookKeys();
    }

    protected void hookKeys() {
        this.getInputMap().put(KeyStroke.getKeyStroke(96, 0), "stop");
        this.getActionMap().put("stop", this.transportActions.getStopAction());
        this.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "play");
        this.getActionMap().put("play", this.transportActions.getPlayAction());
        this.getInputMap().put(KeyStroke.getKeyStroke(106, 0), "record");
        this.getActionMap().put("record", this.transportActions.getRecordAction());
    }

    protected void unhookKeys() {
        this.getInputMap().remove(KeyStroke.getKeyStroke(96, 0));
        this.getActionMap().remove("stop");
        this.getInputMap().remove(KeyStroke.getKeyStroke(10, 0));
        this.getActionMap().remove("play");
        this.getInputMap().remove(KeyStroke.getKeyStroke(106, 0));
        this.getActionMap().remove("record");
    }

    protected class TransportKeyEventDispatcher
    implements KeyEventDispatcher {
        protected TransportKeyEventDispatcher() {
        }

        public boolean dispatchKeyEvent(KeyEvent e) {
            if (e.getID() == 400) {
                this.printTyped(e);
            } else if (e.getID() == 401) {
                this.println("Pressed", e);
            } else if (e.getID() == 402) {
                this.println("Released", e);
            }
            return false;
        }

        private void printTyped(KeyEvent e) {
            System.out.println("Typed : char=" + e.getKeyChar() + ", mod=" + KeyEvent.getKeyModifiersText(e.getModifiers()));
        }

        private void println(String prefix, KeyEvent e) {
            System.out.println(String.valueOf(prefix) + ": text=" + KeyEvent.getKeyText(e.getKeyCode()) + ", code=" + e.getKeyCode() + ", loc=" + e.getKeyLocation() + ", mod=" + KeyEvent.getKeyModifiersText(e.getModifiers()));
        }
    }
}

