/*
 * Decompiled with CFR 0.152.
 */
package uk.org.toot.swingui.midixui.controlui.neckui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Toolkit;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import uk.org.toot.midix.control.neck.ChordShape;
import uk.org.toot.midix.control.neck.StrungNeck;
import uk.org.toot.music.tonality.Pitch;

public class NeckView
extends JComponent {
    private StrungNeck neck;
    private float tet12 = 1.0594631f;

    public NeckView(StrungNeck aNeck) {
        this.neck = aNeck;
    }

    public Dimension getPreferredSize() {
        return new Dimension(Toolkit.getDefaultToolkit().getScreenSize().width - 10, 32 * this.neck.getStringCount());
    }

    public int getPixelsPerString() {
        return this.getHeight() / (this.neck.getStringCount() + 1);
    }

    public StrungNeck getNeck() {
        return this.neck;
    }

    public StrungNeck.TunedString getString(int s) {
        return this.getNeck().getString(s);
    }

    public int getStringCount() {
        return this.getNeck().getStringCount();
    }

    public int getFrets() {
        return this.getNeck().getFrets();
    }

    protected void paintComponent(Graphics g) {
        this.paintFrets(g);
        this.paintStrings(g);
    }

    protected void paintFrets(Graphics g) {
        int centre = this.getStringCount() / 2;
        int o = this.getPixelsPerString() / 2;
        int i = 0;
        while (i <= this.getFrets()) {
            if (i > 0) {
                g.setColor(Color.darkGray);
                int xpos = (this.xfret(i) + this.xfret(i - 1)) / 2;
                if (i == 3 || i == 5 || i == 7 || i == 9 || i == 15 || i == 17 || i == 19 || i == 21) {
                    g.fillOval(xpos - 4, this.ystring(centre) + o, 8, 8);
                } else if (i == 12 || i == 24) {
                    g.fillOval(xpos - 4, this.ystring(centre + 1) + o, 8, 8);
                    g.fillOval(xpos - 4, this.ystring(centre - 1) + o, 8, 8);
                }
            }
            g.setColor(Color.black);
            g.drawLine(this.xfret(i), this.ystring(0) + o, this.xfret(i), this.ystring(this.getStringCount() - 1) - o);
            g.drawString(i > 0 ? String.valueOf(i) : "Nut", this.xfret(i) - 16, this.ystring(0) + o + 12);
            ++i;
        }
    }

    protected void paintStrings(Graphics g) {
        g.setColor(Color.black);
        int i = 0;
        while (i < this.getStringCount()) {
            g.drawLine(31, this.ystring(i), this.getWidth() - 42, this.ystring(i));
            g.drawString(Pitch.name(this.getString(i).getOpenTuning()), 0, this.ystring(i) + 4);
            ++i;
        }
    }

    protected int xfret(int fret) {
        int w = (int)((double)this.getWidth() * 1.2);
        return w - (int)((double)(w - 42) / Math.pow(this.tet12, fret)) + 24;
    }

    protected int ystring(int string) {
        return this.getHeight() - string * this.getPixelsPerString() - this.getPixelsPerString();
    }

    protected int fret(int x) {
        int fret = 0;
        int nfrets = this.getFrets();
        while (this.xfret(fret) < x && fret <= nfrets) {
            ++fret;
        }
        return fret;
    }

    protected int string(int y) {
        int s = (this.getHeight() - y - this.getPixelsPerString() / 2) / this.getPixelsPerString();
        if (s >= this.getStringCount()) {
            s = this.getStringCount() - 1;
        }
        return s;
    }

    protected void barre(final int fret) {
        this.getNeck().barre(fret);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Graphics g = NeckView.this.getGraphics();
                g.setColor(Color.white);
                int from = NeckView.this.getStringCount() - NeckView.this.getNeck().getBarreSize();
                g.drawLine(NeckView.this.xfret(fret), NeckView.this.ystring(from) + 8, NeckView.this.xfret(fret), NeckView.this.ystring(NeckView.this.getStringCount() - 1) - 8);
            }
        });
    }

    protected void shape(int f, ChordShape shape, int firstString) {
        this.getNeck().shape(f, shape, firstString);
        this.repaint();
    }

    protected void mute() {
        this.getNeck().mute();
        this.repaint();
    }

    protected void muteString(int str) {
        StrungNeck.TunedString string = this.getString(str);
        string.mute();
    }

    protected boolean pickString(final int str, boolean up, int velocity) {
        final StrungNeck.TunedString string = this.getString(str);
        if (string.getFret() < 0) {
            velocity = 0;
        }
        string.pick(up, velocity);
        if (velocity < 1) {
            return false;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Graphics g = NeckView.this.getGraphics();
                g.setColor(Color.white);
                g.drawLine(NeckView.this.xfret(string.getFret()), NeckView.this.ystring(str), NeckView.this.getWidth() - 42, NeckView.this.ystring(str));
                g.setColor(Color.black);
                g.drawString(Pitch.name(NeckView.this.getString(str).getNote()), NeckView.this.getWidth() - 38, NeckView.this.ystring(str) + 4);
            }
        });
        return true;
    }

    protected void setBending(int str, boolean b) {
        StrungNeck.TunedString string = this.getString(str);
        if (string == null) {
            return;
        }
        string.setBending(b);
    }
}

